/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.req.sysml.assistant.command;

import java.util.ArrayList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class ExtractCommentCommand
extends RecordingCommand {
    protected ArrayList<Element> selectedElements;

    public ExtractCommentCommand(TransactionalEditingDomain domain, ArrayList<Element> selectedElements) {
        super(domain, "ExtractCommentCommand");
        this.selectedElements = selectedElements;
    }

    protected void createAnnotatedComment(Element owner, String text) {
        Comment comment = owner.createOwnedComment();
        comment.getAnnotatedElements().add((Object)owner);
        comment.setBody(text);
    }

    protected void parseAndExecute(Class req) {
        Stereotype reqStereotype = req.getAppliedStereotype("SysML::Requirements::Requirement");
        String text = (String)req.getValue(reqStereotype, "text");
        if ((text = text.trim()).startsWith("[")) {
            int index = text.indexOf("]");
            String stakeholders = text.substring(0, index + 1);
            text = text.substring(index + 1);
            text = text.trim();
            this.createAnnotatedComment((Element)req, "STAKEHOLDERS:" + stakeholders);
            req.setValue(reqStereotype, "text", (Object)text);
        }
    }

    protected void doExecute() {
        for (Element currentElement : this.selectedElements) {
            if (currentElement.getAppliedStereotype("SysML::Requirements::Requirement") == null) continue;
            this.parseAndExecute((Class)currentElement);
        }
    }
}

