/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.generators.common.mmqueries;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.RobotML.Transition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSMQueries {
    public List<Vertex> getStates(StateMachine sm) {
        LinkedList<Vertex> res = new LinkedList<Vertex>();
        for (Region region : sm.getRegions()) {
            for (Vertex vertex : region.getSubvertices()) {
                res.add(vertex);
            }
        }
        return res;
    }

    public List<Transition> getTransitions(StateMachine sm) {
        LinkedList<Transition> res = new LinkedList<Transition>();
        for (Region region : sm.getRegions()) {
            for (org.eclipse.uml2.uml.Transition transition : region.getTransitions()) {
                Transition robotml_transition = (Transition)UMLUtil.getStereotypeApplication((Element)transition, Transition.class);
                if (robotml_transition == null) continue;
                res.add(robotml_transition);
            }
        }
        return res;
    }

    public List<StateMachine> getStateMachines(Element elt) {
        LinkedList<StateMachine> res = new LinkedList<StateMachine>();
        for (Element child : elt.getOwnedElements()) {
            if (!(child instanceof StateMachine)) continue;
            res.add((StateMachine)child);
        }
        return res;
    }
}

