/*
 * Decompiled with CFR 0.152.
 */
package SoaML.util;

import SoaML.Agent;
import SoaML.Attachment;
import SoaML.Capability;
import SoaML.Catalog;
import SoaML.Categorization;
import SoaML.Category;
import SoaML.CategoryValue;
import SoaML.Collaboration;
import SoaML.CollaborationUse;
import SoaML.Consumer;
import SoaML.Expose;
import SoaML.FreeFormDescriptor;
import SoaML.FreeFormValue;
import SoaML.MessageType;
import SoaML.Milestone;
import SoaML.MotivationElement;
import SoaML.MotivationRealization;
import SoaML.NodeDescriptor;
import SoaML.Participant;
import SoaML.Port;
import SoaML.Property;
import SoaML.Provider;
import SoaML.Request;
import SoaML.Service;
import SoaML.ServiceChannel;
import SoaML.ServiceContract;
import SoaML.ServiceInterface;
import SoaML.ServicesArchitecture;
import SoaML.SoaMLPackage;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class SoaMLValidator
extends EObjectValidator {
    public static final SoaMLValidator INSTANCE = new SoaMLValidator();
    public static final String DIAGNOSTIC_SOURCE = "SoaML";
    public static final int AGENT__IS_ACTIVE = 1;
    public static final int PARTICIPANT__NO_REALIZED_USED_INTERFACE = 2;
    public static final int PARTICIPANT__PORT_TYPES = 3;
    public static final int MESSAGE_TYPE__NO_OWNED_BEHAVIORS = 4;
    public static final int MESSAGE_TYPE__NO_OWNED_OPERATIONS = 5;
    public static final int MESSAGE_TYPE__PUBLIC_ATTRIBUTES = 6;
    public static final int SERVICE_CONTRACT__ROLE_TYPE = 7;
    public static final int SERVICE_CONTRACT__ATTACHED_BEHAVIOR_COMPATIBILITY = 8;
    public static final int REQUEST__REQUEST_TYPE = 9;
    public static final int REQUEST__IS_CONJUGATED_TRUE = 10;
    public static final int SERVICE_INTERFACE__PARTS_TYPES_OF_SERVICE_INTERFACE = 11;
    public static final int SERVICES_ARCHITECTURE__PARTICIPANTS_ROLE_COMPATIBILITY = 12;
    public static final int SERVICES_ARCHITECTURE__PARTS_TYPES = 13;
    public static final int COLLABORATION_USE__ROLE_BINDING_CLIENT_SUPPLIER_COMPATIBILITY = 14;
    public static final int SERVICE_CHANNEL__ONLYBINARYCONNECTORSALLOWED = 15;
    public static final int SERVICE_CHANNEL__SERVICE_CHANNEL_END_TYPES = 16;
    public static final int SERVICE_CHANNEL__COMPATIBILITY = 17;
    public static final int SERVICE__SERVICE_TYPE = 18;
    public static final int SERVICE__IS_CONJUGATED_FALSE = 19;
    public static final int PORT__CONNECTOR_REQUIRED = 20;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 20;
    protected static final int DIAGNOSTIC_CODE_COUNT = 20;

    protected EPackage getEPackage() {
        return SoaMLPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAgent((Agent)value, diagnostics, context);
            }
            case 1: {
                return this.validateParticipant((Participant)value, diagnostics, context);
            }
            case 2: {
                return this.validateCollaboration((Collaboration)value, diagnostics, context);
            }
            case 3: {
                return this.validateMotivationElement((MotivationElement)value, diagnostics, context);
            }
            case 4: {
                return this.validateProvider((Provider)value, diagnostics, context);
            }
            case 5: {
                return this.validateFreeFormValue((FreeFormValue)value, diagnostics, context);
            }
            case 6: {
                return this.validateMessageType((MessageType)value, diagnostics, context);
            }
            case 7: {
                return this.validateCategory((Category)value, diagnostics, context);
            }
            case 8: {
                return this.validateNodeDescriptor((NodeDescriptor)value, diagnostics, context);
            }
            case 9: {
                return this.validateMilestone((Milestone)value, diagnostics, context);
            }
            case 10: {
                return this.validateFreeFormDescriptor((FreeFormDescriptor)value, diagnostics, context);
            }
            case 11: {
                return this.validateCategoryValue((CategoryValue)value, diagnostics, context);
            }
            case 12: {
                return this.validateServiceContract((ServiceContract)value, diagnostics, context);
            }
            case 13: {
                return this.validateRequest((Request)value, diagnostics, context);
            }
            case 14: {
                return this.validateConsumer((Consumer)value, diagnostics, context);
            }
            case 15: {
                return this.validateCatalog((Catalog)value, diagnostics, context);
            }
            case 16: {
                return this.validateCapability((Capability)value, diagnostics, context);
            }
            case 17: {
                return this.validateCategorization((Categorization)value, diagnostics, context);
            }
            case 18: {
                return this.validateMotivationRealization((MotivationRealization)value, diagnostics, context);
            }
            case 19: {
                return this.validateServiceInterface((ServiceInterface)value, diagnostics, context);
            }
            case 20: {
                return this.validateServicesArchitecture((ServicesArchitecture)value, diagnostics, context);
            }
            case 21: {
                return this.validateAttachment((Attachment)value, diagnostics, context);
            }
            case 22: {
                return this.validateCollaborationUse((CollaborationUse)value, diagnostics, context);
            }
            case 23: {
                return this.validateServiceChannel((ServiceChannel)value, diagnostics, context);
            }
            case 24: {
                return this.validateService((Service)value, diagnostics, context);
            }
            case 25: {
                return this.validatePort((Port)value, diagnostics, context);
            }
            case 26: {
                return this.validateProperty((Property)value, diagnostics, context);
            }
            case 27: {
                return this.validateExpose((Expose)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAgent(Agent agent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(agent, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(agent, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParticipant_noRealizedUsedInterface(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParticipant_portTypes(agent, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAgent_isActive(agent, diagnostics, context);
        }
        return result;
    }

    public boolean validateAgent_isActive(Agent agent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return agent.isActive(diagnostics, context);
    }

    public boolean validateParticipant(Participant participant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(participant, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(participant, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParticipant_noRealizedUsedInterface(participant, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParticipant_portTypes(participant, diagnostics, context);
        }
        return result;
    }

    public boolean validateParticipant_noRealizedUsedInterface(Participant participant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return participant.noRealizedUsedInterface(diagnostics, context);
    }

    public boolean validateParticipant_portTypes(Participant participant, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return participant.portTypes(diagnostics, context);
    }

    public boolean validateCollaboration(Collaboration collaboration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(collaboration, diagnostics, context);
    }

    public boolean validateMotivationElement(MotivationElement motivationElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(motivationElement, diagnostics, context);
    }

    public boolean validateProvider(Provider provider, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(provider, diagnostics, context);
    }

    public boolean validateFreeFormValue(FreeFormValue freeFormValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(freeFormValue, diagnostics, context);
    }

    public boolean validateMessageType(MessageType messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(messageType, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(messageType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageType_noOwnedBehaviors(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageType_noOwnedOperations(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageType_publicAttributes(messageType, diagnostics, context);
        }
        return result;
    }

    public boolean validateMessageType_noOwnedBehaviors(MessageType messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageType.noOwnedBehaviors(diagnostics, context);
    }

    public boolean validateMessageType_noOwnedOperations(MessageType messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageType.noOwnedOperations(diagnostics, context);
    }

    public boolean validateMessageType_publicAttributes(MessageType messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageType.publicAttributes(diagnostics, context);
    }

    public boolean validateCategory(Category category, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(category, diagnostics, context);
    }

    public boolean validateNodeDescriptor(NodeDescriptor nodeDescriptor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nodeDescriptor, diagnostics, context);
    }

    public boolean validateMilestone(Milestone milestone, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(milestone, diagnostics, context);
    }

    public boolean validateFreeFormDescriptor(FreeFormDescriptor freeFormDescriptor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(freeFormDescriptor, diagnostics, context);
    }

    public boolean validateCategoryValue(CategoryValue categoryValue, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(categoryValue, diagnostics, context);
    }

    public boolean validateServiceContract(ServiceContract serviceContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(serviceContract, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(serviceContract, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceContract_RoleType(serviceContract, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceContract_AttachedBehaviorCompatibility(serviceContract, diagnostics, context);
        }
        return result;
    }

    public boolean validateServiceContract_RoleType(ServiceContract serviceContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceContract.RoleType(diagnostics, context);
    }

    public boolean validateServiceContract_AttachedBehaviorCompatibility(ServiceContract serviceContract, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceContract.AttachedBehaviorCompatibility(diagnostics, context);
    }

    public boolean validateRequest(Request request, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(request, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(request, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRequest_requestType(request, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRequest_isConjugatedTrue(request, diagnostics, context);
        }
        return result;
    }

    public boolean validateRequest_requestType(Request request, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return request.requestType(diagnostics, context);
    }

    public boolean validateRequest_isConjugatedTrue(Request request, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return request.isConjugatedTrue(diagnostics, context);
    }

    public boolean validateConsumer(Consumer consumer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(consumer, diagnostics, context);
    }

    public boolean validateCatalog(Catalog catalog, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(catalog, diagnostics, context);
    }

    public boolean validateCapability(Capability capability, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(capability, diagnostics, context);
    }

    public boolean validateCategorization(Categorization categorization, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(categorization, diagnostics, context);
    }

    public boolean validateMotivationRealization(MotivationRealization motivationRealization, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(motivationRealization, diagnostics, context);
    }

    public boolean validateServiceInterface(ServiceInterface serviceInterface, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(serviceInterface, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(serviceInterface, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(serviceInterface, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceInterface_partsTypesOfServiceInterface(serviceInterface, diagnostics, context);
        }
        return result;
    }

    public boolean validateServiceInterface_partsTypesOfServiceInterface(ServiceInterface serviceInterface, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceInterface.partsTypesOfServiceInterface(diagnostics, context);
    }

    public boolean validateServicesArchitecture(ServicesArchitecture servicesArchitecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(servicesArchitecture, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(servicesArchitecture, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServicesArchitecture_participantsRoleCompatibility(servicesArchitecture, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServicesArchitecture_partsTypes(servicesArchitecture, diagnostics, context);
        }
        return result;
    }

    public boolean validateServicesArchitecture_participantsRoleCompatibility(ServicesArchitecture servicesArchitecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return servicesArchitecture.participantsRoleCompatibility(diagnostics, context);
    }

    public boolean validateServicesArchitecture_partsTypes(ServicesArchitecture servicesArchitecture, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return servicesArchitecture.partsTypes(diagnostics, context);
    }

    public boolean validateAttachment(Attachment attachment, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attachment, diagnostics, context);
    }

    public boolean validateCollaborationUse(CollaborationUse collaborationUse, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collaborationUse, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collaborationUse, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collaborationUse, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollaborationUse_RoleBindingClientSupplierCompatibility(collaborationUse, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollaborationUse_RoleBindingClientSupplierCompatibility(CollaborationUse collaborationUse, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collaborationUse.RoleBindingClientSupplierCompatibility(diagnostics, context);
    }

    public boolean validateServiceChannel(ServiceChannel serviceChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(serviceChannel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(serviceChannel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceChannel_Onlybinaryconnectorsallowed(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceChannel_serviceChannelEndTypes(serviceChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateServiceChannel_Compatibility(serviceChannel, diagnostics, context);
        }
        return result;
    }

    public boolean validateServiceChannel_Onlybinaryconnectorsallowed(ServiceChannel serviceChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceChannel.Onlybinaryconnectorsallowed(diagnostics, context);
    }

    public boolean validateServiceChannel_serviceChannelEndTypes(ServiceChannel serviceChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceChannel.serviceChannelEndTypes(diagnostics, context);
    }

    public boolean validateServiceChannel_Compatibility(ServiceChannel serviceChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return serviceChannel.Compatibility(diagnostics, context);
    }

    public boolean validateService(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(service, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(service, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateService_serviceType(service, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateService_isConjugatedFalse(service, diagnostics, context);
        }
        return result;
    }

    public boolean validateService_serviceType(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return service.serviceType(diagnostics, context);
    }

    public boolean validateService_isConjugatedFalse(Service service, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return service.isConjugatedFalse(diagnostics, context);
    }

    public boolean validatePort(Port port, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(port, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(port, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(port, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePort_connectorRequired(port, diagnostics, context);
        }
        return result;
    }

    public boolean validatePort_connectorRequired(Port port, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return port.connectorRequired(diagnostics, context);
    }

    public boolean validateProperty(Property property, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(property, diagnostics, context);
    }

    public boolean validateExpose(Expose expose, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(expose, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

