/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.sync;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Transition;

public class ObtainICElement {
    public static ICElement getICElement(IParent parent, NamedElement element) {
        try {
            ICElement[] iCElementArray = parent.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement child = iCElementArray[n2];
                if (child instanceof IParent) {
                    return ObtainICElement.getICElement((IParent)child, element);
                }
                if (child instanceof IFunctionDeclaration) {
                    IFunctionDeclaration function = (IFunctionDeclaration)child;
                    if (element instanceof Operation) {
                        if (child.getElementName().endsWith("::" + element.getName()) && function.getNumberOfParameters() == ObtainICElement.countParameters((EList<Parameter>)((Operation)element).getOwnedParameters())) {
                            return child;
                        }
                    } else if (element instanceof Transition) {
                        Transition transition = (Transition)element;
                        if (child.getElementName().endsWith("::" + transition.getEffect().getName()) && function.getNumberOfParameters() == ObtainICElement.countParameters((EList<Parameter>)transition.getEffect().getOwnedParameters())) {
                            return child;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static int countParameters(EList<Parameter> list) {
        int params = 0;
        for (Parameter par : list) {
            if (par.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            ++params;
        }
        return params;
    }
}

