/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.texteditor.cdt.sync;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.C_Cpp.Array;
import org.eclipse.papyrus.C_Cpp.Const;
import org.eclipse.papyrus.C_Cpp.Include;
import org.eclipse.papyrus.C_Cpp.Ptr;
import org.eclipse.papyrus.C_Cpp.Ref;
import org.eclipse.papyrus.C_Cpp.Volatile;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.texteditor.cdt.CommandSupport;
import org.eclipse.papyrus.texteditor.cdt.Utils;
import org.eclipse.papyrus.texteditor.cdt.listener.ModelListener;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncCDTtoModel
implements Runnable {
    public static final String sAtParam = "@param";
    public static final String ansiCLib = "AnsiCLibrary";
    public final String langID = "C/C++";
    protected IEditorInput m_input;
    protected Classifier m_classifier;
    protected String m_projectName;

    public SyncCDTtoModel(IEditorInput input, Classifier classifier, String projectName) {
        this.m_input = input;
        this.m_classifier = classifier;
        this.m_projectName = projectName;
    }

    public void syncCDTtoModel() {
        CommandSupport.exec("update model from CDT", this);
    }

    @Override
    public void run() {
        block11: {
            ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.m_input);
            ModelListener.syncFromEditor = true;
            if (ice instanceof ITranslationUnit) {
                ICProject project = CoreModel.getDefault().getCModel().getCProject(this.m_projectName);
                IIndex index = null;
                try {
                    index = CCorePlugin.getIndexManager().getIndex(project);
                    index.acquireReadLock();
                    ITranslationUnit itu = (ITranslationUnit)ice;
                    IASTTranslationUnit ast = itu.getAST(index, 2);
                    IASTNodeSelector selector = ast.getNodeSelector(null);
                    this.examineChildren(itu, selector, (IParent)itu);
                    this.updateCppInclude(itu);
                    CUIPlugin.getDefault().getProblemMarkerManager();
                    if (itu instanceof IWorkingCopy) {
                        ((IWorkingCopy)itu).reconcile(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CModelException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    if (index != null) {
                        index.releaseReadLock();
                    }
                    break block11;
                }
                catch (Exception e) {
                    try {
                        System.err.println(e);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
                if (index == null) break block11;
                index.releaseReadLock();
            }
        }
        ModelListener.syncFromEditor = false;
    }

    public void examineChildren(ITranslationUnit itu, IASTNodeSelector selector, IParent parent) throws CModelException {
        int position = 0;
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof IParent) {
                this.examineChildren(itu, selector, (IParent)child);
            }
            ISourceRange range = null;
            if (child instanceof ISourceReference) {
                range = ((ISourceReference)child).getSourceRange();
            }
            if (child instanceof IFunctionDeclaration) {
                String name = ((IFunctionDeclaration)child).getElementName();
                IASTNode node = selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTFunctionDefinition) {
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    IASTFunctionDeclarator declarator = definition.getDeclarator();
                    String body = SyncCDTtoModel.getBody(itu, definition);
                    Operation operation = this.updateMethod(position, parent, name, body, declarator);
                    this.updateComment(itu, definition, operation);
                }
                ++position;
            }
            ++n2;
        }
    }

    public void updateCppInclude(ITranslationUnit itu) {
        String contents = new String(itu.getContents());
        int preBodyStart = contents.indexOf("// Include from CppInclude stereotype (pre-body)");
        int preBodyEnd = contents.indexOf("// End of CppInclude stereotype (pre-body)");
        String preBody = "";
        String body = "";
        if (preBodyStart != -1 && preBodyEnd > (preBodyStart += "// Include from CppInclude stereotype (pre-body)".length())) {
            preBody = contents.substring(preBodyStart, preBodyEnd).trim();
        }
        int bodyStart = contents.indexOf("// Include from CppInclude declaration (body)");
        int bodyEnd = contents.indexOf("// End of CppInclude stereotype (body)");
        if (bodyStart != -1 && bodyEnd > (bodyStart += "// Include from CppInclude declaration (body)".length() + 1)) {
            body = contents.substring(bodyStart, bodyEnd).trim();
        }
        if (body.length() > 0 || preBody.length() > 0) {
            Include Include2 = (Include)StereotypeUtil.applyApp((Element)this.m_classifier, Include.class);
            Include2.setPreBody(preBody);
            Include2.setBody(body);
        }
    }

    public Operation updateMethod(int position, IParent parent, String qualifiedName, String body, IASTFunctionDeclarator declarator) {
        int n;
        int n2;
        ICElement[] iCElementArray;
        String[] names = qualifiedName.split("::");
        String name = names[names.length - 1];
        Operation operation = this.m_classifier.getOperation(name, null, null);
        if (operation == null) {
            if (position < this.m_classifier.getOperations().size()) {
                operation = (Operation)this.m_classifier.getOperations().get(position);
                String modelName = operation.getName();
                try {
                    iCElementArray = parent.getChildren();
                    n2 = iCElementArray.length;
                    n = 0;
                    while (n < n2) {
                        String cdtName;
                        ICElement child = iCElementArray[n];
                        if (child instanceof IMethodDeclaration && (cdtName = ((IMethodDeclaration)child).getElementName()).equals(modelName)) {
                            operation = null;
                            break;
                        }
                        ++n;
                    }
                }
                catch (CModelException cModelException) {}
            }
            if (operation != null) {
                operation.setName(name);
            } else if (this.m_classifier instanceof Class) {
                operation = ((Class)this.m_classifier).createOwnedOperation(name, null, null);
            } else if (this.m_classifier instanceof DataType) {
                operation = ((DataType)this.m_classifier).createOwnedOperation(name, null, null);
            }
        }
        OpaqueBehavior ob = null;
        if (operation.getMethods().size() == 0) {
            if (this.m_classifier instanceof Class) {
                ob = (OpaqueBehavior)((Class)this.m_classifier).createOwnedBehavior(name, UMLPackage.eINSTANCE.getOpaqueBehavior());
            } else {
                boolean cfr_ignored_0 = this.m_classifier instanceof DataType;
            }
            ob.setSpecification((BehavioralFeature)operation);
            ob.setIsReentrant(false);
        } else {
            ob = (OpaqueBehavior)operation.getMethods().get(0);
            if (!ob.getName().equals(name)) {
                ob.setName(name);
            }
        }
        UMLUtil.destroyElements((EList)operation.getOwnedParameters());
        UMLUtil.destroyElements((EList)ob.getOwnedParameters());
        iCElementArray = declarator.getChildren();
        n2 = iCElementArray.length;
        n = 0;
        while (n < n2) {
            ICElement declaratorChild = iCElementArray[n];
            if (declaratorChild instanceof IASTParameterDeclaration) {
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)declaratorChild;
                IASTName parameterName = parameter.getDeclarator().getName();
                IASTDeclSpecifier parameterType = parameter.getDeclSpecifier();
                boolean isPointer = false;
                boolean isRef = false;
                String array = "";
                String parameterTypeName = "";
                try {
                    String tokenStr;
                    IToken token = parameter.getDeclarator().getSyntax();
                    while (token != null) {
                        tokenStr = token.toString();
                        if (tokenStr.equals("*")) {
                            isPointer = true;
                        } else if (tokenStr.equals("&")) {
                            isRef = true;
                        } else if (tokenStr.equals("[")) {
                            while (token != null) {
                                array = String.valueOf(array) + token.toString();
                                token = token.getNext();
                            }
                            if (token == null) break;
                        }
                        token = token.getNext();
                    }
                    token = parameterType.getSyntax();
                    while (token != null) {
                        tokenStr = token.toString();
                        if (tokenStr.equals("*")) {
                            isPointer = true;
                        } else if (tokenStr.equals("&")) {
                            isRef = true;
                        } else if (!tokenStr.equals("const")) {
                            if (parameterTypeName.length() > 0) {
                                parameterTypeName = String.valueOf(parameterTypeName) + " ";
                            }
                            parameterTypeName = String.valueOf(parameterTypeName) + tokenStr;
                        }
                        token = token.getNext();
                    }
                }
                catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {}
                NamedElement umlParameterType = Utils.getQualifiedElement(Utils.getTop((Element)this.m_classifier), parameterTypeName);
                if (umlParameterType == null) {
                    umlParameterType = Utils.getQualifiedElement(Utils.getTop((Element)this.m_classifier), "AnsiCLibrary::" + parameterTypeName);
                }
                parameterType.isRestrict();
                Parameter umlParameter = null;
                if (umlParameterType instanceof Type) {
                    umlParameter = operation.createOwnedParameter(parameterName.toString(), (Type)umlParameterType);
                    ob.createOwnedParameter(parameterName.toString(), (Type)umlParameterType);
                } else {
                    umlParameter = operation.createOwnedParameter(parameterName.toString(), null);
                    ob.createOwnedParameter(parameterName.toString(), null);
                }
                if (parameterType.isConst()) {
                    StereotypeUtil.apply((Element)umlParameter, Const.class);
                }
                if (parameterType.isVolatile()) {
                    StereotypeUtil.apply((Element)umlParameter, Volatile.class);
                }
                if (isPointer) {
                    StereotypeUtil.apply((Element)umlParameter, Ptr.class);
                } else if (isRef) {
                    StereotypeUtil.apply((Element)umlParameter, Ref.class);
                }
                if (array.length() > 0) {
                    Array arraySt = (Array)StereotypeUtil.applyApp((Element)umlParameter, Array.class);
                    if (!array.equals("[]") && !array.equals("[ ]")) {
                        arraySt.setDefinition(array);
                    }
                }
            }
            ++n;
        }
        if (ob.getBodies().size() == 0) {
            ob.getLanguages().add((Object)"C/C++");
            ob.getBodies().add((Object)"");
        }
        int i = 0;
        while (i < ob.getLanguages().size()) {
            if (((String)ob.getLanguages().get(i)).equals("C/C++") && i < ob.getBodies().size()) {
                ob.getBodies().set(i, (Object)body);
            }
            ++i;
        }
        return operation;
    }

    public static String getBody(ITranslationUnit itu, IASTFunctionDefinition definition) {
        IASTStatement body = definition.getBody();
        if (body instanceof IASTCompoundStatement) {
            IASTCompoundStatement bodyComp = (IASTCompoundStatement)body;
            IASTFileLocation bodyLoc = bodyComp.getFileLocation();
            int start = bodyLoc.getNodeOffset();
            int end = start + bodyLoc.getNodeLength();
            char[] contents = itu.getContents();
            return Utils.decreaseIndent(contents, start + 2, end - 2);
        }
        return "";
    }

    public void updateComment(ITranslationUnit itu, IASTFunctionDefinition definition, Operation operation) {
        int start;
        IASTFileLocation bodyLoc = definition.getFileLocation();
        int end = start = bodyLoc.getNodeOffset() - 1;
        char[] contents = itu.getContents();
        String comment = "";
        while (start > 0) {
            if (contents[start] == '/' && contents[start + 1] == '*') {
                int i = start += "/**".length();
                while (i < end) {
                    comment = String.valueOf(comment) + contents[i];
                    ++i;
                }
                comment = comment.replace("\n * ", "\n").replace("*/", "").trim();
                break;
            }
            --start;
        }
        if (comment.length() > 0) {
            Comment commentUML;
            int atParam = comment.indexOf(sAtParam);
            String commentMethodOnly = atParam != -1 ? comment.substring(0, atParam).trim() : comment;
            EList commentsUML = operation.getOwnedComments();
            if (commentsUML.size() == 0) {
                commentUML = operation.createOwnedComment();
                commentUML.getAnnotatedElements().add((Object)commentUML);
            } else {
                commentUML = (Comment)commentsUML.get(0);
            }
            while (atParam != -1) {
                int currentAtParam = atParam;
                String commentParam = (atParam = comment.indexOf(sAtParam, atParam + 1)) != -1 ? comment.substring(currentAtParam, atParam) : comment.substring(currentAtParam);
                int atParamName = sAtParam.length();
                while (atParamName < commentParam.length() && Character.isWhitespace(commentParam.charAt(atParamName))) {
                    ++atParamName;
                }
                int atParamNameEnd = atParamName;
                while (atParamNameEnd < commentParam.length() && !Character.isWhitespace(commentParam.charAt(atParamNameEnd))) {
                    ++atParamNameEnd;
                }
                if (atParamNameEnd >= commentParam.length() - 1) continue;
                String parameterName = commentParam.substring(atParamName, atParamNameEnd);
                String commentParamText = commentParam.substring(atParamNameEnd).trim();
                Parameter parameter = operation.getOwnedParameter(parameterName, null, false, false);
                if (parameter != null) {
                    Comment commentParamUML;
                    EList commentsParamUML = parameter.getOwnedComments();
                    if (commentsParamUML.size() == 0) {
                        commentParamUML = parameter.createOwnedComment();
                        commentParamUML.getAnnotatedElements().add((Object)commentParamUML);
                    } else {
                        commentParamUML = (Comment)commentsParamUML.get(0);
                    }
                    commentParamUML.setBody(commentParamText);
                    continue;
                }
                commentMethodOnly = String.valueOf(commentMethodOnly) + "\n @param" + parameterName + " not found(!) " + commentParamText;
            }
            commentUML.setBody(commentMethodOnly);
        }
    }
}

