/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.compare.postprocessor;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.diagram.internal.extensions.NodeChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.papyrus.uml.compare.utils.GeneralizationChangesHelper;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Generalization;

public class PapyrusPostProcessor
implements IPostProcessor {
    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        GeneralizationChangesHelper helper = new GeneralizationChangesHelper(comparison);
        this.computeRequirements(helper);
    }

    protected void computeRequirements(GeneralizationChangesHelper helper) {
        List<Class> classesWIthNodesForInheritedFeatures_ADDED = helper.getClassesWithInheritedPropertyNode(DifferenceKind.ADD);
        for (Class c : classesWIthNodesForInheritedFeatures_ADDED) {
            Set<Feature> features = helper.getInheritedFeaturesWithNodeChange((Classifier)c);
            for (Feature f : features) {
                for (Generalization generalization : helper.getGeneralizationPath((Classifier)c, f)) {
                    NodeChange nodeAdded;
                    DirectedRelationshipChange generalizationAdded = helper.getGeneralizationChange(generalization);
                    if (generalizationAdded == null || (nodeAdded = helper.getFeatureNodeChange(f)) == null) continue;
                    nodeAdded.getRequires().add((Object)generalizationAdded);
                    generalizationAdded.getRequiredBy().add((Object)nodeAdded);
                }
            }
        }
        List<Class> classesWIthNodesForInheritedFeatures_DELETED = helper.getClassesWithInheritedPropertyNode(DifferenceKind.DELETE);
        for (Class c : classesWIthNodesForInheritedFeatures_DELETED) {
            Set<Feature> features = helper.getInheritedFeaturesWithNodeChange((Classifier)c);
            for (Feature f : features) {
                for (Generalization generalization : helper.getGeneralizationPath((Classifier)c, f)) {
                    NodeChange nodeDeleted;
                    DirectedRelationshipChange generalizationDeleted = helper.getGeneralizationChange(generalization);
                    if (generalizationDeleted == null || (nodeDeleted = helper.getFeatureNodeChange(f)) == null) continue;
                    nodeDeleted.getRequiredBy().add((Object)generalizationDeleted);
                    generalizationDeleted.getRequires().add((Object)nodeDeleted);
                }
            }
        }
    }
}

