/**
 * Copyright (c) 2014 CEA LIST.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *  CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.umldi;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Label</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.umldi.TypeLabel#getInteractionUseShape <em>Interaction Use Shape</em>}</li>
 * <li>{@link org.eclipse.papyrus.umldi.TypeLabel#getExceptionHandlerEdge <em>Exception Handler Edge</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.umldi.UMLDIPackage#getTypeLabel()
 * @model
 * @generated
 */
public interface TypeLabel extends UmlLabel {

	/**
	 * Returns the value of the '<em><b>Interaction Use Shape</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.papyrus.umldi.InteractionUseShape#getTypeLabel <em>Type Label</em>}'.
	 * <p>
	 * This feature subsets the following features:
	 * </p>
	 * <ul>
	 * <li>'{@link org.eclipse.papyrus.umldi.UmlDiagramElement#getOwningUmlDiagramElement() <em>Owning Uml Diagram Element</em>}'</li>
	 * </ul>
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Use Shape</em>' container reference isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Interaction Use Shape</em>' container reference.
	 * @see #setInteractionUseShape(InteractionUseShape)
	 * @see org.eclipse.papyrus.umldi.UMLDIPackage#getTypeLabel_InteractionUseShape()
	 * @see org.eclipse.papyrus.umldi.InteractionUseShape#getTypeLabel
	 * @model opposite="typeLabel" transient="false" ordered="false"
	 * @generated
	 */
	InteractionUseShape getInteractionUseShape();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.umldi.TypeLabel#getInteractionUseShape <em>Interaction Use Shape</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *        the new value of the '<em>Interaction Use Shape</em>' container reference.
	 * @see #getInteractionUseShape()
	 * @generated
	 */
	void setInteractionUseShape(InteractionUseShape value);

	/**
	 * Returns the value of the '<em><b>Exception Handler Edge</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.papyrus.umldi.ExceptionHandlerEdge#getTypeLabel <em>Type Label</em>}'.
	 * <p>
	 * This feature subsets the following features:
	 * </p>
	 * <ul>
	 * <li>'{@link org.eclipse.papyrus.umldi.UmlDiagramElement#getOwningUmlDiagramElement() <em>Owning Uml Diagram Element</em>}'</li>
	 * </ul>
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Exception Handler Edge</em>' container reference isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Exception Handler Edge</em>' container reference.
	 * @see #setExceptionHandlerEdge(ExceptionHandlerEdge)
	 * @see org.eclipse.papyrus.umldi.UMLDIPackage#getTypeLabel_ExceptionHandlerEdge()
	 * @see org.eclipse.papyrus.umldi.ExceptionHandlerEdge#getTypeLabel
	 * @model opposite="typeLabel" transient="false" ordered="false"
	 * @generated
	 */
	ExceptionHandlerEdge getExceptionHandlerEdge();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.umldi.TypeLabel#getExceptionHandlerEdge <em>Exception Handler Edge</em>}' container
	 * reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @param value
	 *        the new value of the '<em>Exception Handler Edge</em>' container reference.
	 * @see #getExceptionHandlerEdge()
	 * @generated
	 */
	void setExceptionHandlerEdge(ExceptionHandlerEdge value);
} // TypeLabel
