/**
 * Copyright (c) 2014 CEA LIST.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *  CEA LIST - Initial API and implementation
 */
package org.eclipse.papyrus.umldi;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.papyrus.dd.di.DIPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each operation of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.papyrus.umldi.UMLDIFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='UMLDI'"
 *        annotation="http://www.eclipse.org/emf/2002/Ecore validationDelegates='http://www.eclipse.org/emf/2002/Ecore/OCL'"
 * @generated
 */
public interface UMLDIPackage extends EPackage {

	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME = "umldi";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI = "http://www.omg.org/spec/UML/20131001/UMLDI";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX = "umldi";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	UMLDIPackage eINSTANCE = org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlDiagramElementImpl <em>Uml Diagram Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlDiagramElementImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlDiagramElement()
	 * @generated
	 */
	int UML_DIAGRAM_ELEMENT = 1;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__MODEL_ELEMENT = DIPackage.DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT = DIPackage.DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT = DIPackage.DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__LOCAL_STYLE = DIPackage.DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__SHARED_STYLE = DIPackage.DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__TARGET_EDGE = DIPackage.DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__SOURCE_EDGE = DIPackage.DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__DIAGRAM = DIPackage.DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Uml Diagram Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT_FEATURE_COUNT = DIPackage.DIAGRAM_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT___DIAGRAM = DIPackage.DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Uml Diagram Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_ELEMENT_OPERATION_COUNT = DIPackage.DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlDiagramImpl <em>Uml Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlDiagram()
	 * @generated
	 */
	int UML_DIAGRAM = 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__OWNING_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__OWNED_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__LOCAL_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__SHARED_STYLE = UML_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__TARGET_EDGE = UML_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__SOURCE_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__DIAGRAM = UML_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__UML_MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__SHARED_UML_STYLE = UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__LOCAL_UML_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__TARGET_UML_EDGE = UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__SOURCE_UML_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__BOUNDS = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__NAME = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__DOCUMENTATION = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__RESOLUTION = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Uml Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_FEATURE_COUNT = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM___DIAGRAM = UML_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Uml Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_DIAGRAM_OPERATION_COUNT = UML_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlStyleImpl <em>Uml Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlStyleImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlStyle()
	 * @generated
	 */
	int UML_STYLE = 2;

	/**
	 * The feature id for the '<em><b>Font Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_STYLE__FONT_NAME = DIPackage.STYLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Font Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_STYLE__FONT_SIZE = DIPackage.STYLE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Uml Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_STYLE_FEATURE_COUNT = DIPackage.STYLE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Fontsize Positive</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_STYLE___FONTSIZE_POSITIVE__DIAGNOSTICCHAIN_MAP = DIPackage.STYLE_OPERATION_COUNT + 0;

	/**
	 * The number of operations of the '<em>Uml Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_STYLE_OPERATION_COUNT = DIPackage.STYLE_OPERATION_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StereotypedDiagramElementImpl <em>Stereotyped Diagram Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StereotypedDiagramElementImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStereotypedDiagramElement()
	 * @generated
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT = 5;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__LOCAL_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__SHARED_STYLE = UML_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__TARGET_EDGE = UML_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__SOURCE_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__DIAGRAM = UML_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__SHARED_UML_STYLE = UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__LOCAL_UML_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__TARGET_UML_EDGE = UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__SOURCE_UML_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__SHOW_STEREOTYPE_ATTRIBUTES = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT__STEREOTYPE_LABEL = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Stereotyped Diagram Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT___DIAGRAM = UML_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Stereotyped Diagram Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPED_DIAGRAM_ELEMENT_OPERATION_COUNT = UML_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TopUmlDiagramElementImpl <em>Top Uml Diagram Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TopUmlDiagramElementImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTopUmlDiagramElement()
	 * @generated
	 */
	int TOP_UML_DIAGRAM_ELEMENT = 4;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__MODEL_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__LOCAL_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__SHARED_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__TARGET_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__SOURCE_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__DIAGRAM = STEREOTYPED_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__SHOW_STEREOTYPE_ATTRIBUTES = STEREOTYPED_DIAGRAM_ELEMENT__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__STEREOTYPE_LABEL = STEREOTYPED_DIAGRAM_ELEMENT__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__UML_DIAGRAM = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__DIAGRAM_COMPARTMENT = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT__MAIN_LABEL = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Top Uml Diagram Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT___DIAGRAM = STEREOTYPED_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Top Uml Diagram Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TOP_UML_DIAGRAM_ELEMENT_OPERATION_COUNT = STEREOTYPED_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlEdgeImpl <em>Uml Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlEdge()
	 * @generated
	 */
	int UML_EDGE = 3;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__MODEL_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__OWNING_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__OWNED_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__LOCAL_STYLE = TOP_UML_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SHARED_STYLE = TOP_UML_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__TARGET_EDGE = TOP_UML_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SOURCE_EDGE = TOP_UML_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__DIAGRAM = TOP_UML_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__UML_MODEL_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SHARED_UML_STYLE = TOP_UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__LOCAL_UML_STYLE = TOP_UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__OWNED_UML_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__OWNING_UML_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__TARGET_UML_EDGE = TOP_UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SOURCE_UML_EDGE = TOP_UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = TOP_UML_DIAGRAM_ELEMENT__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__STEREOTYPE_LABEL = TOP_UML_DIAGRAM_ELEMENT__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__UML_DIAGRAM = TOP_UML_DIAGRAM_ELEMENT__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__DIAGRAM_COMPARTMENT = TOP_UML_DIAGRAM_ELEMENT__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__MAIN_LABEL = TOP_UML_DIAGRAM_ELEMENT__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SOURCE_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__WAYPOINT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__TARGET_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE__TARGET_UML_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Uml Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE_FEATURE_COUNT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE___DIAGRAM = TOP_UML_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Uml Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_EDGE_OPERATION_COUNT = TOP_UML_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlCompartmentImpl <em>Uml Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlCompartment()
	 * @generated
	 */
	int UML_COMPARTMENT = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DiagramCompartmentImpl <em>Diagram Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DiagramCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDiagramCompartment()
	 * @generated
	 */
	int DIAGRAM_COMPARTMENT = 8;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlLabelImpl <em>Uml Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlLabel()
	 * @generated
	 */
	int UML_LABEL = 7;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__OWNING_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__OWNED_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__LOCAL_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__SHARED_STYLE = UML_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__TARGET_EDGE = UML_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__SOURCE_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__DIAGRAM = UML_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__UML_MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__SHARED_UML_STYLE = UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__LOCAL_UML_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__TARGET_UML_EDGE = UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__SOURCE_UML_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL__BOUNDS = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Uml Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL_FEATURE_COUNT = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL___DIAGRAM = UML_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Uml Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_LABEL_OPERATION_COUNT = UML_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.MainLabelImpl <em>Main Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.MainLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getMainLabel()
	 * @generated
	 */
	int MAIN_LABEL = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UmlShapeImpl <em>Uml Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UmlShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUmlShape()
	 * @generated
	 */
	int UML_SHAPE = 11;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StructureDiagramImpl <em>Structure Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StructureDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStructureDiagram()
	 * @generated
	 */
	int STRUCTURE_DIAGRAM = 16;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassDiagramImpl <em>Class Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassDiagram()
	 * @generated
	 */
	int CLASS_DIAGRAM = 15;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementShapeImpl <em>Element Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementShape()
	 * @generated
	 */
	int ELEMENT_SHAPE = 19;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TemplateableElementShapeImpl <em>Templateable Element Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TemplateableElementShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTemplateableElementShape()
	 * @generated
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE = 18;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassifierShapeImpl <em>Classifier Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassifierShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassifierShape()
	 * @generated
	 */
	int CLASSIFIER_SHAPE = 17;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ListCompartmentImpl <em>List Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ListCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getListCompartment()
	 * @generated
	 */
	int LIST_COMPARTMENT = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StereotypeCompartmentImpl <em>Stereotype Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StereotypeCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStereotypeCompartment()
	 * @generated
	 */
	int STEREOTYPE_COMPARTMENT = 12;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TemplateParameterCompartmentImpl <em>Template Parameter Compartment</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TemplateParameterCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTemplateParameterCompartment()
	 * @generated
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT = 20;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ListItemLabelImpl <em>List Item Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ListItemLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getListItemLabel()
	 * @generated
	 */
	int LIST_ITEM_LABEL = 14;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StereotypeLabelImpl <em>Stereotype Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StereotypeLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStereotypeLabel()
	 * @generated
	 */
	int STEREOTYPE_LABEL = 6;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotyped Diagram Element</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL__STEREOTYPED_DIAGRAM_ELEMENT = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Stereotype Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Stereotype Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__LOCAL_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__SHARED_STYLE = UML_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__TARGET_EDGE = UML_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__SOURCE_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__DIAGRAM = UML_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__UML_MODEL_ELEMENT = UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__SHARED_UML_STYLE = UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__LOCAL_UML_STYLE = UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__TARGET_UML_EDGE = UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__SOURCE_UML_EDGE = UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT__BOUNDS = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Uml Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT_FEATURE_COUNT = UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT___DIAGRAM = UML_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Uml Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_COMPARTMENT_OPERATION_COUNT = UML_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__MODEL_ELEMENT = UML_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__LOCAL_STYLE = UML_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__SHARED_STYLE = UML_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__TARGET_EDGE = UML_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__SOURCE_EDGE = UML_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__DIAGRAM = UML_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT = UML_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__SHARED_UML_STYLE = UML_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE = UML_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__TARGET_UML_EDGE = UML_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE = UML_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__BOUNDS = UML_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = UML_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Diagram Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT_FEATURE_COUNT = UML_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT___DIAGRAM = UML_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Diagram Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DIAGRAM_COMPARTMENT_OPERATION_COUNT = UML_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL__TOP_UML_DIAGRAM_ELEMENT = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Main Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Main Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MAIN_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__MODEL_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__OWNING_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__OWNED_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__LOCAL_STYLE = TOP_UML_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__SHARED_STYLE = TOP_UML_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__TARGET_EDGE = TOP_UML_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__SOURCE_EDGE = TOP_UML_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__DIAGRAM = TOP_UML_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__UML_MODEL_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__SHARED_UML_STYLE = TOP_UML_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__LOCAL_UML_STYLE = TOP_UML_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = TOP_UML_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__TARGET_UML_EDGE = TOP_UML_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__SOURCE_UML_EDGE = TOP_UML_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = TOP_UML_DIAGRAM_ELEMENT__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__STEREOTYPE_LABEL = TOP_UML_DIAGRAM_ELEMENT__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__UML_DIAGRAM = TOP_UML_DIAGRAM_ELEMENT__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__DIAGRAM_COMPARTMENT = TOP_UML_DIAGRAM_ELEMENT__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__MAIN_LABEL = TOP_UML_DIAGRAM_ELEMENT__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__BOUNDS = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE__STEREOTYPE_COMPARTMENT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Uml Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE_FEATURE_COUNT = TOP_UML_DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE___DIAGRAM = TOP_UML_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Uml Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int UML_SHAPE_OPERATION_COUNT = TOP_UML_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__MODEL_ELEMENT = UML_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__LOCAL_STYLE = UML_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__SHARED_STYLE = UML_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__TARGET_EDGE = UML_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__SOURCE_EDGE = UML_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__DIAGRAM = UML_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__UML_MODEL_ELEMENT = UML_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__SHARED_UML_STYLE = UML_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__LOCAL_UML_STYLE = UML_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = UML_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__TARGET_UML_EDGE = UML_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__SOURCE_UML_EDGE = UML_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__BOUNDS = UML_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT__LIST_ITEM_LABEL = UML_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>List Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT_FEATURE_COUNT = UML_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT___DIAGRAM = UML_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>List Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_COMPARTMENT_OPERATION_COUNT = UML_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT__UML_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Stereotype Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Stereotype Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__MODEL_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__OWNING_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__OWNED_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__LOCAL_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__SHARED_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__TARGET_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__SOURCE_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__DIAGRAM = STEREOTYPED_DIAGRAM_ELEMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__UML_MODEL_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__SHARED_UML_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__LOCAL_UML_STYLE = STEREOTYPED_DIAGRAM_ELEMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__OWNED_UML_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__OWNING_UML_DIAGRAM_ELEMENT = STEREOTYPED_DIAGRAM_ELEMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__TARGET_UML_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__SOURCE_UML_EDGE = STEREOTYPED_DIAGRAM_ELEMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__SHOW_STEREOTYPE_ATTRIBUTES = STEREOTYPED_DIAGRAM_ELEMENT__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__STEREOTYPE_LABEL = STEREOTYPED_DIAGRAM_ELEMENT__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__BOUNDS = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>List Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL__LIST_COMPARTMENT = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>List Item Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL_FEATURE_COUNT = STEREOTYPED_DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL___DIAGRAM = STEREOTYPED_DIAGRAM_ELEMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>List Item Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIST_ITEM_LABEL_OPERATION_COUNT = STEREOTYPED_DIAGRAM_ELEMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__MODEL_ELEMENT = UML_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__LOCAL_STYLE = UML_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__SHARED_STYLE = UML_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__TARGET_EDGE = UML_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__SOURCE_EDGE = UML_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__DIAGRAM = UML_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT = UML_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__SHARED_UML_STYLE = UML_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__LOCAL_UML_STYLE = UML_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__TARGET_UML_EDGE = UML_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__SOURCE_UML_EDGE = UML_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__BOUNDS = UML_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__NAME = UML_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__DOCUMENTATION = UML_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__RESOLUTION = UML_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = UML_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Structure Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM_FEATURE_COUNT = UML_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM___DIAGRAM = UML_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Structure Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_DIAGRAM_OPERATION_COUNT = UML_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Class Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Class Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__MODEL_ELEMENT = UML_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT = UML_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT = UML_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__LOCAL_STYLE = UML_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__SHARED_STYLE = UML_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__TARGET_EDGE = UML_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__SOURCE_EDGE = UML_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__DIAGRAM = UML_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__UML_MODEL_ELEMENT = UML_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__SHARED_UML_STYLE = UML_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__LOCAL_UML_STYLE = UML_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = UML_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = UML_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__TARGET_UML_EDGE = UML_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__SOURCE_UML_EDGE = UML_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = UML_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__STEREOTYPE_LABEL = UML_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__UML_DIAGRAM = UML_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__DIAGRAM_COMPARTMENT = UML_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__MAIN_LABEL = UML_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__BOUNDS = UML_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT = UML_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Element Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE_FEATURE_COUNT = UML_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE___DIAGRAM = UML_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_SHAPE_OPERATION_COUNT = UML_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Templateable Element Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Templateable Element Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATEABLE_ELEMENT_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__MODEL_ELEMENT = TEMPLATEABLE_ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT = TEMPLATEABLE_ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT = TEMPLATEABLE_ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__LOCAL_STYLE = TEMPLATEABLE_ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__SHARED_STYLE = TEMPLATEABLE_ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__TARGET_EDGE = TEMPLATEABLE_ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__SOURCE_EDGE = TEMPLATEABLE_ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__DIAGRAM = TEMPLATEABLE_ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__UML_MODEL_ELEMENT = TEMPLATEABLE_ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__SHARED_UML_STYLE = TEMPLATEABLE_ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__LOCAL_UML_STYLE = TEMPLATEABLE_ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = TEMPLATEABLE_ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = TEMPLATEABLE_ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__TARGET_UML_EDGE = TEMPLATEABLE_ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__SOURCE_UML_EDGE = TEMPLATEABLE_ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = TEMPLATEABLE_ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__STEREOTYPE_LABEL = TEMPLATEABLE_ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__UML_DIAGRAM = TEMPLATEABLE_ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT = TEMPLATEABLE_ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__MAIN_LABEL = TEMPLATEABLE_ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__BOUNDS = TEMPLATEABLE_ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT = TEMPLATEABLE_ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = TEMPLATEABLE_ELEMENT_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION = TEMPLATEABLE_ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT = TEMPLATEABLE_ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT = TEMPLATEABLE_ELEMENT_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Classifier Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE_FEATURE_COUNT = TEMPLATEABLE_ELEMENT_SHAPE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE___DIAGRAM = TEMPLATEABLE_ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Classifier Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_SHAPE_OPERATION_COUNT = TEMPLATEABLE_ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassifierCompartmentImpl <em>Classifier Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassifierCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassifierCompartment()
	 * @generated
	 */
	int CLASSIFIER_COMPARTMENT = 22;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.OwnedUseCaseCompartmentImpl <em>Owned Use Case Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.OwnedUseCaseCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getOwnedUseCaseCompartment()
	 * @generated
	 */
	int OWNED_USE_CASE_COMPARTMENT = 21;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UseCaseCompartmentImpl <em>Use Case Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UseCaseCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUseCaseCompartment()
	 * @generated
	 */
	int USE_CASE_COMPARTMENT = 23;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementWithPackagedElementsShapeImpl
	 * <em>Element With Packaged Elements Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementWithPackagedElementsShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementWithPackagedElementsShape()
	 * @generated
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE = 25;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PackageShapeImpl <em>Package Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PackageShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPackageShape()
	 * @generated
	 */
	int PACKAGE_SHAPE = 24;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PackagedElementCompartmentImpl <em>Packaged Element Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PackagedElementCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPackagedElementCompartment()
	 * @generated
	 */
	int PACKAGED_ELEMENT_COMPARTMENT = 26;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ConstraintShapeImpl <em>Constraint Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ConstraintShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getConstraintShape()
	 * @generated
	 */
	int CONSTRAINT_SHAPE = 27;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AttributeCompartmentImpl <em>Attribute Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AttributeCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAttributeCompartment()
	 * @generated
	 */
	int ATTRIBUTE_COMPARTMENT = 28;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassifierWithAttributesShapeImpl <em>Classifier With Attributes Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassifierWithAttributesShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassifierWithAttributesShape()
	 * @generated
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE = 29;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.OperationCompartmentImpl <em>Operation Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.OperationCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getOperationCompartment()
	 * @generated
	 */
	int OPERATION_COMPARTMENT = 30;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassifierWithOperationsShapeImpl <em>Classifier With Operations Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassifierWithOperationsShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassifierWithOperationsShape()
	 * @generated
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE = 31;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ReceptionCompartmentImpl <em>Reception Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ReceptionCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getReceptionCompartment()
	 * @generated
	 */
	int RECEPTION_COMPARTMENT = 32;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassifierWithReceptionsShapeImpl <em>Classifier With Receptions Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassifierWithReceptionsShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassifierWithReceptionsShape()
	 * @generated
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE = 33;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.LiteralCompartmentImpl <em>Literal Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.LiteralCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getLiteralCompartment()
	 * @generated
	 */
	int LITERAL_COMPARTMENT = 34;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.EnumerationShapeImpl <em>Enumeration Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.EnumerationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getEnumerationShape()
	 * @generated
	 */
	int ENUMERATION_SHAPE = 35;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.RoleLabelImpl <em>Role Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.RoleLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getRoleLabel()
	 * @generated
	 */
	int ROLE_LABEL = 36;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementEdgeImpl <em>Element Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementEdge()
	 * @generated
	 */
	int ELEMENT_EDGE = 38;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Templateable Element Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT__TEMPLATEABLE_ELEMENT_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Template Parameter Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Template Parameter Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_PARAMETER_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__MODEL_ELEMENT = DIAGRAM_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__LOCAL_STYLE = DIAGRAM_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__SHARED_STYLE = DIAGRAM_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__TARGET_EDGE = DIAGRAM_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__SOURCE_EDGE = DIAGRAM_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__DIAGRAM = DIAGRAM_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT = DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE = DIAGRAM_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE = DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE = DIAGRAM_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE = DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__BOUNDS = DIAGRAM_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT__LAYOUT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Classifier Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT_FEATURE_COUNT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT___DIAGRAM = DIAGRAM_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Classifier Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_COMPARTMENT_OPERATION_COUNT = DIAGRAM_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__LOCAL_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__SHARED_STYLE = CLASSIFIER_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__TARGET_EDGE = CLASSIFIER_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__SOURCE_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__DIAGRAM = CLASSIFIER_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__UML_MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__SHARED_UML_STYLE = CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__LOCAL_UML_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__TARGET_UML_EDGE = CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__SOURCE_UML_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__BOUNDS = CLASSIFIER_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__LIST_ITEM_LABEL = CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__LAYOUT = CLASSIFIER_COMPARTMENT__LAYOUT;

	/**
	 * The feature id for the '<em><b>Classifier Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT__CLASSIFIER_SHAPE = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Owned Use Case Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT_FEATURE_COUNT = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT___DIAGRAM = CLASSIFIER_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Owned Use Case Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_USE_CASE_COMPARTMENT_OPERATION_COUNT = CLASSIFIER_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__MODEL_ELEMENT = DIAGRAM_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__LOCAL_STYLE = DIAGRAM_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__SHARED_STYLE = DIAGRAM_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__TARGET_EDGE = DIAGRAM_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__SOURCE_EDGE = DIAGRAM_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__DIAGRAM = DIAGRAM_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__UML_MODEL_ELEMENT = DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__SHARED_UML_STYLE = DIAGRAM_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__LOCAL_UML_STYLE = DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__TARGET_UML_EDGE = DIAGRAM_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__SOURCE_UML_EDGE = DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__BOUNDS = DIAGRAM_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Classifier Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT__CLASSIFIER_SHAPE = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Use Case Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT_FEATURE_COUNT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT___DIAGRAM = DIAGRAM_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Use Case Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_COMPARTMENT_OPERATION_COUNT = DIAGRAM_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Packaged Element Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__PACKAGED_ELEMENT_COMPARTMENT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Element With Packaged Elements Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element With Packaged Elements Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__MODEL_ELEMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__LOCAL_STYLE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__SHARED_STYLE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__TARGET_EDGE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__SOURCE_EDGE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__DIAGRAM = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__UML_MODEL_ELEMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__SHARED_UML_STYLE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__LOCAL_UML_STYLE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__TARGET_UML_EDGE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__SOURCE_UML_EDGE = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__STEREOTYPE_LABEL = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__UML_DIAGRAM = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__MAIN_LABEL = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__BOUNDS = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Packaged Element Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__PACKAGED_ELEMENT_COMPARTMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE__PACKAGED_ELEMENT_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Package Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE_FEATURE_COUNT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE___DIAGRAM = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Package Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_SHAPE_OPERATION_COUNT = ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__MODEL_ELEMENT = DIAGRAM_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__LOCAL_STYLE = DIAGRAM_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__SHARED_STYLE = DIAGRAM_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__TARGET_EDGE = DIAGRAM_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__SOURCE_EDGE = DIAGRAM_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__DIAGRAM = DIAGRAM_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__UML_MODEL_ELEMENT = DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__SHARED_UML_STYLE = DIAGRAM_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__LOCAL_UML_STYLE = DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__TARGET_UML_EDGE = DIAGRAM_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__SOURCE_UML_EDGE = DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__BOUNDS = DIAGRAM_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Element With Packaged Elements Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT__ELEMENT_WITH_PACKAGED_ELEMENTS_SHAPE = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Packaged Element Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT_FEATURE_COUNT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT___DIAGRAM = DIAGRAM_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Packaged Element Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGED_ELEMENT_COMPARTMENT_OPERATION_COUNT = DIAGRAM_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Constraint Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Constraint Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Classifier With Attributes Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT__CLASSIFIER_WITH_ATTRIBUTES_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Attribute Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Attribute Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTE_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__MODEL_ELEMENT = CLASSIFIER_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__LOCAL_STYLE = CLASSIFIER_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHARED_STYLE = CLASSIFIER_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TARGET_EDGE = CLASSIFIER_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SOURCE_EDGE = CLASSIFIER_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__DIAGRAM = CLASSIFIER_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHARED_UML_STYLE = CLASSIFIER_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TARGET_UML_EDGE = CLASSIFIER_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__UML_DIAGRAM = CLASSIFIER_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__MAIN_LABEL = CLASSIFIER_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__BOUNDS = CLASSIFIER_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Classifier With Attributes Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE_FEATURE_COUNT = CLASSIFIER_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE___DIAGRAM = CLASSIFIER_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Classifier With Attributes Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_ATTRIBUTES_SHAPE_OPERATION_COUNT = CLASSIFIER_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Classifier With Operations Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT__CLASSIFIER_WITH_OPERATIONS_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Operation Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Operation Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPERATION_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__BOUNDS = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Classifier With Operations Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE___DIAGRAM = CLASSIFIER_WITH_ATTRIBUTES_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Classifier With Operations Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_OPERATIONS_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Classifier With Reception Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT__CLASSIFIER_WITH_RECEPTION_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reception Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Reception Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int RECEPTION_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__BOUNDS = CLASSIFIER_WITH_OPERATIONS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE__RECEPTION_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Classifier With Receptions Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE___DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Classifier With Receptions Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_RECEPTIONS_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Enumeration Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT__ENUMERATION_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Literal Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Literal Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LITERAL_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__MODEL_ELEMENT = CLASSIFIER_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__LOCAL_STYLE = CLASSIFIER_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__SHARED_STYLE = CLASSIFIER_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__TARGET_EDGE = CLASSIFIER_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__SOURCE_EDGE = CLASSIFIER_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__DIAGRAM = CLASSIFIER_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__SHARED_UML_STYLE = CLASSIFIER_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__TARGET_UML_EDGE = CLASSIFIER_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__UML_DIAGRAM = CLASSIFIER_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__MAIN_LABEL = CLASSIFIER_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__BOUNDS = CLASSIFIER_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Literal Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE__LITERAL_COMPARTMENT = CLASSIFIER_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Enumeration Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE_FEATURE_COUNT = CLASSIFIER_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE___DIAGRAM = CLASSIFIER_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Enumeration Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ENUMERATION_SHAPE_OPERATION_COUNT = CLASSIFIER_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Association Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__ASSOCIATION_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Instance Specification Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__INSTANCE_SPECIFICATION_EDGE = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Role Binding Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL__ROLE_BINDING_EDGE = UML_LABEL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Role Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Role Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ROLE_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__MODEL_ELEMENT = UML_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT = UML_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT = UML_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__LOCAL_STYLE = UML_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SHARED_STYLE = UML_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__TARGET_EDGE = UML_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SOURCE_EDGE = UML_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__DIAGRAM = UML_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__UML_MODEL_ELEMENT = UML_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SHARED_UML_STYLE = UML_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__LOCAL_UML_STYLE = UML_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__TARGET_UML_EDGE = UML_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SOURCE_UML_EDGE = UML_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = UML_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__STEREOTYPE_LABEL = UML_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__UML_DIAGRAM = UML_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__DIAGRAM_COMPARTMENT = UML_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__MAIN_LABEL = UML_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__WAYPOINT = UML_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT = UML_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT = UML_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Element Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE_FEATURE_COUNT = UML_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE___DIAGRAM = UML_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_EDGE_OPERATION_COUNT = UML_EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AssociationEdgeImpl <em>Association Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AssociationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAssociationEdge()
	 * @generated
	 */
	int ASSOCIATION_EDGE = 37;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>End Multiplicity Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__END_MULTIPLICITY_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>End Constraint Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__END_CONSTRAINT_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>End Role Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE__END_ROLE_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Association Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Association Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.MultiplicityLabelImpl <em>Multiplicity Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.MultiplicityLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getMultiplicityLabel()
	 * @generated
	 */
	int MULTIPLICITY_LABEL = 39;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Property Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__PROPERTY_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connector Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__CONNECTOR_EDGE = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Association Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL__ASSOCIATION_EDGE = UML_LABEL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Multiplicity Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Multiplicity Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MULTIPLICITY_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PropertyEdgeImpl <em>Property Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PropertyEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPropertyEdge()
	 * @generated
	 */
	int PROPERTY_EDGE = 40;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Constraint Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__CONSTRAINT_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Multiplicity Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE__MULTIPLICITY_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Property Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Property Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ConstraintLabelImpl <em>Constraint Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ConstraintLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getConstraintLabel()
	 * @generated
	 */
	int CONSTRAINT_LABEL = 41;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Association Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__ASSOCIATION_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Generalization Set Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__GENERALIZATION_SET_EDGE = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Object Node Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__OBJECT_NODE_SHAPE = UML_LABEL_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Lifeline Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__LIFELINE_SHAPE = UML_LABEL_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Action Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__ACTION_SHAPE = UML_LABEL_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Property Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL__PROPERTY_EDGE = UML_LABEL_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Constraint Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 6;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Constraint Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONSTRAINT_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.GeneralizationSetEdgeImpl <em>Generalization Set Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.GeneralizationSetEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getGeneralizationSetEdge()
	 * @generated
	 */
	int GENERALIZATION_SET_EDGE = 42;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Power Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__POWER_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Constraint Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE__CONSTRAINT_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Generalization Set Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Generalization Set Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_SET_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PowerLabelImpl <em>Power Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PowerLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPowerLabel()
	 * @generated
	 */
	int POWER_LABEL = 43;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Generalization Set Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL__GENERALIZATION_SET_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Power Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Power Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POWER_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityNodeShapeImpl <em>Activity Node Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityNodeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityNodeShape()
	 * @generated
	 */
	int ACTIVITY_NODE_SHAPE = 45;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Activity Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Activity Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ObjectNodeShapeImpl <em>Object Node Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ObjectNodeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getObjectNodeShape()
	 * @generated
	 */
	int OBJECT_NODE_SHAPE = 44;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__MODEL_ELEMENT = ACTIVITY_NODE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__LOCAL_STYLE = ACTIVITY_NODE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__SHARED_STYLE = ACTIVITY_NODE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__TARGET_EDGE = ACTIVITY_NODE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__SOURCE_EDGE = ACTIVITY_NODE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__DIAGRAM = ACTIVITY_NODE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__UML_MODEL_ELEMENT = ACTIVITY_NODE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__SHARED_UML_STYLE = ACTIVITY_NODE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__LOCAL_UML_STYLE = ACTIVITY_NODE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__TARGET_UML_EDGE = ACTIVITY_NODE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__SOURCE_UML_EDGE = ACTIVITY_NODE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ACTIVITY_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__STEREOTYPE_LABEL = ACTIVITY_NODE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__UML_DIAGRAM = ACTIVITY_NODE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__DIAGRAM_COMPARTMENT = ACTIVITY_NODE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__MAIN_LABEL = ACTIVITY_NODE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__BOUNDS = ACTIVITY_NODE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__STEREOTYPE_COMPARTMENT = ACTIVITY_NODE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Selection Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__SELECTION_LABEL = ACTIVITY_NODE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Constraint Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE__CONSTRAINT_LABEL = ACTIVITY_NODE_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Object Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE_FEATURE_COUNT = ACTIVITY_NODE_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE___DIAGRAM = ACTIVITY_NODE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Object Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_NODE_SHAPE_OPERATION_COUNT = ACTIVITY_NODE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SelectionLabelImpl <em>Selection Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SelectionLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSelectionLabel()
	 * @generated
	 */
	int SELECTION_LABEL = 46;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Object Flow Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__OBJECT_FLOW_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Object Node Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL__OBJECT_NODE_SHAPE = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Selection Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Selection Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SELECTION_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityEdgeEdgeImpl <em>Activity Edge Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityEdgeEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityEdgeEdge()
	 * @generated
	 */
	int ACTIVITY_EDGE_EDGE = 48;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Guard Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__GUARD_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Weight Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE__WEIGHT_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Activity Edge Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Activity Edge Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_EDGE_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ObjectFlowEdgeImpl <em>Object Flow Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ObjectFlowEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getObjectFlowEdge()
	 * @generated
	 */
	int OBJECT_FLOW_EDGE = 47;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__MODEL_ELEMENT = ACTIVITY_EDGE_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__OWNING_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__OWNED_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__LOCAL_STYLE = ACTIVITY_EDGE_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SHARED_STYLE = ACTIVITY_EDGE_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__TARGET_EDGE = ACTIVITY_EDGE_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SOURCE_EDGE = ACTIVITY_EDGE_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__DIAGRAM = ACTIVITY_EDGE_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__UML_MODEL_ELEMENT = ACTIVITY_EDGE_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SHARED_UML_STYLE = ACTIVITY_EDGE_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__LOCAL_UML_STYLE = ACTIVITY_EDGE_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__TARGET_UML_EDGE = ACTIVITY_EDGE_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SOURCE_UML_EDGE = ACTIVITY_EDGE_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ACTIVITY_EDGE_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__STEREOTYPE_LABEL = ACTIVITY_EDGE_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__UML_DIAGRAM = ACTIVITY_EDGE_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__DIAGRAM_COMPARTMENT = ACTIVITY_EDGE_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__MAIN_LABEL = ACTIVITY_EDGE_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SOURCE_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__WAYPOINT = ACTIVITY_EDGE_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__TARGET_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ACTIVITY_EDGE_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Guard Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__GUARD_LABEL = ACTIVITY_EDGE_EDGE__GUARD_LABEL;

	/**
	 * The feature id for the '<em><b>Weight Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__WEIGHT_LABEL = ACTIVITY_EDGE_EDGE__WEIGHT_LABEL;

	/**
	 * The feature id for the '<em><b>Transformation Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__TRANSFORMATION_LABEL = ACTIVITY_EDGE_EDGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Selection Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE__SELECTION_LABEL = ACTIVITY_EDGE_EDGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Object Flow Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE_FEATURE_COUNT = ACTIVITY_EDGE_EDGE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE___DIAGRAM = ACTIVITY_EDGE_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Object Flow Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_FLOW_EDGE_OPERATION_COUNT = ACTIVITY_EDGE_EDGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.GuardLabelImpl <em>Guard Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.GuardLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getGuardLabel()
	 * @generated
	 */
	int GUARD_LABEL = 49;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Activity Edge Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL__ACTIVITY_EDGE_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Guard Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Guard Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GUARD_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.WeightLabelImpl <em>Weight Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.WeightLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getWeightLabel()
	 * @generated
	 */
	int WEIGHT_LABEL = 50;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TransformationLabelImpl <em>Transformation Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TransformationLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTransformationLabel()
	 * @generated
	 */
	int TRANSFORMATION_LABEL = 51;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ConnectorEdgeImpl <em>Connector Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ConnectorEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getConnectorEdge()
	 * @generated
	 */
	int CONNECTOR_EDGE = 56;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InstanceSpecificationEdgeImpl <em>Instance Specification Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InstanceSpecificationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInstanceSpecificationEdge()
	 * @generated
	 */
	int INSTANCE_SPECIFICATION_EDGE = 57;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DependencyEdgeImpl <em>Dependency Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DependencyEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDependencyEdge()
	 * @generated
	 */
	int DEPENDENCY_EDGE = 58;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeploymentTargetShapeImpl <em>Deployment Target Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeploymentTargetShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeploymentTargetShape()
	 * @generated
	 */
	int DEPLOYMENT_TARGET_SHAPE = 60;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InstanceSpecificationShapeImpl <em>Instance Specification Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InstanceSpecificationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInstanceSpecificationShape()
	 * @generated
	 */
	int INSTANCE_SPECIFICATION_SHAPE = 59;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeployedArtifactCompartmentImpl <em>Deployed Artifact Compartment</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeployedArtifactCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeployedArtifactCompartment()
	 * @generated
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT = 61;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SlotCompartmentImpl <em>Slot Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SlotCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSlotCompartment()
	 * @generated
	 */
	int SLOT_COMPARTMENT = 62;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassifierWithNestedClassifiersShapeImpl
	 * <em>Classifier With Nested Classifiers Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassifierWithNestedClassifiersShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassifierWithNestedClassifiersShape()
	 * @generated
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE = 68;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ClassShapeImpl <em>Class Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ClassShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getClassShape()
	 * @generated
	 */
	int CLASS_SHAPE = 63;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementWithStructureShapeImpl <em>Element With Structure Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementWithStructureShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementWithStructureShape()
	 * @generated
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE = 65;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementWithPortsShapeImpl <em>Element With Ports Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementWithPortsShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementWithPortsShape()
	 * @generated
	 */
	int ELEMENT_WITH_PORTS_SHAPE = 64;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StructureCompartmentImpl <em>Structure Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StructureCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStructureCompartment()
	 * @generated
	 */
	int STRUCTURE_COMPARTMENT = 66;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PortShapeImpl <em>Port Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PortShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPortShape()
	 * @generated
	 */
	int PORT_SHAPE = 67;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.NestedClassifierCompartmentImpl <em>Nested Classifier Compartment</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.NestedClassifierCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getNestedClassifierCompartment()
	 * @generated
	 */
	int NESTED_CLASSIFIER_COMPARTMENT = 69;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.BehavioredClassifierShapeImpl <em>Behaviored Classifier Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.BehavioredClassifierShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getBehavioredClassifierShape()
	 * @generated
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE = 70;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.OwnedBehaviorCompartmentImpl <em>Owned Behavior Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.OwnedBehaviorCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getOwnedBehaviorCompartment()
	 * @generated
	 */
	int OWNED_BEHAVIOR_COMPARTMENT = 71;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InterfaceShapeImpl <em>Interface Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InterfaceShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInterfaceShape()
	 * @generated
	 */
	int INTERFACE_SHAPE = 72;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DataTypeShapeImpl <em>Data Type Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DataTypeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDataTypeShape()
	 * @generated
	 */
	int DATA_TYPE_SHAPE = 73;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PrimitiveTypeShapeImpl <em>Primitive Type Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PrimitiveTypeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPrimitiveTypeShape()
	 * @generated
	 */
	int PRIMITIVE_TYPE_SHAPE = 74;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SignalShapeImpl <em>Signal Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SignalShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSignalShape()
	 * @generated
	 */
	int SIGNAL_SHAPE = 75;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ModelShapeImpl <em>Model Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ModelShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getModelShape()
	 * @generated
	 */
	int MODEL_SHAPE = 76;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ContainmentEdgeImpl <em>Containment Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ContainmentEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getContainmentEdge()
	 * @generated
	 */
	int CONTAINMENT_EDGE = 77;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.GeneralizationEdgeImpl <em>Generalization Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.GeneralizationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getGeneralizationEdge()
	 * @generated
	 */
	int GENERALIZATION_EDGE = 78;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AbstractionEdgeImpl <em>Abstraction Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AbstractionEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAbstractionEdge()
	 * @generated
	 */
	int ABSTRACTION_EDGE = 80;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.RealizationEdgeImpl <em>Realization Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.RealizationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getRealizationEdge()
	 * @generated
	 */
	int REALIZATION_EDGE = 79;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InterfaceRealizationEdgeImpl <em>Interface Realization Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InterfaceRealizationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInterfaceRealizationEdge()
	 * @generated
	 */
	int INTERFACE_REALIZATION_EDGE = 81;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UsageEdgeImpl <em>Usage Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UsageEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUsageEdge()
	 * @generated
	 */
	int USAGE_EDGE = 82;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementImportEdgeImpl <em>Element Import Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementImportEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementImportEdge()
	 * @generated
	 */
	int ELEMENT_IMPORT_EDGE = 83;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PackageImportEdgeImpl <em>Package Import Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PackageImportEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPackageImportEdge()
	 * @generated
	 */
	int PACKAGE_IMPORT_EDGE = 84;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PackageMergeEdgeImpl <em>Package Merge Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PackageMergeEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPackageMergeEdge()
	 * @generated
	 */
	int PACKAGE_MERGE_EDGE = 85;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SubstitutionEdgeImpl <em>Substitution Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SubstitutionEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSubstitutionEdge()
	 * @generated
	 */
	int SUBSTITUTION_EDGE = 86;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InformationFlowEdgeImpl <em>Information Flow Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InformationFlowEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInformationFlowEdge()
	 * @generated
	 */
	int INFORMATION_FLOW_EDGE = 87;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ConveyedLabelImpl <em>Conveyed Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ConveyedLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getConveyedLabel()
	 * @generated
	 */
	int CONVEYED_LABEL = 88;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AssociationClassEdgeImpl <em>Association Class Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AssociationClassEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAssociationClassEdge()
	 * @generated
	 */
	int ASSOCIATION_CLASS_EDGE = 89;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CommentShapeImpl <em>Comment Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CommentShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCommentShape()
	 * @generated
	 */
	int COMMENT_SHAPE = 90;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AttachmentEdgeImpl <em>Attachment Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AttachmentEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAttachmentEdge()
	 * @generated
	 */
	int ATTACHMENT_EDGE = 91;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AssociationClassShapeImpl <em>Association Class Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AssociationClassShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAssociationClassShape()
	 * @generated
	 */
	int ASSOCIATION_CLASS_SHAPE = 92;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ComponentShapeImpl <em>Component Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ComponentShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getComponentShape()
	 * @generated
	 */
	int COMPONENT_SHAPE = 93;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InformationItemShapeImpl <em>Information Item Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InformationItemShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInformationItemShape()
	 * @generated
	 */
	int INFORMATION_ITEM_SHAPE = 94;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.RepresentationEdgeImpl <em>Representation Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.RepresentationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getRepresentationEdge()
	 * @generated
	 */
	int REPRESENTATION_EDGE = 95;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.AssociationShapeImpl <em>Association Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.AssociationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getAssociationShape()
	 * @generated
	 */
	int ASSOCIATION_SHAPE = 96;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DependencyShapeImpl <em>Dependency Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DependencyShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDependencyShape()
	 * @generated
	 */
	int DEPENDENCY_SHAPE = 97;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TimeObservationShapeImpl <em>Time Observation Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TimeObservationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTimeObservationShape()
	 * @generated
	 */
	int TIME_OBSERVATION_SHAPE = 98;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DurationObservationShapeImpl <em>Duration Observation Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DurationObservationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDurationObservationShape()
	 * @generated
	 */
	int DURATION_OBSERVATION_SHAPE = 100;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PackageDiagramImpl <em>Package Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PackageDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPackageDiagram()
	 * @generated
	 */
	int PACKAGE_DIAGRAM = 101;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ProfileDiagramImpl <em>Profile Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ProfileDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getProfileDiagram()
	 * @generated
	 */
	int PROFILE_DIAGRAM = 102;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CompositeStructureDiagramImpl <em>Composite Structure Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CompositeStructureDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCompositeStructureDiagram()
	 * @generated
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM = 103;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeploymentDiagramImpl <em>Deployment Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeploymentDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeploymentDiagram()
	 * @generated
	 */
	int DEPLOYMENT_DIAGRAM = 104;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ComponentDiagramImpl <em>Component Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ComponentDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getComponentDiagram()
	 * @generated
	 */
	int COMPONENT_DIAGRAM = 105;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ObjectDiagramImpl <em>Object Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ObjectDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getObjectDiagram()
	 * @generated
	 */
	int OBJECT_DIAGRAM = 106;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ProfileShapeImpl <em>Profile Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ProfileShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getProfileShape()
	 * @generated
	 */
	int PROFILE_SHAPE = 107;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ProfileApplicationEdgeImpl <em>Profile Application Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ProfileApplicationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getProfileApplicationEdge()
	 * @generated
	 */
	int PROFILE_APPLICATION_EDGE = 108;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExtensionEdgeImpl <em>Extension Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExtensionEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExtensionEdge()
	 * @generated
	 */
	int EXTENSION_EDGE = 109;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.BehaviorDiagramImpl <em>Behavior Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.BehaviorDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getBehaviorDiagram()
	 * @generated
	 */
	int BEHAVIOR_DIAGRAM = 110;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UseCaseDiagramImpl <em>Use Case Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UseCaseDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUseCaseDiagram()
	 * @generated
	 */
	int USE_CASE_DIAGRAM = 111;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ArtifactShapeImpl <em>Artifact Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ArtifactShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getArtifactShape()
	 * @generated
	 */
	int ARTIFACT_SHAPE = 112;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.NestedArtifactCompartmentImpl <em>Nested Artifact Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.NestedArtifactCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getNestedArtifactCompartment()
	 * @generated
	 */
	int NESTED_ARTIFACT_COMPARTMENT = 113;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ComponentRealizationEdgeImpl <em>Component Realization Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ComponentRealizationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getComponentRealizationEdge()
	 * @generated
	 */
	int COMPONENT_REALIZATION_EDGE = 114;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ManifestationEdgeImpl <em>Manifestation Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ManifestationEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getManifestationEdge()
	 * @generated
	 */
	int MANIFESTATION_EDGE = 115;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PropertyShapeImpl <em>Property Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PropertyShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPropertyShape()
	 * @generated
	 */
	int PROPERTY_SHAPE = 116;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CollaborationShapeImpl <em>Collaboration Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CollaborationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCollaborationShape()
	 * @generated
	 */
	int COLLABORATION_SHAPE = 117;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CollaborationUseShapeImpl <em>Collaboration Use Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CollaborationUseShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCollaborationUseShape()
	 * @generated
	 */
	int COLLABORATION_USE_SHAPE = 118;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TemplateBindingEdgeImpl <em>Template Binding Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TemplateBindingEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTemplateBindingEdge()
	 * @generated
	 */
	int TEMPLATE_BINDING_EDGE = 119;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StereotypeShapeImpl <em>Stereotype Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StereotypeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStereotypeShape()
	 * @generated
	 */
	int STEREOTYPE_SHAPE = 120;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.NodeShapeImpl <em>Node Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.NodeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getNodeShape()
	 * @generated
	 */
	int NODE_SHAPE = 121;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.NestedNodeCompartmentImpl <em>Nested Node Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.NestedNodeCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getNestedNodeCompartment()
	 * @generated
	 */
	int NESTED_NODE_COMPARTMENT = 122;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeviceShapeImpl <em>Device Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeviceShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeviceShape()
	 * @generated
	 */
	int DEVICE_SHAPE = 123;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExecutionEnvironmentShapeImpl <em>Execution Environment Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExecutionEnvironmentShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExecutionEnvironmentShape()
	 * @generated
	 */
	int EXECUTION_ENVIRONMENT_SHAPE = 124;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityShapeImpl <em>Activity Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityShape()
	 * @generated
	 */
	int ACTIVITY_SHAPE = 125;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ElementWithActivityNodesShapeImpl <em>Element With Activity Nodes Shape</em>}
	 * ' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ElementWithActivityNodesShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getElementWithActivityNodesShape()
	 * @generated
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE = 126;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityNodeCompartmentImpl <em>Activity Node Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityNodeCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityNodeCompartment()
	 * @generated
	 */
	int ACTIVITY_NODE_COMPARTMENT = 127;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ParameterCompartmentImpl <em>Parameter Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ParameterCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getParameterCompartment()
	 * @generated
	 */
	int PARAMETER_COMPARTMENT = 128;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PostConditionCompartmentImpl <em>Post Condition Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PostConditionCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPostConditionCompartment()
	 * @generated
	 */
	int POST_CONDITION_COMPARTMENT = 129;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PreConditionCompartmentImpl <em>Pre Condition Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PreConditionCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPreConditionCompartment()
	 * @generated
	 */
	int PRE_CONDITION_COMPARTMENT = 130;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityParameterNodeShapeImpl <em>Activity Parameter Node Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityParameterNodeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityParameterNodeShape()
	 * @generated
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE = 131;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionShapeImpl <em>Interaction Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionShape()
	 * @generated
	 */
	int INTERACTION_SHAPE = 132;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionFragmentShapeImpl <em>Interaction Fragment Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionFragmentShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionFragmentShape()
	 * @generated
	 */
	int INTERACTION_FRAGMENT_SHAPE = 53;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionFragmentWithSubfragmentsShapeImpl
	 * <em>Interaction Fragment With Subfragments Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionFragmentWithSubfragmentsShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionFragmentWithSubfragmentsShape()
	 * @generated
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE = 133;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SubfragmentCompartmentImpl <em>Subfragment Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SubfragmentCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSubfragmentCompartment()
	 * @generated
	 */
	int SUBFRAGMENT_COMPARTMENT = 134;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionFragmentWithGatesShapeImpl
	 * <em>Interaction Fragment With Gates Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionFragmentWithGatesShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionFragmentWithGatesShape()
	 * @generated
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE = 135;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.GateShapeImpl <em>Gate Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.GateShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getGateShape()
	 * @generated
	 */
	int GATE_SHAPE = 136;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.OpaqueBehaviorShapeImpl <em>Opaque Behavior Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.OpaqueBehaviorShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getOpaqueBehaviorShape()
	 * @generated
	 */
	int OPAQUE_BEHAVIOR_SHAPE = 137;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.FunctionBehaviorShapeImpl <em>Function Behavior Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.FunctionBehaviorShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getFunctionBehaviorShape()
	 * @generated
	 */
	int FUNCTION_BEHAVIOR_SHAPE = 138;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StateMachineShapeImpl <em>State Machine Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StateMachineShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStateMachineShape()
	 * @generated
	 */
	int STATE_MACHINE_SHAPE = 139;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.BaseStateShapeImpl <em>Base State Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.BaseStateShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getBaseStateShape()
	 * @generated
	 */
	int BASE_STATE_SHAPE = 140;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PseudostateShapeImpl <em>Pseudostate Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PseudostateShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPseudostateShape()
	 * @generated
	 */
	int PSEUDOSTATE_SHAPE = 141;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.RegionCompartmentImpl <em>Region Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.RegionCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getRegionCompartment()
	 * @generated
	 */
	int REGION_COMPARTMENT = 142;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ProtocolStateMachineShapeImpl <em>Protocol State Machine Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ProtocolStateMachineShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getProtocolStateMachineShape()
	 * @generated
	 */
	int PROTOCOL_STATE_MACHINE_SHAPE = 143;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeploymentSpecificationShapeImpl <em>Deployment Specification Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeploymentSpecificationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeploymentSpecificationShape()
	 * @generated
	 */
	int DEPLOYMENT_SPECIFICATION_SHAPE = 144;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CommunicationPathEdgeImpl <em>Communication Path Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CommunicationPathEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCommunicationPathEdge()
	 * @generated
	 */
	int COMMUNICATION_PATH_EDGE = 145;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeploymentEdgeImpl <em>Deployment Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeploymentEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeploymentEdge()
	 * @generated
	 */
	int DEPLOYMENT_EDGE = 146;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActorShapeImpl <em>Actor Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActorShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActorShape()
	 * @generated
	 */
	int ACTOR_SHAPE = 147;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExtensionPointCompartmentImpl <em>Extension Point Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExtensionPointCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExtensionPointCompartment()
	 * @generated
	 */
	int EXTENSION_POINT_COMPARTMENT = 148;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.UseCaseShapeImpl <em>Use Case Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.UseCaseShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getUseCaseShape()
	 * @generated
	 */
	int USE_CASE_SHAPE = 149;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.IncludeEdgeImpl <em>Include Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.IncludeEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getIncludeEdge()
	 * @generated
	 */
	int INCLUDE_EDGE = 150;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExtendEdgeImpl <em>Extend Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExtendEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExtendEdge()
	 * @generated
	 */
	int EXTEND_EDGE = 151;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StateMachineDiagramImpl <em>State Machine Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StateMachineDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStateMachineDiagram()
	 * @generated
	 */
	int STATE_MACHINE_DIAGRAM = 152;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityDiagramImpl <em>Activity Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityDiagram()
	 * @generated
	 */
	int ACTIVITY_DIAGRAM = 153;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionDiagramImpl <em>Interaction Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionDiagram()
	 * @generated
	 */
	int INTERACTION_DIAGRAM = 155;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SequenceDiagramImpl <em>Sequence Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SequenceDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSequenceDiagram()
	 * @generated
	 */
	int SEQUENCE_DIAGRAM = 154;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CommunicationDiagramImpl <em>Communication Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CommunicationDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCommunicationDiagram()
	 * @generated
	 */
	int COMMUNICATION_DIAGRAM = 156;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TimingDiagramImpl <em>Timing Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TimingDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTimingDiagram()
	 * @generated
	 */
	int TIMING_DIAGRAM = 157;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionOverviewDiagramImpl <em>Interaction Overview Diagram</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionOverviewDiagramImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionOverviewDiagram()
	 * @generated
	 */
	int INTERACTION_OVERVIEW_DIAGRAM = 158;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InternalBehaviorCompartmentImpl <em>Internal Behavior Compartment</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InternalBehaviorCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInternalBehaviorCompartment()
	 * @generated
	 */
	int INTERNAL_BEHAVIOR_COMPARTMENT = 159;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StateShapeImpl <em>State Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StateShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStateShape()
	 * @generated
	 */
	int STATE_SHAPE = 160;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ConnectionPointReferenceShapeImpl <em>Connection Point Reference Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ConnectionPointReferenceShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getConnectionPointReferenceShape()
	 * @generated
	 */
	int CONNECTION_POINT_REFERENCE_SHAPE = 161;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InternalTransitionCompartmentImpl <em>Internal Transition Compartment</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InternalTransitionCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInternalTransitionCompartment()
	 * @generated
	 */
	int INTERNAL_TRANSITION_COMPARTMENT = 162;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.DeferrableTriggerCompartmentImpl <em>Deferrable Trigger Compartment</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.DeferrableTriggerCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getDeferrableTriggerCompartment()
	 * @generated
	 */
	int DEFERRABLE_TRIGGER_COMPARTMENT = 163;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.RegionShapeImpl <em>Region Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.RegionShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getRegionShape()
	 * @generated
	 */
	int REGION_SHAPE = 164;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SubvertexCompartmentImpl <em>Subvertex Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SubvertexCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSubvertexCompartment()
	 * @generated
	 */
	int SUBVERTEX_COMPARTMENT = 165;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TransitionEdgeImpl <em>Transition Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TransitionEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTransitionEdge()
	 * @generated
	 */
	int TRANSITION_EDGE = 166;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ControlFlowEdgeImpl <em>Control Flow Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ControlFlowEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getControlFlowEdge()
	 * @generated
	 */
	int CONTROL_FLOW_EDGE = 167;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityGroupShapeImpl <em>Activity Group Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityGroupShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityGroupShape()
	 * @generated
	 */
	int ACTIVITY_GROUP_SHAPE = 168;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExceptionHandlerEdgeImpl <em>Exception Handler Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExceptionHandlerEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExceptionHandlerEdge()
	 * @generated
	 */
	int EXCEPTION_HANDLER_EDGE = 169;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TypeLabelImpl <em>Type Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TypeLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTypeLabel()
	 * @generated
	 */
	int TYPE_LABEL = 170;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.IconLabelImpl <em>Icon Label</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.IconLabelImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getIconLabel()
	 * @generated
	 */
	int ICON_LABEL = 172;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActionShapeImpl <em>Action Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActionShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActionShape()
	 * @generated
	 */
	int ACTION_SHAPE = 54;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.PinShapeImpl <em>Pin Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.PinShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getPinShape()
	 * @generated
	 */
	int PIN_SHAPE = 55;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.SubpartitionCompartmentImpl <em>Subpartition Compartment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.SubpartitionCompartmentImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getSubpartitionCompartment()
	 * @generated
	 */
	int SUBPARTITION_COMPARTMENT = 173;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ActivityPartitionShapeImpl <em>Activity Partition Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ActivityPartitionShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getActivityPartitionShape()
	 * @generated
	 */
	int ACTIVITY_PARTITION_SHAPE = 174;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.StructuredActivityNodeShapeImpl <em>Structured Activity Node Shape</em>}'
	 * class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.StructuredActivityNodeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getStructuredActivityNodeShape()
	 * @generated
	 */
	int STRUCTURED_ACTIVITY_NODE_SHAPE = 175;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExpansionRegionShapeImpl <em>Expansion Region Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExpansionRegionShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExpansionRegionShape()
	 * @generated
	 */
	int EXPANSION_REGION_SHAPE = 176;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.ExpansionNodeShapeImpl <em>Expansion Node Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.ExpansionNodeShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getExpansionNodeShape()
	 * @generated
	 */
	int EXPANSION_NODE_SHAPE = 177;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.LifelineShapeImpl <em>Lifeline Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.LifelineShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getLifelineShape()
	 * @generated
	 */
	int LIFELINE_SHAPE = 52;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.MessageEdgeImpl <em>Message Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.MessageEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getMessageEdge()
	 * @generated
	 */
	int MESSAGE_EDGE = 178;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.GeneralOrderingEdgeImpl <em>General Ordering Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.GeneralOrderingEdgeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getGeneralOrderingEdge()
	 * @generated
	 */
	int GENERAL_ORDERING_EDGE = 179;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.CombinedFragmentShapeImpl <em>Combined Fragment Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.CombinedFragmentShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getCombinedFragmentShape()
	 * @generated
	 */
	int COMBINED_FRAGMENT_SHAPE = 180;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionUseShapeImpl <em>Interaction Use Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionUseShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionUseShape()
	 * @generated
	 */
	int INTERACTION_USE_SHAPE = 171;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.InteractionOperandShapeImpl <em>Interaction Operand Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.InteractionOperandShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getInteractionOperandShape()
	 * @generated
	 */
	int INTERACTION_OPERAND_SHAPE = 181;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Activity Edge Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL__ACTIVITY_EDGE_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Weight Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Weight Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int WEIGHT_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Object Flow Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL__OBJECT_FLOW_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Transformation Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Transformation Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TRANSFORMATION_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.umldi.impl.TimeObservationShape_TimeObservationShapeImpl
	 * <em>Time Observation Shape Time Observation Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see org.eclipse.papyrus.umldi.impl.TimeObservationShape_TimeObservationShapeImpl
	 * @see org.eclipse.papyrus.umldi.impl.UMLDIPackageImpl#getTimeObservationShape_TimeObservationShape()
	 * @generated
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE = 99;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Subfragment Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__SUBFRAGMENT_SHAPE = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Nesting Lifeline Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__NESTING_LIFELINE_SHAPE = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Nested Lifeline Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__NESTED_LIFELINE_SHAPE = ELEMENT_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Constraint Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE__CONSTRAINT_LABEL = ELEMENT_SHAPE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Lifeline Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 4;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Lifeline Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int LIFELINE_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Lifeline Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE__LIFELINE_SHAPE = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Interaction Fragment Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Interaction Fragment Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__MODEL_ELEMENT = ACTIVITY_NODE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__OWNING_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__OWNED_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__LOCAL_STYLE = ACTIVITY_NODE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__SHARED_STYLE = ACTIVITY_NODE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__TARGET_EDGE = ACTIVITY_NODE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__SOURCE_EDGE = ACTIVITY_NODE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__DIAGRAM = ACTIVITY_NODE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__UML_MODEL_ELEMENT = ACTIVITY_NODE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__SHARED_UML_STYLE = ACTIVITY_NODE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__LOCAL_UML_STYLE = ACTIVITY_NODE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ACTIVITY_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__TARGET_UML_EDGE = ACTIVITY_NODE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__SOURCE_UML_EDGE = ACTIVITY_NODE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ACTIVITY_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__STEREOTYPE_LABEL = ACTIVITY_NODE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__UML_DIAGRAM = ACTIVITY_NODE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__DIAGRAM_COMPARTMENT = ACTIVITY_NODE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__MAIN_LABEL = ACTIVITY_NODE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__BOUNDS = ACTIVITY_NODE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__STEREOTYPE_COMPARTMENT = ACTIVITY_NODE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Pin Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__PIN_SHAPE = ACTIVITY_NODE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Condition Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE__CONDITION_LABEL = ACTIVITY_NODE_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Action Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE_FEATURE_COUNT = ACTIVITY_NODE_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE___DIAGRAM = ACTIVITY_NODE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Action Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTION_SHAPE_OPERATION_COUNT = ACTIVITY_NODE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__MODEL_ELEMENT = OBJECT_NODE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__OWNING_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__OWNED_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__LOCAL_STYLE = OBJECT_NODE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__SHARED_STYLE = OBJECT_NODE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__TARGET_EDGE = OBJECT_NODE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__SOURCE_EDGE = OBJECT_NODE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__DIAGRAM = OBJECT_NODE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__UML_MODEL_ELEMENT = OBJECT_NODE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__SHARED_UML_STYLE = OBJECT_NODE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__LOCAL_UML_STYLE = OBJECT_NODE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__TARGET_UML_EDGE = OBJECT_NODE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__SOURCE_UML_EDGE = OBJECT_NODE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = OBJECT_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__STEREOTYPE_LABEL = OBJECT_NODE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__UML_DIAGRAM = OBJECT_NODE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__DIAGRAM_COMPARTMENT = OBJECT_NODE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__MAIN_LABEL = OBJECT_NODE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__BOUNDS = OBJECT_NODE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__STEREOTYPE_COMPARTMENT = OBJECT_NODE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Selection Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__SELECTION_LABEL = OBJECT_NODE_SHAPE__SELECTION_LABEL;

	/**
	 * The feature id for the '<em><b>Constraint Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__CONSTRAINT_LABEL = OBJECT_NODE_SHAPE__CONSTRAINT_LABEL;

	/**
	 * The feature id for the '<em><b>Action Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE__ACTION_SHAPE = OBJECT_NODE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Pin Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE_FEATURE_COUNT = OBJECT_NODE_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE___DIAGRAM = OBJECT_NODE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Pin Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PIN_SHAPE_OPERATION_COUNT = OBJECT_NODE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>End Multiplicity Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE__END_MULTIPLICITY_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Connector Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Connector Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONNECTOR_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>End Role Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE__END_ROLE_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Instance Specification Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Instance Specification Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE__ROLE_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Dependency Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Dependency Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Deployed Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Deployment Target Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Deployment Target Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_TARGET_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__MODEL_ELEMENT = DEPLOYMENT_TARGET_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__OWNING_DIAGRAM_ELEMENT = DEPLOYMENT_TARGET_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__OWNED_DIAGRAM_ELEMENT = DEPLOYMENT_TARGET_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__LOCAL_STYLE = DEPLOYMENT_TARGET_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__SHARED_STYLE = DEPLOYMENT_TARGET_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__TARGET_EDGE = DEPLOYMENT_TARGET_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__SOURCE_EDGE = DEPLOYMENT_TARGET_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__DIAGRAM = DEPLOYMENT_TARGET_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__UML_MODEL_ELEMENT = DEPLOYMENT_TARGET_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__SHARED_UML_STYLE = DEPLOYMENT_TARGET_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__LOCAL_UML_STYLE = DEPLOYMENT_TARGET_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = DEPLOYMENT_TARGET_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = DEPLOYMENT_TARGET_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__TARGET_UML_EDGE = DEPLOYMENT_TARGET_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__SOURCE_UML_EDGE = DEPLOYMENT_TARGET_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = DEPLOYMENT_TARGET_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__STEREOTYPE_LABEL = DEPLOYMENT_TARGET_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__UML_DIAGRAM = DEPLOYMENT_TARGET_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__DIAGRAM_COMPARTMENT = DEPLOYMENT_TARGET_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__MAIN_LABEL = DEPLOYMENT_TARGET_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__BOUNDS = DEPLOYMENT_TARGET_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__STEREOTYPE_COMPARTMENT = DEPLOYMENT_TARGET_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Deployed Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT = DEPLOYMENT_TARGET_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Slot Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE__SLOT_COMPARTMENT = DEPLOYMENT_TARGET_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Instance Specification Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE_FEATURE_COUNT = DEPLOYMENT_TARGET_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE___DIAGRAM = DEPLOYMENT_TARGET_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Instance Specification Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INSTANCE_SPECIFICATION_SHAPE_OPERATION_COUNT = DEPLOYMENT_TARGET_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__LOCAL_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__SHARED_STYLE = CLASSIFIER_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__TARGET_EDGE = CLASSIFIER_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__SOURCE_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__DIAGRAM = CLASSIFIER_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__UML_MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__SHARED_UML_STYLE = CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__LOCAL_UML_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__TARGET_UML_EDGE = CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__SOURCE_UML_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__BOUNDS = CLASSIFIER_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__LIST_ITEM_LABEL = CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__LAYOUT = CLASSIFIER_COMPARTMENT__LAYOUT;

	/**
	 * The feature id for the '<em><b>Deployment Target Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT__DEPLOYMENT_TARGET_SHAPE = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Deployed Artifact Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT_FEATURE_COUNT = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT___DIAGRAM = CLASSIFIER_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Deployed Artifact Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYED_ARTIFACT_COMPARTMENT_OPERATION_COUNT = CLASSIFIER_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Instance Specification Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT__INSTANCE_SPECIFICATION_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Slot Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Slot Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SLOT_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__DIAGRAM = CLASSIFIER_WITH_RECEPTIONS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_RECEPTIONS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_RECEPTIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_RECEPTIONS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_RECEPTIONS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_RECEPTIONS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__BOUNDS = CLASSIFIER_WITH_RECEPTIONS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_RECEPTIONS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__RECEPTION_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASSIFIER_WITH_RECEPTIONS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Classifier With Nested Classifiers Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_RECEPTIONS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE___DIAGRAM = CLASSIFIER_WITH_RECEPTIONS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Classifier With Nested Classifiers Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_RECEPTIONS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__DIAGRAM = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__BOUNDS = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__RECEPTION_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__STRUCTURE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE__PORT_SHAPE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Class Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE___DIAGRAM = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Class Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CLASS_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE__STRUCTURE_COMPARTMENT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Element With Structure Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element With Structure Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_STRUCTURE_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__MODEL_ELEMENT = ELEMENT_WITH_STRUCTURE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_WITH_STRUCTURE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_WITH_STRUCTURE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__LOCAL_STYLE = ELEMENT_WITH_STRUCTURE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__SHARED_STYLE = ELEMENT_WITH_STRUCTURE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__TARGET_EDGE = ELEMENT_WITH_STRUCTURE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__SOURCE_EDGE = ELEMENT_WITH_STRUCTURE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__DIAGRAM = ELEMENT_WITH_STRUCTURE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__UML_MODEL_ELEMENT = ELEMENT_WITH_STRUCTURE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__SHARED_UML_STYLE = ELEMENT_WITH_STRUCTURE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__LOCAL_UML_STYLE = ELEMENT_WITH_STRUCTURE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_WITH_STRUCTURE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_WITH_STRUCTURE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__TARGET_UML_EDGE = ELEMENT_WITH_STRUCTURE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__SOURCE_UML_EDGE = ELEMENT_WITH_STRUCTURE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_WITH_STRUCTURE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__STEREOTYPE_LABEL = ELEMENT_WITH_STRUCTURE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__UML_DIAGRAM = ELEMENT_WITH_STRUCTURE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_WITH_STRUCTURE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__MAIN_LABEL = ELEMENT_WITH_STRUCTURE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__BOUNDS = ELEMENT_WITH_STRUCTURE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_WITH_STRUCTURE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__STRUCTURE_COMPARTMENT = ELEMENT_WITH_STRUCTURE_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE__PORT_SHAPE = ELEMENT_WITH_STRUCTURE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Element With Ports Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE_FEATURE_COUNT = ELEMENT_WITH_STRUCTURE_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE___DIAGRAM = ELEMENT_WITH_STRUCTURE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element With Ports Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_PORTS_SHAPE_OPERATION_COUNT = ELEMENT_WITH_STRUCTURE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__MODEL_ELEMENT = DIAGRAM_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__LOCAL_STYLE = DIAGRAM_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__SHARED_STYLE = DIAGRAM_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__TARGET_EDGE = DIAGRAM_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__SOURCE_EDGE = DIAGRAM_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__DIAGRAM = DIAGRAM_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__UML_MODEL_ELEMENT = DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__SHARED_UML_STYLE = DIAGRAM_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__LOCAL_UML_STYLE = DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__TARGET_UML_EDGE = DIAGRAM_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__SOURCE_UML_EDGE = DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__BOUNDS = DIAGRAM_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Element With Structure Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT__ELEMENT_WITH_STRUCTURE_SHAPE = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Structure Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT_FEATURE_COUNT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT___DIAGRAM = DIAGRAM_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Structure Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRUCTURE_COMPARTMENT_OPERATION_COUNT = DIAGRAM_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Element With Ports Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE__ELEMENT_WITH_PORTS_SHAPE = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Port Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Port Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PORT_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__LOCAL_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__SHARED_STYLE = CLASSIFIER_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__TARGET_EDGE = CLASSIFIER_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__SOURCE_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__DIAGRAM = CLASSIFIER_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE = CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE = CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__BOUNDS = CLASSIFIER_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL = CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__LAYOUT = CLASSIFIER_COMPARTMENT__LAYOUT;

	/**
	 * The feature id for the '<em><b>Classifier With Nested Classifiers Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT__CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Nested Classifier Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT_FEATURE_COUNT = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT___DIAGRAM = CLASSIFIER_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Nested Classifier Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_CLASSIFIER_COMPARTMENT_OPERATION_COUNT = CLASSIFIER_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__MODEL_ELEMENT = CLASSIFIER_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__LOCAL_STYLE = CLASSIFIER_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__SHARED_STYLE = CLASSIFIER_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__TARGET_EDGE = CLASSIFIER_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__SOURCE_EDGE = CLASSIFIER_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__DIAGRAM = CLASSIFIER_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__SHARED_UML_STYLE = CLASSIFIER_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__TARGET_UML_EDGE = CLASSIFIER_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__UML_DIAGRAM = CLASSIFIER_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__MAIN_LABEL = CLASSIFIER_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__BOUNDS = CLASSIFIER_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASSIFIER_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Behaviored Classifier Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE_FEATURE_COUNT = CLASSIFIER_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE___DIAGRAM = CLASSIFIER_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Behaviored Classifier Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIORED_CLASSIFIER_SHAPE_OPERATION_COUNT = CLASSIFIER_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__LOCAL_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__SHARED_STYLE = CLASSIFIER_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__TARGET_EDGE = CLASSIFIER_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__SOURCE_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__DIAGRAM = CLASSIFIER_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__UML_MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__SHARED_UML_STYLE = CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__LOCAL_UML_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__TARGET_UML_EDGE = CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__SOURCE_UML_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__BOUNDS = CLASSIFIER_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__LIST_ITEM_LABEL = CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__LAYOUT = CLASSIFIER_COMPARTMENT__LAYOUT;

	/**
	 * The feature id for the '<em><b>Behaviored Classifier Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT__BEHAVIORED_CLASSIFIER_SHAPE = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Owned Behavior Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT_FEATURE_COUNT = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT___DIAGRAM = CLASSIFIER_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Owned Behavior Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OWNED_BEHAVIOR_COMPARTMENT_OPERATION_COUNT = CLASSIFIER_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__DIAGRAM = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__BOUNDS = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__RECEPTION_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Interface Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE___DIAGRAM = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Interface Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_NESTED_CLASSIFIERS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__BOUNDS = CLASSIFIER_WITH_OPERATIONS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Data Type Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE___DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Data Type Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATA_TYPE_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__MODEL_ELEMENT = DATA_TYPE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__OWNING_DIAGRAM_ELEMENT = DATA_TYPE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__OWNED_DIAGRAM_ELEMENT = DATA_TYPE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__LOCAL_STYLE = DATA_TYPE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__SHARED_STYLE = DATA_TYPE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__TARGET_EDGE = DATA_TYPE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__SOURCE_EDGE = DATA_TYPE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__DIAGRAM = DATA_TYPE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__UML_MODEL_ELEMENT = DATA_TYPE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__SHARED_UML_STYLE = DATA_TYPE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__LOCAL_UML_STYLE = DATA_TYPE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = DATA_TYPE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = DATA_TYPE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__TARGET_UML_EDGE = DATA_TYPE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__SOURCE_UML_EDGE = DATA_TYPE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = DATA_TYPE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__STEREOTYPE_LABEL = DATA_TYPE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__UML_DIAGRAM = DATA_TYPE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__DIAGRAM_COMPARTMENT = DATA_TYPE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__MAIN_LABEL = DATA_TYPE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__BOUNDS = DATA_TYPE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__STEREOTYPE_COMPARTMENT = DATA_TYPE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = DATA_TYPE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__USE_CLASSIFIER_NOTATION = DATA_TYPE_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__OWNED_USE_CASE_COMPARTMENT = DATA_TYPE_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__USE_CASE_COMPARTMENT = DATA_TYPE_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__ATTRIBUTE_COMPARTMENT = DATA_TYPE_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE__OPERATION_COMPARTMENT = DATA_TYPE_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Primitive Type Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE_FEATURE_COUNT = DATA_TYPE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE___DIAGRAM = DATA_TYPE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Primitive Type Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_SHAPE_OPERATION_COUNT = DATA_TYPE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__DIAGRAM = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__BOUNDS = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Signal Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE___DIAGRAM = CLASSIFIER_WITH_ATTRIBUTES_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Signal Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SIGNAL_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_ATTRIBUTES_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__MODEL_ELEMENT = PACKAGE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__OWNING_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__OWNED_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__LOCAL_STYLE = PACKAGE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__SHARED_STYLE = PACKAGE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__TARGET_EDGE = PACKAGE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__SOURCE_EDGE = PACKAGE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__DIAGRAM = PACKAGE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__UML_MODEL_ELEMENT = PACKAGE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__SHARED_UML_STYLE = PACKAGE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__LOCAL_UML_STYLE = PACKAGE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__TARGET_UML_EDGE = PACKAGE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__SOURCE_UML_EDGE = PACKAGE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = PACKAGE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__STEREOTYPE_LABEL = PACKAGE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__UML_DIAGRAM = PACKAGE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__DIAGRAM_COMPARTMENT = PACKAGE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__MAIN_LABEL = PACKAGE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__BOUNDS = PACKAGE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__STEREOTYPE_COMPARTMENT = PACKAGE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Packaged Element Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__PACKAGED_ELEMENT_COMPARTMENT = PACKAGE_SHAPE__PACKAGED_ELEMENT_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = PACKAGE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Model Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE_FEATURE_COUNT = PACKAGE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE___DIAGRAM = PACKAGE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Model Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MODEL_SHAPE_OPERATION_COUNT = PACKAGE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__MODEL_ELEMENT = UML_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__OWNING_DIAGRAM_ELEMENT = UML_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__OWNED_DIAGRAM_ELEMENT = UML_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__LOCAL_STYLE = UML_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SHARED_STYLE = UML_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__TARGET_EDGE = UML_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SOURCE_EDGE = UML_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__DIAGRAM = UML_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__UML_MODEL_ELEMENT = UML_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SHARED_UML_STYLE = UML_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__LOCAL_UML_STYLE = UML_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__TARGET_UML_EDGE = UML_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SOURCE_UML_EDGE = UML_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = UML_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__STEREOTYPE_LABEL = UML_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__UML_DIAGRAM = UML_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__DIAGRAM_COMPARTMENT = UML_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__MAIN_LABEL = UML_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SOURCE_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__WAYPOINT = UML_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__TARGET_DIAGRAM_ELEMENT = UML_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT = UML_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Containment Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE_FEATURE_COUNT = UML_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE___DIAGRAM = UML_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Containment Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONTAINMENT_EDGE_OPERATION_COUNT = UML_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Generalization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Generalization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GENERALIZATION_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__MODEL_ELEMENT = DEPENDENCY_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__OWNING_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__OWNED_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__LOCAL_STYLE = DEPENDENCY_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SHARED_STYLE = DEPENDENCY_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__TARGET_EDGE = DEPENDENCY_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SOURCE_EDGE = DEPENDENCY_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__DIAGRAM = DEPENDENCY_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__UML_MODEL_ELEMENT = DEPENDENCY_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SHARED_UML_STYLE = DEPENDENCY_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__LOCAL_UML_STYLE = DEPENDENCY_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__TARGET_UML_EDGE = DEPENDENCY_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SOURCE_UML_EDGE = DEPENDENCY_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = DEPENDENCY_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__STEREOTYPE_LABEL = DEPENDENCY_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__UML_DIAGRAM = DEPENDENCY_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__DIAGRAM_COMPARTMENT = DEPENDENCY_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__MAIN_LABEL = DEPENDENCY_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SOURCE_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__WAYPOINT = DEPENDENCY_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__TARGET_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE__ROLE_LABEL = DEPENDENCY_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Abstraction Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE_FEATURE_COUNT = DEPENDENCY_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE___DIAGRAM = DEPENDENCY_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Abstraction Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ABSTRACTION_EDGE_OPERATION_COUNT = DEPENDENCY_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__MODEL_ELEMENT = ABSTRACTION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__LOCAL_STYLE = ABSTRACTION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SHARED_STYLE = ABSTRACTION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__TARGET_EDGE = ABSTRACTION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SOURCE_EDGE = ABSTRACTION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__DIAGRAM = ABSTRACTION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__UML_MODEL_ELEMENT = ABSTRACTION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SHARED_UML_STYLE = ABSTRACTION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__LOCAL_UML_STYLE = ABSTRACTION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__TARGET_UML_EDGE = ABSTRACTION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SOURCE_UML_EDGE = ABSTRACTION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ABSTRACTION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__STEREOTYPE_LABEL = ABSTRACTION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__UML_DIAGRAM = ABSTRACTION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__DIAGRAM_COMPARTMENT = ABSTRACTION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__MAIN_LABEL = ABSTRACTION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__WAYPOINT = ABSTRACTION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE__ROLE_LABEL = ABSTRACTION_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Realization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE_FEATURE_COUNT = ABSTRACTION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE___DIAGRAM = ABSTRACTION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Realization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REALIZATION_EDGE_OPERATION_COUNT = ABSTRACTION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__MODEL_ELEMENT = REALIZATION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__LOCAL_STYLE = REALIZATION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SHARED_STYLE = REALIZATION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__TARGET_EDGE = REALIZATION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SOURCE_EDGE = REALIZATION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__DIAGRAM = REALIZATION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__UML_MODEL_ELEMENT = REALIZATION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SHARED_UML_STYLE = REALIZATION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__LOCAL_UML_STYLE = REALIZATION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__TARGET_UML_EDGE = REALIZATION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SOURCE_UML_EDGE = REALIZATION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = REALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__STEREOTYPE_LABEL = REALIZATION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__UML_DIAGRAM = REALIZATION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__DIAGRAM_COMPARTMENT = REALIZATION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__MAIN_LABEL = REALIZATION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT = REALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__WAYPOINT = REALIZATION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT = REALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE__ROLE_LABEL = REALIZATION_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Interface Realization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE_FEATURE_COUNT = REALIZATION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE___DIAGRAM = REALIZATION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Interface Realization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_REALIZATION_EDGE_OPERATION_COUNT = REALIZATION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__MODEL_ELEMENT = DEPENDENCY_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__OWNING_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__OWNED_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__LOCAL_STYLE = DEPENDENCY_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SHARED_STYLE = DEPENDENCY_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__TARGET_EDGE = DEPENDENCY_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SOURCE_EDGE = DEPENDENCY_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__DIAGRAM = DEPENDENCY_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__UML_MODEL_ELEMENT = DEPENDENCY_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SHARED_UML_STYLE = DEPENDENCY_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__LOCAL_UML_STYLE = DEPENDENCY_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__OWNED_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__OWNING_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__TARGET_UML_EDGE = DEPENDENCY_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SOURCE_UML_EDGE = DEPENDENCY_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = DEPENDENCY_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__STEREOTYPE_LABEL = DEPENDENCY_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__UML_DIAGRAM = DEPENDENCY_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__DIAGRAM_COMPARTMENT = DEPENDENCY_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__MAIN_LABEL = DEPENDENCY_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SOURCE_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__WAYPOINT = DEPENDENCY_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__TARGET_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__TARGET_UML_DIAGRAM_ELEMENT = DEPENDENCY_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE__ROLE_LABEL = DEPENDENCY_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Usage Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE_FEATURE_COUNT = DEPENDENCY_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE___DIAGRAM = DEPENDENCY_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Usage Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USAGE_EDGE_OPERATION_COUNT = DEPENDENCY_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Element Import Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element Import Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_IMPORT_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Package Import Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Package Import Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_IMPORT_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Package Merge Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Package Merge Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_MERGE_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__MODEL_ELEMENT = REALIZATION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__OWNING_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__OWNED_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__LOCAL_STYLE = REALIZATION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SHARED_STYLE = REALIZATION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__TARGET_EDGE = REALIZATION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SOURCE_EDGE = REALIZATION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__DIAGRAM = REALIZATION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__UML_MODEL_ELEMENT = REALIZATION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SHARED_UML_STYLE = REALIZATION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__LOCAL_UML_STYLE = REALIZATION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__TARGET_UML_EDGE = REALIZATION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SOURCE_UML_EDGE = REALIZATION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = REALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__STEREOTYPE_LABEL = REALIZATION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__UML_DIAGRAM = REALIZATION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__DIAGRAM_COMPARTMENT = REALIZATION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__MAIN_LABEL = REALIZATION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SOURCE_DIAGRAM_ELEMENT = REALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__WAYPOINT = REALIZATION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__TARGET_DIAGRAM_ELEMENT = REALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE__ROLE_LABEL = REALIZATION_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Substitution Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE_FEATURE_COUNT = REALIZATION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE___DIAGRAM = REALIZATION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Substitution Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBSTITUTION_EDGE_OPERATION_COUNT = REALIZATION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Conveyed Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE__CONVEYED_LABEL = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Information Flow Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Information Flow Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_FLOW_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__MODEL_ELEMENT = UML_LABEL__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__OWNING_DIAGRAM_ELEMENT = UML_LABEL__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__OWNED_DIAGRAM_ELEMENT = UML_LABEL__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__LOCAL_STYLE = UML_LABEL__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__SHARED_STYLE = UML_LABEL__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__TARGET_EDGE = UML_LABEL__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__SOURCE_EDGE = UML_LABEL__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__DIAGRAM = UML_LABEL__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__UML_MODEL_ELEMENT = UML_LABEL__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__SHARED_UML_STYLE = UML_LABEL__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__LOCAL_UML_STYLE = UML_LABEL__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__OWNED_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__OWNING_UML_DIAGRAM_ELEMENT = UML_LABEL__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__TARGET_UML_EDGE = UML_LABEL__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__SOURCE_UML_EDGE = UML_LABEL__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__BOUNDS = UML_LABEL__BOUNDS;

	/**
	 * The feature id for the '<em><b>Information Flow Edge</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL__INFORMATION_FLOW_EDGE = UML_LABEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Conveyed Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL_FEATURE_COUNT = UML_LABEL_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL___DIAGRAM = UML_LABEL___DIAGRAM;

	/**
	 * The number of operations of the '<em>Conveyed Label</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int CONVEYED_LABEL_OPERATION_COUNT = UML_LABEL_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__MODEL_ELEMENT = ASSOCIATION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__OWNING_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__OWNED_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__LOCAL_STYLE = ASSOCIATION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SHARED_STYLE = ASSOCIATION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__TARGET_EDGE = ASSOCIATION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SOURCE_EDGE = ASSOCIATION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__DIAGRAM = ASSOCIATION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__UML_MODEL_ELEMENT = ASSOCIATION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SHARED_UML_STYLE = ASSOCIATION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__LOCAL_UML_STYLE = ASSOCIATION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__TARGET_UML_EDGE = ASSOCIATION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SOURCE_UML_EDGE = ASSOCIATION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ASSOCIATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__STEREOTYPE_LABEL = ASSOCIATION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__UML_DIAGRAM = ASSOCIATION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__DIAGRAM_COMPARTMENT = ASSOCIATION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__MAIN_LABEL = ASSOCIATION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SOURCE_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__WAYPOINT = ASSOCIATION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__TARGET_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>End Multiplicity Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__END_MULTIPLICITY_LABEL = ASSOCIATION_EDGE__END_MULTIPLICITY_LABEL;

	/**
	 * The feature id for the '<em><b>End Constraint Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__END_CONSTRAINT_LABEL = ASSOCIATION_EDGE__END_CONSTRAINT_LABEL;

	/**
	 * The feature id for the '<em><b>End Role Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE__END_ROLE_LABEL = ASSOCIATION_EDGE__END_ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Association Class Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE_FEATURE_COUNT = ASSOCIATION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE___DIAGRAM = ASSOCIATION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Association Class Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_EDGE_OPERATION_COUNT = ASSOCIATION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Comment Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Comment Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMMENT_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__MODEL_ELEMENT = UML_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__OWNING_DIAGRAM_ELEMENT = UML_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__OWNED_DIAGRAM_ELEMENT = UML_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__LOCAL_STYLE = UML_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SHARED_STYLE = UML_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__TARGET_EDGE = UML_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SOURCE_EDGE = UML_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__DIAGRAM = UML_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__UML_MODEL_ELEMENT = UML_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SHARED_UML_STYLE = UML_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__LOCAL_UML_STYLE = UML_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__TARGET_UML_EDGE = UML_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SOURCE_UML_EDGE = UML_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = UML_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__STEREOTYPE_LABEL = UML_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__UML_DIAGRAM = UML_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__DIAGRAM_COMPARTMENT = UML_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__MAIN_LABEL = UML_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SOURCE_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__WAYPOINT = UML_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__TARGET_DIAGRAM_ELEMENT = UML_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT = UML_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Attachment Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE_FEATURE_COUNT = UML_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE___DIAGRAM = UML_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Attachment Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ATTACHMENT_EDGE_OPERATION_COUNT = UML_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__SOURCE_EDGE = CLASS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__DIAGRAM = CLASS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__UML_MODEL_ELEMENT = CLASS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__SHARED_UML_STYLE = CLASS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__LOCAL_UML_STYLE = CLASS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__TARGET_UML_EDGE = CLASS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__SOURCE_UML_EDGE = CLASS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__STEREOTYPE_LABEL = CLASS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__UML_DIAGRAM = CLASS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__DIAGRAM_COMPARTMENT = CLASS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__MAIN_LABEL = CLASS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__BOUNDS = CLASS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__STEREOTYPE_COMPARTMENT = CLASS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__USE_CLASSIFIER_NOTATION = CLASS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__USE_CASE_COMPARTMENT = CLASS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__ATTRIBUTE_COMPARTMENT = CLASS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OPERATION_COMPARTMENT = CLASS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__RECEPTION_COMPARTMENT = CLASS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__STRUCTURE_COMPARTMENT = CLASS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE__PORT_SHAPE = CLASS_SHAPE__PORT_SHAPE;

	/**
	 * The number of structural features of the '<em>Association Class Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE_FEATURE_COUNT = CLASS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE___DIAGRAM = CLASS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Association Class Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_CLASS_SHAPE_OPERATION_COUNT = CLASS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__SOURCE_EDGE = CLASS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__DIAGRAM = CLASS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__UML_MODEL_ELEMENT = CLASS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__SHARED_UML_STYLE = CLASS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__LOCAL_UML_STYLE = CLASS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__TARGET_UML_EDGE = CLASS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__SOURCE_UML_EDGE = CLASS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__STEREOTYPE_LABEL = CLASS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__UML_DIAGRAM = CLASS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__DIAGRAM_COMPARTMENT = CLASS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__MAIN_LABEL = CLASS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__BOUNDS = CLASS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__STEREOTYPE_COMPARTMENT = CLASS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__USE_CLASSIFIER_NOTATION = CLASS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__USE_CASE_COMPARTMENT = CLASS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__ATTRIBUTE_COMPARTMENT = CLASS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OPERATION_COMPARTMENT = CLASS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__RECEPTION_COMPARTMENT = CLASS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__STRUCTURE_COMPARTMENT = CLASS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__PORT_SHAPE = CLASS_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Packaged Element Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE__PACKAGED_ELEMENT_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Component Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE_FEATURE_COUNT = CLASS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE___DIAGRAM = CLASS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Component Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_SHAPE_OPERATION_COUNT = CLASS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__MODEL_ELEMENT = CLASSIFIER_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__LOCAL_STYLE = CLASSIFIER_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__SHARED_STYLE = CLASSIFIER_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__TARGET_EDGE = CLASSIFIER_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__SOURCE_EDGE = CLASSIFIER_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__DIAGRAM = CLASSIFIER_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__SHARED_UML_STYLE = CLASSIFIER_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__TARGET_UML_EDGE = CLASSIFIER_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__UML_DIAGRAM = CLASSIFIER_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__MAIN_LABEL = CLASSIFIER_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__BOUNDS = CLASSIFIER_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Information Item Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE_FEATURE_COUNT = CLASSIFIER_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE___DIAGRAM = CLASSIFIER_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Information Item Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INFORMATION_ITEM_SHAPE_OPERATION_COUNT = CLASSIFIER_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__MODEL_ELEMENT = UML_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__OWNING_DIAGRAM_ELEMENT = UML_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__OWNED_DIAGRAM_ELEMENT = UML_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__LOCAL_STYLE = UML_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SHARED_STYLE = UML_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__TARGET_EDGE = UML_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SOURCE_EDGE = UML_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__DIAGRAM = UML_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__UML_MODEL_ELEMENT = UML_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SHARED_UML_STYLE = UML_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__LOCAL_UML_STYLE = UML_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = UML_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__TARGET_UML_EDGE = UML_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SOURCE_UML_EDGE = UML_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = UML_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__STEREOTYPE_LABEL = UML_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__UML_DIAGRAM = UML_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__DIAGRAM_COMPARTMENT = UML_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__MAIN_LABEL = UML_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SOURCE_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__WAYPOINT = UML_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__TARGET_DIAGRAM_ELEMENT = UML_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = UML_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = UML_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Representation Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE_FEATURE_COUNT = UML_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE___DIAGRAM = UML_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Representation Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REPRESENTATION_EDGE_OPERATION_COUNT = UML_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__MODEL_ELEMENT = CLASSIFIER_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__LOCAL_STYLE = CLASSIFIER_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__SHARED_STYLE = CLASSIFIER_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__TARGET_EDGE = CLASSIFIER_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__SOURCE_EDGE = CLASSIFIER_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__DIAGRAM = CLASSIFIER_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__SHARED_UML_STYLE = CLASSIFIER_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__TARGET_UML_EDGE = CLASSIFIER_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__UML_DIAGRAM = CLASSIFIER_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__MAIN_LABEL = CLASSIFIER_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__BOUNDS = CLASSIFIER_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Association Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE_FEATURE_COUNT = CLASSIFIER_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE___DIAGRAM = CLASSIFIER_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Association Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ASSOCIATION_SHAPE_OPERATION_COUNT = CLASSIFIER_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Dependency Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Dependency Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPENDENCY_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Time Observation Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Time Observation Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Time Observation Shape Time Observation Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Time Observation Shape Time Observation Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TIME_OBSERVATION_SHAPE_TIME_OBSERVATION_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Duration Observation Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Duration Observation Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DURATION_OBSERVATION_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Package Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Package Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PACKAGE_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Profile Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Profile Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Composite Structure Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Composite Structure Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPOSITE_STRUCTURE_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Deployment Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Deployment Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEPLOYMENT_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Component Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Component Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__MODEL_ELEMENT = STRUCTURE_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__OWNING_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__OWNED_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__LOCAL_STYLE = STRUCTURE_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__SHARED_STYLE = STRUCTURE_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__TARGET_EDGE = STRUCTURE_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__SOURCE_EDGE = STRUCTURE_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__DIAGRAM = STRUCTURE_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__UML_MODEL_ELEMENT = STRUCTURE_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__SHARED_UML_STYLE = STRUCTURE_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__LOCAL_UML_STYLE = STRUCTURE_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__TARGET_UML_EDGE = STRUCTURE_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__SOURCE_UML_EDGE = STRUCTURE_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__BOUNDS = STRUCTURE_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__NAME = STRUCTURE_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__DOCUMENTATION = STRUCTURE_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__RESOLUTION = STRUCTURE_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = STRUCTURE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Object Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM_FEATURE_COUNT = STRUCTURE_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM___DIAGRAM = STRUCTURE_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Object Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OBJECT_DIAGRAM_OPERATION_COUNT = STRUCTURE_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__MODEL_ELEMENT = PACKAGE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__OWNING_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__OWNED_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__LOCAL_STYLE = PACKAGE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__SHARED_STYLE = PACKAGE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__TARGET_EDGE = PACKAGE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__SOURCE_EDGE = PACKAGE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__DIAGRAM = PACKAGE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__UML_MODEL_ELEMENT = PACKAGE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__SHARED_UML_STYLE = PACKAGE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__LOCAL_UML_STYLE = PACKAGE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = PACKAGE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__TARGET_UML_EDGE = PACKAGE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__SOURCE_UML_EDGE = PACKAGE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = PACKAGE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__STEREOTYPE_LABEL = PACKAGE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__UML_DIAGRAM = PACKAGE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__DIAGRAM_COMPARTMENT = PACKAGE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__MAIN_LABEL = PACKAGE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__BOUNDS = PACKAGE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__STEREOTYPE_COMPARTMENT = PACKAGE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Packaged Element Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__PACKAGED_ELEMENT_COMPARTMENT = PACKAGE_SHAPE__PACKAGED_ELEMENT_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = PACKAGE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Profile Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE_FEATURE_COUNT = PACKAGE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE___DIAGRAM = PACKAGE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Profile Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_SHAPE_OPERATION_COUNT = PACKAGE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Profile Application Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Profile Application Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROFILE_APPLICATION_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__MODEL_ELEMENT = ASSOCIATION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__OWNING_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__OWNED_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__LOCAL_STYLE = ASSOCIATION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SHARED_STYLE = ASSOCIATION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__TARGET_EDGE = ASSOCIATION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SOURCE_EDGE = ASSOCIATION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__DIAGRAM = ASSOCIATION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__UML_MODEL_ELEMENT = ASSOCIATION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SHARED_UML_STYLE = ASSOCIATION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__LOCAL_UML_STYLE = ASSOCIATION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__TARGET_UML_EDGE = ASSOCIATION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SOURCE_UML_EDGE = ASSOCIATION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ASSOCIATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__STEREOTYPE_LABEL = ASSOCIATION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__UML_DIAGRAM = ASSOCIATION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__DIAGRAM_COMPARTMENT = ASSOCIATION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__MAIN_LABEL = ASSOCIATION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SOURCE_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__WAYPOINT = ASSOCIATION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__TARGET_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ASSOCIATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>End Multiplicity Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__END_MULTIPLICITY_LABEL = ASSOCIATION_EDGE__END_MULTIPLICITY_LABEL;

	/**
	 * The feature id for the '<em><b>End Constraint Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__END_CONSTRAINT_LABEL = ASSOCIATION_EDGE__END_CONSTRAINT_LABEL;

	/**
	 * The feature id for the '<em><b>End Role Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE__END_ROLE_LABEL = ASSOCIATION_EDGE__END_ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Extension Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE_FEATURE_COUNT = ASSOCIATION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE___DIAGRAM = ASSOCIATION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Extension Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXTENSION_EDGE_OPERATION_COUNT = ASSOCIATION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__MODEL_ELEMENT = UML_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__OWNING_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__OWNED_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__LOCAL_STYLE = UML_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__SHARED_STYLE = UML_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__TARGET_EDGE = UML_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__SOURCE_EDGE = UML_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__DIAGRAM = UML_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__UML_MODEL_ELEMENT = UML_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__SHARED_UML_STYLE = UML_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__LOCAL_UML_STYLE = UML_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = UML_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__TARGET_UML_EDGE = UML_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__SOURCE_UML_EDGE = UML_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__BOUNDS = UML_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__NAME = UML_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__DOCUMENTATION = UML_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__RESOLUTION = UML_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = UML_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Behavior Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM_FEATURE_COUNT = UML_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM___DIAGRAM = UML_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Behavior Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BEHAVIOR_DIAGRAM_OPERATION_COUNT = UML_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__MODEL_ELEMENT = BEHAVIOR_DIAGRAM__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__OWNING_DIAGRAM_ELEMENT = BEHAVIOR_DIAGRAM__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__OWNED_DIAGRAM_ELEMENT = BEHAVIOR_DIAGRAM__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__LOCAL_STYLE = BEHAVIOR_DIAGRAM__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__SHARED_STYLE = BEHAVIOR_DIAGRAM__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__TARGET_EDGE = BEHAVIOR_DIAGRAM__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__SOURCE_EDGE = BEHAVIOR_DIAGRAM__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__DIAGRAM = BEHAVIOR_DIAGRAM__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__UML_MODEL_ELEMENT = BEHAVIOR_DIAGRAM__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__SHARED_UML_STYLE = BEHAVIOR_DIAGRAM__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__LOCAL_UML_STYLE = BEHAVIOR_DIAGRAM__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT = BEHAVIOR_DIAGRAM__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT = BEHAVIOR_DIAGRAM__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__TARGET_UML_EDGE = BEHAVIOR_DIAGRAM__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__SOURCE_UML_EDGE = BEHAVIOR_DIAGRAM__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__BOUNDS = BEHAVIOR_DIAGRAM__BOUNDS;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__NAME = BEHAVIOR_DIAGRAM__NAME;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__DOCUMENTATION = BEHAVIOR_DIAGRAM__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__RESOLUTION = BEHAVIOR_DIAGRAM__RESOLUTION;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT = BEHAVIOR_DIAGRAM__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Use Case Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM_FEATURE_COUNT = BEHAVIOR_DIAGRAM_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM___DIAGRAM = BEHAVIOR_DIAGRAM___DIAGRAM;

	/**
	 * The number of operations of the '<em>Use Case Diagram</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int USE_CASE_DIAGRAM_OPERATION_COUNT = BEHAVIOR_DIAGRAM_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__BOUNDS = CLASSIFIER_WITH_OPERATIONS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE__NESTED_ARTIFACT_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Artifact Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE___DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Artifact Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ARTIFACT_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__LOCAL_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__SHARED_STYLE = CLASSIFIER_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__TARGET_EDGE = CLASSIFIER_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__SOURCE_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__DIAGRAM = CLASSIFIER_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__UML_MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__SHARED_UML_STYLE = CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__LOCAL_UML_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__TARGET_UML_EDGE = CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__SOURCE_UML_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__BOUNDS = CLASSIFIER_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__LIST_ITEM_LABEL = CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__LAYOUT = CLASSIFIER_COMPARTMENT__LAYOUT;

	/**
	 * The feature id for the '<em><b>Artifact Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT__ARTIFACT_SHAPE = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Nested Artifact Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT_FEATURE_COUNT = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT___DIAGRAM = CLASSIFIER_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Nested Artifact Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_ARTIFACT_COMPARTMENT_OPERATION_COUNT = CLASSIFIER_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__MODEL_ELEMENT = REALIZATION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__LOCAL_STYLE = REALIZATION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SHARED_STYLE = REALIZATION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__TARGET_EDGE = REALIZATION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SOURCE_EDGE = REALIZATION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__DIAGRAM = REALIZATION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__UML_MODEL_ELEMENT = REALIZATION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SHARED_UML_STYLE = REALIZATION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__LOCAL_UML_STYLE = REALIZATION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__TARGET_UML_EDGE = REALIZATION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SOURCE_UML_EDGE = REALIZATION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = REALIZATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__STEREOTYPE_LABEL = REALIZATION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__UML_DIAGRAM = REALIZATION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__DIAGRAM_COMPARTMENT = REALIZATION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__MAIN_LABEL = REALIZATION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT = REALIZATION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__WAYPOINT = REALIZATION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT = REALIZATION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = REALIZATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE__ROLE_LABEL = REALIZATION_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Component Realization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE_FEATURE_COUNT = REALIZATION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE___DIAGRAM = REALIZATION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Component Realization Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COMPONENT_REALIZATION_EDGE_OPERATION_COUNT = REALIZATION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__MODEL_ELEMENT = ABSTRACTION_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__OWNING_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__OWNED_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__LOCAL_STYLE = ABSTRACTION_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SHARED_STYLE = ABSTRACTION_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__TARGET_EDGE = ABSTRACTION_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SOURCE_EDGE = ABSTRACTION_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__DIAGRAM = ABSTRACTION_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__UML_MODEL_ELEMENT = ABSTRACTION_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SHARED_UML_STYLE = ABSTRACTION_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__LOCAL_UML_STYLE = ABSTRACTION_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__TARGET_UML_EDGE = ABSTRACTION_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SOURCE_UML_EDGE = ABSTRACTION_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ABSTRACTION_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__STEREOTYPE_LABEL = ABSTRACTION_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__UML_DIAGRAM = ABSTRACTION_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__DIAGRAM_COMPARTMENT = ABSTRACTION_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__MAIN_LABEL = ABSTRACTION_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SOURCE_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__WAYPOINT = ABSTRACTION_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__TARGET_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ABSTRACTION_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Role Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE__ROLE_LABEL = ABSTRACTION_EDGE__ROLE_LABEL;

	/**
	 * The number of structural features of the '<em>Manifestation Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE_FEATURE_COUNT = ABSTRACTION_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE___DIAGRAM = ABSTRACTION_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Manifestation Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MANIFESTATION_EDGE_OPERATION_COUNT = ABSTRACTION_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__MODEL_ELEMENT = ELEMENT_WITH_PORTS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_WITH_PORTS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_WITH_PORTS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__LOCAL_STYLE = ELEMENT_WITH_PORTS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__SHARED_STYLE = ELEMENT_WITH_PORTS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__TARGET_EDGE = ELEMENT_WITH_PORTS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__SOURCE_EDGE = ELEMENT_WITH_PORTS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__DIAGRAM = ELEMENT_WITH_PORTS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__UML_MODEL_ELEMENT = ELEMENT_WITH_PORTS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__SHARED_UML_STYLE = ELEMENT_WITH_PORTS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__LOCAL_UML_STYLE = ELEMENT_WITH_PORTS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_WITH_PORTS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_WITH_PORTS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__TARGET_UML_EDGE = ELEMENT_WITH_PORTS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__SOURCE_UML_EDGE = ELEMENT_WITH_PORTS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_WITH_PORTS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__STEREOTYPE_LABEL = ELEMENT_WITH_PORTS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__UML_DIAGRAM = ELEMENT_WITH_PORTS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_WITH_PORTS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__MAIN_LABEL = ELEMENT_WITH_PORTS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__BOUNDS = ELEMENT_WITH_PORTS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_WITH_PORTS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__STRUCTURE_COMPARTMENT = ELEMENT_WITH_PORTS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__PORT_SHAPE = ELEMENT_WITH_PORTS_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Deployed Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT = ELEMENT_WITH_PORTS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Property Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE_FEATURE_COUNT = ELEMENT_WITH_PORTS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE___DIAGRAM = ELEMENT_WITH_PORTS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Property Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROPERTY_SHAPE_OPERATION_COUNT = ELEMENT_WITH_PORTS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__LOCAL_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__SHARED_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__TARGET_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__SOURCE_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__UML_MODEL_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__SHARED_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__LOCAL_UML_STYLE = CLASSIFIER_WITH_OPERATIONS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__TARGET_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__SOURCE_UML_EDGE = CLASSIFIER_WITH_OPERATIONS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASSIFIER_WITH_OPERATIONS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__STEREOTYPE_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__UML_DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__DIAGRAM_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__MAIN_LABEL = CLASSIFIER_WITH_OPERATIONS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__BOUNDS = CLASSIFIER_WITH_OPERATIONS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__STEREOTYPE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__USE_CLASSIFIER_NOTATION = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__USE_CASE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__ATTRIBUTE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OPERATION_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__STRUCTURE_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE__RECEPTION_COMPARTMENT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Collaboration Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE_FEATURE_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE___DIAGRAM = CLASSIFIER_WITH_OPERATIONS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Collaboration Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_SHAPE_OPERATION_COUNT = CLASSIFIER_WITH_OPERATIONS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Collaboration Use Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Collaboration Use Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int COLLABORATION_USE_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__MODEL_ELEMENT = ELEMENT_EDGE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__OWNING_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__OWNED_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__LOCAL_STYLE = ELEMENT_EDGE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SHARED_STYLE = ELEMENT_EDGE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__TARGET_EDGE = ELEMENT_EDGE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SOURCE_EDGE = ELEMENT_EDGE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__DIAGRAM = ELEMENT_EDGE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__UML_MODEL_ELEMENT = ELEMENT_EDGE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SHARED_UML_STYLE = ELEMENT_EDGE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__LOCAL_UML_STYLE = ELEMENT_EDGE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__TARGET_UML_EDGE = ELEMENT_EDGE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SOURCE_UML_EDGE = ELEMENT_EDGE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_EDGE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__STEREOTYPE_LABEL = ELEMENT_EDGE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__UML_DIAGRAM = ELEMENT_EDGE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__DIAGRAM_COMPARTMENT = ELEMENT_EDGE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__MAIN_LABEL = ELEMENT_EDGE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Source Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SOURCE_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Waypoint</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__WAYPOINT = ELEMENT_EDGE__WAYPOINT;

	/**
	 * The feature id for the '<em><b>Target Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__TARGET_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Source Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__SOURCE_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__SOURCE_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE__TARGET_UML_DIAGRAM_ELEMENT = ELEMENT_EDGE__TARGET_UML_DIAGRAM_ELEMENT;

	/**
	 * The number of structural features of the '<em>Template Binding Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE_FEATURE_COUNT = ELEMENT_EDGE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE___DIAGRAM = ELEMENT_EDGE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Template Binding Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TEMPLATE_BINDING_EDGE_OPERATION_COUNT = ELEMENT_EDGE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__SOURCE_EDGE = CLASS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__DIAGRAM = CLASS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__UML_MODEL_ELEMENT = CLASS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__SHARED_UML_STYLE = CLASS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__LOCAL_UML_STYLE = CLASS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__TARGET_UML_EDGE = CLASS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__SOURCE_UML_EDGE = CLASS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__STEREOTYPE_LABEL = CLASS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__UML_DIAGRAM = CLASS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__DIAGRAM_COMPARTMENT = CLASS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__MAIN_LABEL = CLASS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__BOUNDS = CLASS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__STEREOTYPE_COMPARTMENT = CLASS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__USE_CLASSIFIER_NOTATION = CLASS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__USE_CASE_COMPARTMENT = CLASS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__ATTRIBUTE_COMPARTMENT = CLASS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OPERATION_COMPARTMENT = CLASS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__RECEPTION_COMPARTMENT = CLASS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__STRUCTURE_COMPARTMENT = CLASS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE__PORT_SHAPE = CLASS_SHAPE__PORT_SHAPE;

	/**
	 * The number of structural features of the '<em>Stereotype Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE_FEATURE_COUNT = CLASS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE___DIAGRAM = CLASS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Stereotype Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STEREOTYPE_SHAPE_OPERATION_COUNT = CLASS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__SOURCE_EDGE = CLASS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__DIAGRAM = CLASS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__UML_MODEL_ELEMENT = CLASS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__SHARED_UML_STYLE = CLASS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__LOCAL_UML_STYLE = CLASS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__TARGET_UML_EDGE = CLASS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__SOURCE_UML_EDGE = CLASS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__STEREOTYPE_LABEL = CLASS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__UML_DIAGRAM = CLASS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__DIAGRAM_COMPARTMENT = CLASS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__MAIN_LABEL = CLASS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__BOUNDS = CLASS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__STEREOTYPE_COMPARTMENT = CLASS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__USE_CLASSIFIER_NOTATION = CLASS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__USE_CASE_COMPARTMENT = CLASS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__ATTRIBUTE_COMPARTMENT = CLASS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OPERATION_COMPARTMENT = CLASS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__RECEPTION_COMPARTMENT = CLASS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__STRUCTURE_COMPARTMENT = CLASS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__PORT_SHAPE = CLASS_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Deployed Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Nested Node Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE__NESTED_NODE_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE_FEATURE_COUNT = CLASS_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE___DIAGRAM = CLASS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NODE_SHAPE_OPERATION_COUNT = CLASS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__LOCAL_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__SHARED_STYLE = CLASSIFIER_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__TARGET_EDGE = CLASSIFIER_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__SOURCE_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__DIAGRAM = CLASSIFIER_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__UML_MODEL_ELEMENT = CLASSIFIER_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__SHARED_UML_STYLE = CLASSIFIER_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__LOCAL_UML_STYLE = CLASSIFIER_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__TARGET_UML_EDGE = CLASSIFIER_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__SOURCE_UML_EDGE = CLASSIFIER_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__BOUNDS = CLASSIFIER_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = CLASSIFIER_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__LIST_ITEM_LABEL = CLASSIFIER_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Layout</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__LAYOUT = CLASSIFIER_COMPARTMENT__LAYOUT;

	/**
	 * The feature id for the '<em><b>Node Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT__NODE_SHAPE = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Nested Node Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT_FEATURE_COUNT = CLASSIFIER_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT___DIAGRAM = CLASSIFIER_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Nested Node Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NESTED_NODE_COMPARTMENT_OPERATION_COUNT = CLASSIFIER_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__MODEL_ELEMENT = NODE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OWNING_DIAGRAM_ELEMENT = NODE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OWNED_DIAGRAM_ELEMENT = NODE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__LOCAL_STYLE = NODE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__SHARED_STYLE = NODE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__TARGET_EDGE = NODE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__SOURCE_EDGE = NODE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__DIAGRAM = NODE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__UML_MODEL_ELEMENT = NODE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__SHARED_UML_STYLE = NODE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__LOCAL_UML_STYLE = NODE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__TARGET_UML_EDGE = NODE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__SOURCE_UML_EDGE = NODE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__STEREOTYPE_LABEL = NODE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__UML_DIAGRAM = NODE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__DIAGRAM_COMPARTMENT = NODE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__MAIN_LABEL = NODE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__BOUNDS = NODE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__STEREOTYPE_COMPARTMENT = NODE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = NODE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__USE_CLASSIFIER_NOTATION = NODE_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OWNED_USE_CASE_COMPARTMENT = NODE_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__USE_CASE_COMPARTMENT = NODE_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__ATTRIBUTE_COMPARTMENT = NODE_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OPERATION_COMPARTMENT = NODE_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__RECEPTION_COMPARTMENT = NODE_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = NODE_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = NODE_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__STRUCTURE_COMPARTMENT = NODE_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__PORT_SHAPE = NODE_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Deployed Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT = NODE_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Node Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE__NESTED_NODE_COMPARTMENT = NODE_SHAPE__NESTED_NODE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Device Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE_FEATURE_COUNT = NODE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE___DIAGRAM = NODE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Device Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DEVICE_SHAPE_OPERATION_COUNT = NODE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__MODEL_ELEMENT = NODE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OWNING_DIAGRAM_ELEMENT = NODE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OWNED_DIAGRAM_ELEMENT = NODE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__LOCAL_STYLE = NODE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__SHARED_STYLE = NODE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__TARGET_EDGE = NODE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__SOURCE_EDGE = NODE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__DIAGRAM = NODE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__UML_MODEL_ELEMENT = NODE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__SHARED_UML_STYLE = NODE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__LOCAL_UML_STYLE = NODE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__TARGET_UML_EDGE = NODE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__SOURCE_UML_EDGE = NODE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__STEREOTYPE_LABEL = NODE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__UML_DIAGRAM = NODE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__DIAGRAM_COMPARTMENT = NODE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__MAIN_LABEL = NODE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__BOUNDS = NODE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__STEREOTYPE_COMPARTMENT = NODE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = NODE_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__USE_CLASSIFIER_NOTATION = NODE_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OWNED_USE_CASE_COMPARTMENT = NODE_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__USE_CASE_COMPARTMENT = NODE_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__ATTRIBUTE_COMPARTMENT = NODE_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OPERATION_COMPARTMENT = NODE_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__RECEPTION_COMPARTMENT = NODE_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = NODE_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = NODE_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__STRUCTURE_COMPARTMENT = NODE_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__PORT_SHAPE = NODE_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Deployed Artifact Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT = NODE_SHAPE__DEPLOYED_ARTIFACT_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Node Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE__NESTED_NODE_COMPARTMENT = NODE_SHAPE__NESTED_NODE_COMPARTMENT;

	/**
	 * The number of structural features of the '<em>Execution Environment Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE_FEATURE_COUNT = NODE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE___DIAGRAM = NODE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Execution Environment Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXECUTION_ENVIRONMENT_SHAPE_OPERATION_COUNT = NODE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__SOURCE_EDGE = CLASS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__DIAGRAM = CLASS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__UML_MODEL_ELEMENT = CLASS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__SHARED_UML_STYLE = CLASS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__LOCAL_UML_STYLE = CLASS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__TARGET_UML_EDGE = CLASS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__SOURCE_UML_EDGE = CLASS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__STEREOTYPE_LABEL = CLASS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__UML_DIAGRAM = CLASS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__DIAGRAM_COMPARTMENT = CLASS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__MAIN_LABEL = CLASS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__BOUNDS = CLASS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__STEREOTYPE_COMPARTMENT = CLASS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__USE_CLASSIFIER_NOTATION = CLASS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__USE_CASE_COMPARTMENT = CLASS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__ATTRIBUTE_COMPARTMENT = CLASS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OPERATION_COMPARTMENT = CLASS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__RECEPTION_COMPARTMENT = CLASS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__STRUCTURE_COMPARTMENT = CLASS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__PORT_SHAPE = CLASS_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Activity Node Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__ACTIVITY_NODE_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__PARAMETER_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Post Condition Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__POST_CONDITION_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Pre Condition Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__PRE_CONDITION_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Activity Parameter Node Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE__ACTIVITY_PARAMETER_NODE_SHAPE = CLASS_SHAPE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Activity Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE_FEATURE_COUNT = CLASS_SHAPE_FEATURE_COUNT + 5;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE___DIAGRAM = CLASS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Activity Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_SHAPE_OPERATION_COUNT = CLASS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Activity Node Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE__ACTIVITY_NODE_COMPARTMENT = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Element With Activity Nodes Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Element With Activity Nodes Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ELEMENT_WITH_ACTIVITY_NODES_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__MODEL_ELEMENT = DIAGRAM_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__LOCAL_STYLE = DIAGRAM_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__SHARED_STYLE = DIAGRAM_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__TARGET_EDGE = DIAGRAM_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__SOURCE_EDGE = DIAGRAM_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__DIAGRAM = DIAGRAM_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__UML_MODEL_ELEMENT = DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__SHARED_UML_STYLE = DIAGRAM_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__LOCAL_UML_STYLE = DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__TARGET_UML_EDGE = DIAGRAM_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__SOURCE_UML_EDGE = DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__BOUNDS = DIAGRAM_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Element With Activity Nodes Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT__ELEMENT_WITH_ACTIVITY_NODES_SHAPE = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Activity Node Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT_FEATURE_COUNT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT___DIAGRAM = DIAGRAM_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Activity Node Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_NODE_COMPARTMENT_OPERATION_COUNT = DIAGRAM_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Activity Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT__ACTIVITY_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Parameter Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Parameter Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARAMETER_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Activity Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT__ACTIVITY_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Post Condition Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Post Condition Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int POST_CONDITION_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__MODEL_ELEMENT = LIST_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__LOCAL_STYLE = LIST_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__SHARED_STYLE = LIST_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__TARGET_EDGE = LIST_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__SOURCE_EDGE = LIST_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__DIAGRAM = LIST_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__UML_MODEL_ELEMENT = LIST_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__SHARED_UML_STYLE = LIST_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__LOCAL_UML_STYLE = LIST_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = LIST_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__TARGET_UML_EDGE = LIST_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__SOURCE_UML_EDGE = LIST_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__BOUNDS = LIST_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>List Item Label</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__LIST_ITEM_LABEL = LIST_COMPARTMENT__LIST_ITEM_LABEL;

	/**
	 * The feature id for the '<em><b>Activity Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT__ACTIVITY_SHAPE = LIST_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Pre Condition Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT_FEATURE_COUNT = LIST_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT___DIAGRAM = LIST_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Pre Condition Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRE_CONDITION_COMPARTMENT_OPERATION_COUNT = LIST_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__MODEL_ELEMENT = OBJECT_NODE_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__LOCAL_STYLE = OBJECT_NODE_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__SHARED_STYLE = OBJECT_NODE_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__TARGET_EDGE = OBJECT_NODE_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__SOURCE_EDGE = OBJECT_NODE_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__DIAGRAM = OBJECT_NODE_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__UML_MODEL_ELEMENT = OBJECT_NODE_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__SHARED_UML_STYLE = OBJECT_NODE_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__LOCAL_UML_STYLE = OBJECT_NODE_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = OBJECT_NODE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__TARGET_UML_EDGE = OBJECT_NODE_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__SOURCE_UML_EDGE = OBJECT_NODE_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = OBJECT_NODE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__STEREOTYPE_LABEL = OBJECT_NODE_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__UML_DIAGRAM = OBJECT_NODE_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__DIAGRAM_COMPARTMENT = OBJECT_NODE_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__MAIN_LABEL = OBJECT_NODE_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__BOUNDS = OBJECT_NODE_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__STEREOTYPE_COMPARTMENT = OBJECT_NODE_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Selection Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__SELECTION_LABEL = OBJECT_NODE_SHAPE__SELECTION_LABEL;

	/**
	 * The feature id for the '<em><b>Constraint Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__CONSTRAINT_LABEL = OBJECT_NODE_SHAPE__CONSTRAINT_LABEL;

	/**
	 * The feature id for the '<em><b>Activity Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE__ACTIVITY_SHAPE = OBJECT_NODE_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Activity Parameter Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE_FEATURE_COUNT = OBJECT_NODE_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE___DIAGRAM = OBJECT_NODE_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Activity Parameter Node Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int ACTIVITY_PARAMETER_NODE_SHAPE_OPERATION_COUNT = OBJECT_NODE_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__SOURCE_EDGE = CLASS_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__DIAGRAM = CLASS_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__UML_MODEL_ELEMENT = CLASS_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__SHARED_UML_STYLE = CLASS_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__LOCAL_UML_STYLE = CLASS_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__TARGET_UML_EDGE = CLASS_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__SOURCE_UML_EDGE = CLASS_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = CLASS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__STEREOTYPE_LABEL = CLASS_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__UML_DIAGRAM = CLASS_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__DIAGRAM_COMPARTMENT = CLASS_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__MAIN_LABEL = CLASS_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__BOUNDS = CLASS_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__STEREOTYPE_COMPARTMENT = CLASS_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Template Parameter Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT = CLASS_SHAPE__TEMPLATE_PARAMETER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Classifier Notation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__USE_CLASSIFIER_NOTATION = CLASS_SHAPE__USE_CLASSIFIER_NOTATION;

	/**
	 * The feature id for the '<em><b>Owned Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OWNED_USE_CASE_COMPARTMENT = CLASS_SHAPE__OWNED_USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Use Case Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__USE_CASE_COMPARTMENT = CLASS_SHAPE__USE_CASE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Attribute Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__ATTRIBUTE_COMPARTMENT = CLASS_SHAPE__ATTRIBUTE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Operation Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OPERATION_COMPARTMENT = CLASS_SHAPE__OPERATION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Reception Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__RECEPTION_COMPARTMENT = CLASS_SHAPE__RECEPTION_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Nested Classifier Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__NESTED_CLASSIFIER_COMPARTMENT = CLASS_SHAPE__NESTED_CLASSIFIER_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Owned Behavior Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__OWNED_BEHAVIOR_COMPARTMENT = CLASS_SHAPE__OWNED_BEHAVIOR_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Structure Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__STRUCTURE_COMPARTMENT = CLASS_SHAPE__STRUCTURE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Port Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__PORT_SHAPE = CLASS_SHAPE__PORT_SHAPE;

	/**
	 * The feature id for the '<em><b>Lifeline Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__LIFELINE_SHAPE = CLASS_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Gate Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__GATE_SHAPE = CLASS_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Subfragment Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE__SUBFRAGMENT_COMPARTMENT = CLASS_SHAPE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Interaction Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE_FEATURE_COUNT = CLASS_SHAPE_FEATURE_COUNT + 3;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE___DIAGRAM = CLASS_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Interaction Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_SHAPE_OPERATION_COUNT = CLASS_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__MODEL_ELEMENT = INTERACTION_FRAGMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__OWNING_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__OWNED_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__LOCAL_STYLE = INTERACTION_FRAGMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__SHARED_STYLE = INTERACTION_FRAGMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__TARGET_EDGE = INTERACTION_FRAGMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__SOURCE_EDGE = INTERACTION_FRAGMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__DIAGRAM = INTERACTION_FRAGMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__UML_MODEL_ELEMENT = INTERACTION_FRAGMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__SHARED_UML_STYLE = INTERACTION_FRAGMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__LOCAL_UML_STYLE = INTERACTION_FRAGMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__TARGET_UML_EDGE = INTERACTION_FRAGMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__SOURCE_UML_EDGE = INTERACTION_FRAGMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = INTERACTION_FRAGMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__STEREOTYPE_LABEL = INTERACTION_FRAGMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__UML_DIAGRAM = INTERACTION_FRAGMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__DIAGRAM_COMPARTMENT = INTERACTION_FRAGMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__MAIN_LABEL = INTERACTION_FRAGMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__BOUNDS = INTERACTION_FRAGMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__STEREOTYPE_COMPARTMENT = INTERACTION_FRAGMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Lifeline Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__LIFELINE_SHAPE = INTERACTION_FRAGMENT_SHAPE__LIFELINE_SHAPE;

	/**
	 * The feature id for the '<em><b>Subfragment Compartment</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE__SUBFRAGMENT_COMPARTMENT = INTERACTION_FRAGMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Interaction Fragment With Subfragments Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE_FEATURE_COUNT = INTERACTION_FRAGMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE___DIAGRAM = INTERACTION_FRAGMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Interaction Fragment With Subfragments Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE_OPERATION_COUNT = INTERACTION_FRAGMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__MODEL_ELEMENT = DIAGRAM_COMPARTMENT__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__OWNING_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__OWNED_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__LOCAL_STYLE = DIAGRAM_COMPARTMENT__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__SHARED_STYLE = DIAGRAM_COMPARTMENT__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__TARGET_EDGE = DIAGRAM_COMPARTMENT__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__SOURCE_EDGE = DIAGRAM_COMPARTMENT__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__DIAGRAM = DIAGRAM_COMPARTMENT__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__UML_MODEL_ELEMENT = DIAGRAM_COMPARTMENT__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__SHARED_UML_STYLE = DIAGRAM_COMPARTMENT__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__LOCAL_UML_STYLE = DIAGRAM_COMPARTMENT__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__TARGET_UML_EDGE = DIAGRAM_COMPARTMENT__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__SOURCE_UML_EDGE = DIAGRAM_COMPARTMENT__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__BOUNDS = DIAGRAM_COMPARTMENT__BOUNDS;

	/**
	 * The feature id for the '<em><b>Top Uml Diagram Element</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT = DIAGRAM_COMPARTMENT__TOP_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Interaction Fragment With Subfragments Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT__INTERACTION_FRAGMENT_WITH_SUBFRAGMENTS_SHAPE = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Subfragment Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT_FEATURE_COUNT = DIAGRAM_COMPARTMENT_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT___DIAGRAM = DIAGRAM_COMPARTMENT___DIAGRAM;

	/**
	 * The number of operations of the '<em>Subfragment Compartment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SUBFRAGMENT_COMPARTMENT_OPERATION_COUNT = DIAGRAM_COMPARTMENT_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__MODEL_ELEMENT = INTERACTION_FRAGMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__OWNING_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__OWNED_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__LOCAL_STYLE = INTERACTION_FRAGMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__SHARED_STYLE = INTERACTION_FRAGMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__TARGET_EDGE = INTERACTION_FRAGMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__SOURCE_EDGE = INTERACTION_FRAGMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__DIAGRAM = INTERACTION_FRAGMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__UML_MODEL_ELEMENT = INTERACTION_FRAGMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__SHARED_UML_STYLE = INTERACTION_FRAGMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__LOCAL_UML_STYLE = INTERACTION_FRAGMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = INTERACTION_FRAGMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__TARGET_UML_EDGE = INTERACTION_FRAGMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__SOURCE_UML_EDGE = INTERACTION_FRAGMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = INTERACTION_FRAGMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__STEREOTYPE_LABEL = INTERACTION_FRAGMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__UML_DIAGRAM = INTERACTION_FRAGMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__DIAGRAM_COMPARTMENT = INTERACTION_FRAGMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__MAIN_LABEL = INTERACTION_FRAGMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__BOUNDS = INTERACTION_FRAGMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__STEREOTYPE_COMPARTMENT = INTERACTION_FRAGMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Lifeline Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__LIFELINE_SHAPE = INTERACTION_FRAGMENT_SHAPE__LIFELINE_SHAPE;

	/**
	 * The feature id for the '<em><b>Gate Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE__GATE_SHAPE = INTERACTION_FRAGMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Interaction Fragment With Gates Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE_FEATURE_COUNT = INTERACTION_FRAGMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE___DIAGRAM = INTERACTION_FRAGMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Interaction Fragment With Gates Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERACTION_FRAGMENT_WITH_GATES_SHAPE_OPERATION_COUNT = INTERACTION_FRAGMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__MODEL_ELEMENT = ELEMENT_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__OWNING_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__OWNED_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__LOCAL_STYLE = ELEMENT_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__SHARED_STYLE = ELEMENT_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__TARGET_EDGE = ELEMENT_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__SOURCE_EDGE = ELEMENT_SHAPE__SOURCE_EDGE;

	/**
	 * The feature id for the '<em><b>Diagram</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__DIAGRAM = ELEMENT_SHAPE__DIAGRAM;

	/**
	 * The feature id for the '<em><b>Uml Model Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__UML_MODEL_ELEMENT = ELEMENT_SHAPE__UML_MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Shared Uml Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__SHARED_UML_STYLE = ELEMENT_SHAPE__SHARED_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Local Uml Style</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__LOCAL_UML_STYLE = ELEMENT_SHAPE__LOCAL_UML_STYLE;

	/**
	 * The feature id for the '<em><b>Owned Uml Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__OWNED_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNED_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Uml Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__OWNING_UML_DIAGRAM_ELEMENT = ELEMENT_SHAPE__OWNING_UML_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Target Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__TARGET_UML_EDGE = ELEMENT_SHAPE__TARGET_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Source Uml Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__SOURCE_UML_EDGE = ELEMENT_SHAPE__SOURCE_UML_EDGE;

	/**
	 * The feature id for the '<em><b>Show Stereotype Attributes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES = ELEMENT_SHAPE__SHOW_STEREOTYPE_ATTRIBUTES;

	/**
	 * The feature id for the '<em><b>Stereotype Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__STEREOTYPE_LABEL = ELEMENT_SHAPE__STEREOTYPE_LABEL;

	/**
	 * The feature id for the '<em><b>Uml Diagram</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__UML_DIAGRAM = ELEMENT_SHAPE__UML_DIAGRAM;

	/**
	 * The feature id for the '<em><b>Diagram Compartment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__DIAGRAM_COMPARTMENT = ELEMENT_SHAPE__DIAGRAM_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Main Label</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__MAIN_LABEL = ELEMENT_SHAPE__MAIN_LABEL;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__BOUNDS = ELEMENT_SHAPE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Stereotype Compartment</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__STEREOTYPE_COMPARTMENT = ELEMENT_SHAPE__STEREOTYPE_COMPARTMENT;

	/**
	 * The feature id for the '<em><b>Interaction Fragment With Gates Shape</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE__INTERACTION_FRAGMENT_WITH_GATES_SHAPE = ELEMENT_SHAPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Gate Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE_FEATURE_COUNT = ELEMENT_SHAPE_FEATURE_COUNT + 1;

	/**
	 * The operation id for the '<em>Diagram</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE___DIAGRAM = ELEMENT_SHAPE___DIAGRAM;

	/**
	 * The number of operations of the '<em>Gate Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int GATE_SHAPE_OPERATION_COUNT = ELEMENT_SHAPE_OPERATION_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Model Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE_BEHAVIOR_SHAPE__MODEL_ELEMENT = CLASS_SHAPE__MODEL_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owning Diagram Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE_BEHAVIOR_SHAPE__OWNING_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNING_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Owned Diagram Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE_BEHAVIOR_SHAPE__OWNED_DIAGRAM_ELEMENT = CLASS_SHAPE__OWNED_DIAGRAM_ELEMENT;

	/**
	 * The feature id for the '<em><b>Local Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE_BEHAVIOR_SHAPE__LOCAL_STYLE = CLASS_SHAPE__LOCAL_STYLE;

	/**
	 * The feature id for the '<em><b>Shared Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE_BEHAVIOR_SHAPE__SHARED_STYLE = CLASS_SHAPE__SHARED_STYLE;

	/**
	 * The feature id for the '<em><b>Target Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE_BEHAVIOR_SHAPE__TARGET_EDGE = CLASS_SHAPE__TARGET_EDGE;

	/**
	 * The feature id for the '<em><b>Source Edge</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OPAQUE