/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.canonical;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.IVisualChildrenStrategy;
import org.eclipse.uml2.uml.Element;

public class DefaultUMLVisualChildrenStrategy
implements IVisualChildrenStrategy {
    public List<? extends View> getCanonicalChildren(EditPart editPart, View view) {
        ArrayList result = Lists.newArrayListWithCapacity((int)view.getChildren().size());
        this.collectChildren(view, result);
        EObject semantic = ((IGraphicalEditPart)editPart).resolveSemanticElement();
        ImmutableSet appliedStereotypes = semantic instanceof Element ? ImmutableSet.copyOf((Collection)((Element)semantic).getAppliedStereotypes()) : Collections.emptySet();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            EObject nextElement = ((View)iter.next()).getElement();
            if (nextElement != semantic && !appliedStereotypes.contains(nextElement)) continue;
            iter.remove();
        }
        return result;
    }

    protected void collectChildren(View view, List<? super View> result) {
        for (Object child : view.getChildren()) {
            if (!(child instanceof View)) continue;
            View childView = (View)child;
            if (ViewType.GROUP.equals(childView.getType())) {
                this.collectChildren(childView, result);
                continue;
            }
            result.add((View)childView);
        }
    }

    public List<? extends View> getCanonicalEdges(EditPart editPart, View view) {
        ArrayList result = Lists.newArrayList();
        if (view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__SOURCE_EDGES)) {
            result.addAll(view.getSourceEdges());
        }
        if (view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TARGET_EDGES)) {
            for (Edge next : view.getTargetEdges()) {
                if (next.getSource() == view) continue;
                result.add(next);
            }
        }
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            View next = (View)iter.next();
            if (!next.isSetElement() || next.getElement() != null) continue;
            iter.remove();
        }
        return result;
    }
}

