/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ConstraintFigure;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class AbstractConstraintEditPart
extends NamedElementEditPart {
    private static final String SPECIFICATION = "specification";
    protected static final String CONSTRAINT_VALUE_SPECIFICATION_LISTENER = "Constraint_valueSpecification_Listener";
    protected boolean first = true;

    public AbstractConstraintEditPart(View view) {
        super(view);
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        if (event.getFeature() instanceof ENamedElement && ((ENamedElement)event.getFeature()).getName().equals(SPECIFICATION)) {
            GraphicalEditPart gef = (GraphicalEditPart)this.getChildren().get(1);
            gef.notifyChanged(event);
        }
        super.handleNotificationEvent(event);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        EObject semanicElement = this.resolveSemanticElement();
        if (semanicElement instanceof Constraint) {
            ValueSpecification vs = ((Constraint)semanicElement).getSpecification();
            this.addListenerFilter(SPECIFICATION, (NotificationListener)this, (EObject)vs);
        }
    }

    public IPapyrusNodeFigure getPrimaryShape() {
        return new ConstraintFigure();
    }

    @Override
    protected void refreshLabelsFont(Font font) {
        super.refreshLabelsFont(font);
        if (this.getPrimaryShape() instanceof ConstraintFigure) {
            ((ConstraintFigure)this.getPrimaryShape()).getTextFlow().setFont(font);
        }
    }

    protected void refreshBackgroundColor() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style != null) {
            if (style.getGradient() == null || !this.supportsGradient()) {
                this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getFillColor())));
            } else {
                this.setGradient(style.getGradient());
            }
        }
    }

    protected void refreshTransparency() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style.getGradient() != null) {
            this.setTransparency(style.getTransparency());
        } else {
            this.setTransparency(0);
        }
    }

    @Override
    protected void setFontColor(Color color) {
        super.setFontColor(color);
        if (this.getPrimaryShape() instanceof ConstraintFigure) {
            ((ConstraintFigure)this.getPrimaryShape()).getPageFlow().setForegroundColor(color);
        }
    }

    protected void performDirectEditRequest(Request request) {
        if (this.resolveSemanticElement() instanceof Constraint) {
            Constraint constraint = (Constraint)this.resolveSemanticElement();
            if (this.first && constraint.getContext() == null) {
                this.first = false;
                ArrayList<IElementType> elementTypes = new ArrayList<IElementType>();
                if (this.elementTypeOfToolAfterCreation() != null) {
                    elementTypes.add(this.elementTypeOfToolAfterCreation());
                    AspectUnspecifiedTypeConnectionTool tool = new AspectUnspecifiedTypeConnectionTool(elementTypes);
                    this.getEditDomain().setActiveTool((Tool)tool);
                    tool.setSourceEditPart((EditPart)this);
                    return;
                }
            }
        }
        AbstractConstraintEditPart editPart = this;
        try {
            editPart = (EditPart)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl<Object>(){

                public void run() {
                    this.setResult(AbstractConstraintEditPart.this.getChildren().get(1));
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"performDirectEditRequest", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"performDirectEditRequest", (Throwable)e);
        }
        if (editPart != null) {
            editPart.performRequest(request);
        }
    }

    protected IElementType elementTypeOfToolAfterCreation() {
        return null;
    }
}

