/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import java.net.MalformedURLException;
import java.util.Iterator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ShapeNamedElementFigure;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractShapeEditPart
extends UMLNodeEditPart
implements IPapyrusEditPart {
    private static final String SHAPE_CONSTANT = "shape";
    private IPageIconsRegistry editorRegistry;

    public AbstractShapeEditPart(View view) {
        super(view);
    }

    protected NodeFigure createMainFigure() {
        return null;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
        catch (NullPointerException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    public abstract ShapeNamedElementFigure getPrimaryShape();

    @Override
    public Element getUMLElement() {
        return (Element)this.resolveSemanticElement();
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshIcons();
        this.refreshTransparency();
    }

    private void refreshIcons() {
        ShapeNamedElementFigure shape;
        Iterator iter = this.getUMLElement().getAppliedStereotypes().iterator();
        Stereotype stereotype = (Stereotype)iter.next();
        Image icon = ElementUtil.getStereotypeImage((Element)this.getUMLElement(), (Stereotype)stereotype, (String)SHAPE_CONSTANT);
        if (icon != null && (shape = this.getPrimaryShape()) != null) {
            if (icon.getLocation() != null && !icon.getLocation().isEmpty()) {
                try {
                    shape.setIcon(icon.getLocation());
                }
                catch (MalformedURLException e) {
                    Activator.log.error(String.format("$0 $1", icon.getLocation(), e.getLocalizedMessage()), (Throwable)e);
                }
            } else {
                shape.setIcon(Activator.getShape(this.getUMLElement(), stereotype, false));
            }
        }
    }
}

