/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.commands.ApplyStereotypeCommand;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.papyrus.uml.diagram.common.service.palette.Configuration;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteAspectToolEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.PropertyRepresentation;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypeRepresentation;
import org.eclipse.papyrus.uml.diagram.common.service.palette.Value;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.PropertyEditors;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StereotypePostAction
extends ModelPostAction {
    protected static final String ICONS_UP = "/icons/arrow_up.gif";
    protected static final String ICONS_DOWN = "/icons/arrow_down.gif";
    protected static final String ICONS_ADD = "/icons/obj16/Add_16x16.gif";
    protected static final String ICONS_REMOVE = "/icons/delete.gif";
    protected static final String ICON_STEREOTYPE = "/icons/stereotype.gif";
    protected static final String ICON_PROFILE = "/icons/profile.gif";
    protected static final String ICON_PROPERTY = "/icons/property.gif";
    protected static final String ICON_METACLASS = "/icons/Metaclass.gif";
    protected static final String ICON_LITERALBOOLEAN = "/icons/LiteralBoolean.gif";
    protected static final String ICON_LITERALINTEGER = "/icons/LiteralInteger.gif";
    protected static final String ICON_LITERALREAL = "/icons/LiteralReal.gif";
    protected static final String ICON_LITERALSTRING = "/icons/LiteralString.gif";
    protected static final String ICON_LITERALUNLIMITEDNATURAL = "/icons/LiteralUnlimitedNatural.gif";
    protected static final String ICON_UNKNOWN = "/icons/Clause.gif";
    protected static final String ICON_ENUMERATION = "/icons/Enumeration.gif";
    protected static final String ICON_DATATYPE = "/icons/DataType.gif";
    protected Configuration config;
    protected static final String SEPARATOR = ", ";
    protected TreeViewer stereotypesViewer;
    protected IPaletteEntryProxy entryProxy;
    protected EditorLabelProvider editorLabelProvider = new EditorLabelProvider();
    protected StereotypeContentProvider stereotypeContentProvider = new StereotypeContentProvider();
    protected Button removeButton;
    protected Button addButton;
    protected Button upButton;
    protected Button downButton;
    public static final String MOVE_DOWN = "move down";
    public static final String MOVE_UP = "move up";
    private Object[] expandedElements = null;
    public static final String UMLPrimitiveTypes_BOOLEAN = "PrimitiveTypes::Boolean";
    public static final String UMLPrimitiveTypes_INTEGER = "PrimitiveTypes::Integer";
    public static final String UMLPrimitiveTypes_STRING = "PrimitiveTypes::String";
    public static final String UMLPrimitiveTypes_UNLIMITED_NATURAL = "PrimitiveTypes::UnlimitedNatural";
    public static final String UMLPrimitiveTypes_REAL = "PrimitiveTypes::Real";
    protected static final String ICON_CHECKED = "/icons/complete_tsk.gif";
    protected static final String ICON_UNCHECKED = "/icons/incomplete_tsk.gif";
    private TreeViewerColumn stereotypeColumn = null;
    private TreeViewerColumn runtimeColumn = null;
    private ArrayList<Value> savedValues;

    @Override
    public IStatus checkPostCondition() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus checkPreCondition() {
        return Status.OK_STATUS;
    }

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        this.config = new Configuration(configurationNode);
    }

    @Override
    public void save(Node parentNode) {
        if (parentNode instanceof Element) {
            this.config.save(parentNode);
        } else {
            Activator.log.error("parent node is not an Element", null);
        }
    }

    @Override
    public ICommand getPostCommand(IAdaptable viewAdapter) {
        this.config = new Configuration(this.config.getConfigurationNode());
        TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        CompositeTransactionalCommand cmd = new CompositeTransactionalCommand(editingDomain, "Apply stereotype");
        final ApplyStereotypeRequest request = new ApplyStereotypeRequest(viewAdapter, this.config.getStereotypesToApplyQN(), true);
        cmd.add((IUndoableOperation)new ApplyStereotypeCommand(editingDomain, request));
        AbstractTransactionalCommand setPropertiesCommand = new AbstractTransactionalCommand(editingDomain, "Set stereotype values", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                org.eclipse.uml2.uml.Element element;
                org.eclipse.uml2.uml.Element packageContainer = element = request.getElement();
                while (!((packageContainer = packageContainer.getOwner()) instanceof Package) && packageContainer != null) {
                }
                if (packageContainer != null) {
                    StereotypePostAction.this.config.setAppliedProfiles((List<Profile>)((Package)packageContainer).getAllAppliedProfiles());
                }
                if (StereotypePostAction.this.config.hasRuntimeProperties()) {
                    StereotypePostAction.this.defineRuntimeProperties(StereotypePostAction.this.config);
                }
                ArrayList<StereotypeRepresentation> stereotypes = StereotypePostAction.this.config.getStereotypesRepresentations();
                for (StereotypeRepresentation stereotype : stereotypes) {
                    Stereotype stereotypeToEdit = stereotype.getUMLStereotype();
                    ArrayList<PropertyRepresentation> properties = stereotype.getPropertiesWithValues();
                    for (PropertyRepresentation property : properties) {
                        if (!property.hasValues()) continue;
                        Type type = property.getType();
                        String propertyName = property.getUMLProperty().getName();
                        if (type == null || propertyName == null) continue;
                        Object newValue = null;
                        if (type instanceof PrimitiveType) {
                            newValue = Util.getValueFromString(property.getUMLProperty(), property.getStringValue());
                        } else if (Util.isMetaclass(type)) {
                            newValue = Util.retrievesMetaclassElementFromString(property.getUMLProperty(), property.getStringValue(), packageContainer);
                        } else if (type instanceof Enumeration) {
                            newValue = Util.retrievesEnumerationLiteralFromString(property.getUMLProperty(), property.getStringValue(), packageContainer);
                        } else if (type instanceof DataType) {
                            newValue = Util.getValueFromString(property.getUMLProperty(), property.getStringValue());
                        } else if (type instanceof Stereotype) {
                            newValue = Util.retrievesStereotypedElementFromString(property.getUMLProperty(), property.getStringValue(), packageContainer);
                        } else if (type instanceof Class && !(type instanceof Stereotype) && property.getUMLProperty().isMultivalued()) {
                            newValue = null;
                        } else {
                            Activator.log.error("impossible to find a correct editor for the property" + property, null);
                        }
                        if (newValue == null) continue;
                        element.setValue(stereotypeToEdit, propertyName, newValue);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
        cmd.add((IUndoableOperation)setPropertiesCommand);
        return cmd;
    }

    private void saveValues() {
        this.savedValues = new ArrayList();
        for (StereotypeRepresentation steRep : this.config.getStereotypesRepresentations()) {
            if (!steRep.hasRuntimeProperties()) continue;
            for (PropertyRepresentation propRep : steRep.getRuntimeProperties()) {
                for (Value value : propRep.getValues()) {
                    Value newVal = new Value(value);
                    newVal.setPropertyRepresentation(propRep);
                    this.savedValues.add(newVal);
                }
            }
        }
    }

    private void restoreValues() {
        for (Value value : this.savedValues) {
        }
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.config.setAppliedProfiles(appliedProfiles);
        this.entryProxy = entryProxy;
        Composite mainComposite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(5, false);
        mainComposite.setLayout((Layout)layout);
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText("Stereotypes to Apply");
        GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
        titleLabel.setLayoutData((Object)data);
        this.addButton = new Button(mainComposite, 0);
        this.addButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", ICONS_ADD));
        this.addButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                StereotypePostAction.this.performAddButtonPressed(StereotypePostAction.this.stereotypesViewer);
                StereotypePostAction.this.selectionHasChange();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.removeButton = new Button(mainComposite, 0);
        this.removeButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", ICONS_REMOVE));
        this.removeButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                StereotypePostAction.this.performRemoveAction(StereotypePostAction.this.stereotypesViewer);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.removeButton.setEnabled(false);
        this.upButton = new Button(mainComposite, 0);
        this.upButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", ICONS_UP));
        this.upButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                StereotypePostAction.this.moveElement(StereotypePostAction.MOVE_UP, StereotypePostAction.this.stereotypesViewer);
                StereotypePostAction.this.selectionHasChange();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(mainComposite, 0);
        this.downButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", ICONS_DOWN));
        this.downButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                StereotypePostAction.this.moveElement(StereotypePostAction.MOVE_DOWN, StereotypePostAction.this.stereotypesViewer);
                StereotypePostAction.this.selectionHasChange();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.downButton.setEnabled(false);
        this.stereotypesViewer = new TreeViewer(mainComposite, 67586);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 5;
        this.stereotypesViewer.getControl().setLayoutData((Object)data);
        this.stereotypesViewer.setContentProvider((IContentProvider)this.stereotypeContentProvider);
        this.stereotypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StereotypePostAction.this.performSelectionChange(event);
            }
        });
        this.stereotypesViewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    StereotypePostAction.this.performF2Action(StereotypePostAction.this.stereotypesViewer);
                } else if (e.character == '\u007f') {
                    StereotypePostAction.this.performRemoveAction(StereotypePostAction.this.stereotypesViewer);
                } else if (e.stateMask == 262144 && e.keyCode == 110) {
                    StereotypePostAction.this.performCTRL_N_Action(e, StereotypePostAction.this.stereotypesViewer);
                }
                StereotypePostAction.this.selectionHasChange();
            }
        });
        this.stereotypesViewer.getControl().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (StereotypePostAction.this.stereotypeColumn != null) {
                    if (e.x < StereotypePostAction.this.stereotypeColumn.getColumn().getWidth()) {
                        StereotypePostAction.this.performDoubleClickAction(StereotypePostAction.this.stereotypesViewer);
                    } else {
                        ViewerCell cell = StereotypePostAction.this.runtimeColumn.getViewer().getCell(new Point(e.x, e.y));
                        if (cell != null) {
                            Object element = ((TreeSelection)StereotypePostAction.this.stereotypesViewer.getSelection()).getFirstElement();
                            StereotypePostAction.this.stereotypesViewer.editElement(element, 1);
                        }
                    }
                }
            }
        });
        this.createColumn(this.stereotypesViewer);
        this.updateStereotypeViewer();
        return mainComposite;
    }

    protected void createColumn(TreeViewer viewer) {
        this.stereotypeColumn = new TreeViewerColumn(viewer, 4);
        this.stereotypeColumn.getColumn().setResizable(true);
        this.stereotypeColumn.getColumn().setWidth(300);
        this.stereotypeColumn.setLabelProvider((CellLabelProvider)this.editorLabelProvider);
        this.stereotypeColumn.setEditingSupport((EditingSupport)new AttributeEditingSupport((ColumnViewer)viewer));
        this.runtimeColumn = new TreeViewerColumn(viewer, 0x1000000);
        this.runtimeColumn.getColumn().setText("Runtime");
        this.runtimeColumn.getColumn().setResizable(true);
        this.runtimeColumn.getColumn().setWidth(80);
        this.runtimeColumn.setLabelProvider((CellLabelProvider)new RuntimeLabelProvider());
        this.runtimeColumn.setEditingSupport((EditingSupport)new RuntimeEditingSupport((ColumnViewer)viewer));
        viewer.getTree().setLinesVisible(true);
        viewer.getTree().setHeaderVisible(true);
    }

    protected void updateStereotypeViewer() {
        if (this.stereotypesViewer != null) {
            this.saveExpandedNode();
            this.stereotypesViewer.setInput(this.config.getStereotypesRepresentations());
            this.restoreExpandedNode();
        }
    }

    protected void selectionHasChange() {
        this.performSelectionChange(new SelectionChangedEvent((ISelectionProvider)this.stereotypesViewer, this.stereotypesViewer.getSelection()));
    }

    protected void performAddButtonPressed(TreeViewer tree) {
        TreeSelection selection = (TreeSelection)tree.getSelection();
        if (selection != null && selection.size() == 1) {
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof PropertyRepresentation) {
                PropertyRepresentation prop = (PropertyRepresentation)selectedElement;
                if (prop.getUpperMultiplicity() != 1) {
                    this.editMe(prop, null);
                } else if (!prop.getValues().isEmpty()) {
                    this.editMe(prop, prop.getValues().get(0));
                } else {
                    this.editMe(prop, null);
                }
                tree.refresh(selectedElement);
            }
            return;
        }
        if (!(this.entryProxy instanceof IPaletteAspectToolEntryProxy)) {
            return;
        }
        PaletteEntry entry = ((IPaletteAspectToolEntryProxy)this.entryProxy).getEntry();
        if (!(entry instanceof ToolEntry)) {
            return;
        }
        EClass metaClass = PaletteUtil.getToolMetaclass((ToolEntry)entry);
        if (metaClass == null) {
            Activator.log.error("Impossible to find metaclass", null);
            return;
        }
        List<Stereotype> stereotypeList = this.config.getUMLStereotypes();
        CheckedTreeSelectionDialog selectionDialog = new CheckedTreeSelectionDialog(DisplayUtils.getDisplay().getActiveShell(), (ILabelProvider)this.editorLabelProvider, (ITreeContentProvider)new ProfileContentProvider(metaClass));
        selectionDialog.setTitle(Messages.StereotypePostAction_StereotypeSelectionTitle);
        selectionDialog.setMessage(Messages.StereotypePostAction_StereotypeSelectionMessage);
        selectionDialog.setContainerMode(true);
        selectionDialog.setInitialElementSelections(stereotypeList);
        selectionDialog.setInput(this.config.getAppliedProfiles());
        selectionDialog.setExpandedElements(this.config.getAppliedProfiles().toArray());
        ViewerComparator comparator = new ViewerComparator();
        selectionDialog.setComparator(comparator);
        if (selectionDialog.open() == 0) {
            Object[] result = selectionDialog.getResult();
            ArrayList<String> stereotypesToApply = new ArrayList<String>();
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof Stereotype) {
                    stereotypesToApply.add(((Stereotype)result[i]).getQualifiedName());
                }
                ++i;
            }
            this.config.setStereotypesRepresentations(stereotypesToApply);
            this.updateStereotypeViewer();
        }
    }

    protected void performRemoveAction(TreeViewer viewer) {
        ITreeSelection selection = (ITreeSelection)viewer.getSelection();
        if (selection != null) {
            List selectedElements = ((TreeSelection)selection).toList();
            if (this.sameLevelForFullSelection(selection)) {
                if (selection.getFirstElement() instanceof StereotypeRepresentation) {
                    for (Object object : selectedElements) {
                        if (!(object instanceof StereotypeRepresentation)) continue;
                        this.config.removeStereotype((StereotypeRepresentation)object);
                    }
                } else if (selection.getFirstElement() instanceof PropertyRepresentation) {
                    for (Object object : selectedElements) {
                        if (!(object instanceof PropertyRepresentation) || ((PropertyRepresentation)object).getUMLProperty().isMultivalued()) continue;
                        ((PropertyRepresentation)object).getValues().remove(0);
                    }
                } else if (selection.getFirstElement() instanceof Value) {
                    for (Object object : selectedElements) {
                        if (!(object instanceof Value)) continue;
                        ((Value)object).getPropertyRepresentation().removeValue((Value)object);
                    }
                }
                viewer.refresh();
            }
        }
    }

    protected void performF2Action(TreeViewer viewer) {
        TreeSelection selection = (TreeSelection)viewer.getSelection();
        if (selection != null && selection.size() == 1) {
            PropertyRepresentation propRep;
            Type type;
            Object objectToEdit = selection.getFirstElement();
            if (objectToEdit instanceof PropertyRepresentation) {
                Property prop = ((PropertyRepresentation)objectToEdit).getUMLProperty();
                if (!prop.isMultivalued() && (prop.getType() instanceof PrimitiveType || prop.getType() instanceof DataType)) {
                    viewer.editElement((Object)prop, 0);
                }
            } else if (objectToEdit instanceof Value && (type = (propRep = ((Value)objectToEdit).getPropertyRepresentation()).getType()) != null) {
                if (type instanceof PrimitiveType || type instanceof DataType) {
                    viewer.editElement(objectToEdit, 0);
                } else {
                    this.editMe(propRep, (Value)objectToEdit);
                    viewer.refresh((Object)propRep);
                }
            }
        }
    }

    protected void performDoubleClickAction(TreeViewer viewer) {
        TreeSelection selection = (TreeSelection)viewer.getSelection();
        if (selection != null && selection.size() == 1) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof StereotypeRepresentation) {
                viewer.setExpandedState(selectedObject, !viewer.getExpandedState(selectedObject));
            } else if (selectedObject instanceof PropertyRepresentation) {
                Property prop = ((PropertyRepresentation)selectedObject).getUMLProperty();
                if (prop.isMultivalued()) {
                    viewer.setExpandedState(selectedObject, !viewer.getExpandedState(selectedObject));
                } else {
                    if (((PropertyRepresentation)selectedObject).getValues().isEmpty()) {
                        this.editMe((PropertyRepresentation)selectedObject, null);
                    } else {
                        this.editMe((PropertyRepresentation)selectedObject, ((PropertyRepresentation)selectedObject).getValues().get(0));
                    }
                    viewer.update(selectedObject, null);
                }
            } else if (selectedObject instanceof Value) {
                this.editMe(((Value)selectedObject).getPropertyRepresentation(), (Value)selectedObject);
                viewer.refresh(selectedObject);
            }
        }
    }

    protected void performCTRL_N_Action(KeyEvent e, TreeViewer viewer) {
        Property property;
        Object selectedObject;
        TreeSelection selection = (TreeSelection)viewer.getSelection();
        if (selection != null && selection.size() == 1 && (selectedObject = selection.getFirstElement()) != null && selectedObject instanceof PropertyRepresentation && (property = ((PropertyRepresentation)selectedObject).getUMLProperty()).isMultivalued()) {
            int upperMultiplicity = property.getUpper();
            ArrayList<Value> values = ((PropertyRepresentation)selectedObject).getValues();
            if (upperMultiplicity == -1 || values.size() < upperMultiplicity) {
                this.editMe((PropertyRepresentation)selectedObject, null);
            } else if (values.size() == 0) {
                this.editMe((PropertyRepresentation)selectedObject, null);
            }
            viewer.refresh(selectedObject);
        }
    }

    protected void performSelectionChange(SelectionChangedEvent event) {
        ITreeSelection selection = (ITreeSelection)event.getSelection();
        int selectionSize = selection.size();
        if (selectionSize == 0 || !this.sameLevelForFullSelection(selection)) {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else if (selectionSize == 1) {
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof StereotypeRepresentation) {
                this.removeButton.setEnabled(true);
            } else if (selectedElement instanceof PropertyRepresentation) {
                if (((PropertyRepresentation)selectedElement).getUpperMultiplicity() == 1) {
                    this.removeButton.setEnabled(true);
                } else {
                    this.removeButton.setEnabled(false);
                }
            } else if (selectedElement instanceof Value) {
                this.removeButton.setEnabled(true);
            }
            if (selectedElement instanceof StereotypeRepresentation) {
                this.addButton.setEnabled(true);
            } else if (selectedElement instanceof PropertyRepresentation) {
                ArrayList<Value> values = ((PropertyRepresentation)selectedElement).getValues();
                Property prop = ((PropertyRepresentation)selectedElement).getUMLProperty();
                if (!prop.isMultivalued()) {
                    if (values.size() == 0) {
                        this.addButton.setEnabled(true);
                    } else {
                        this.addButton.setEnabled(false);
                    }
                } else {
                    int upper = prop.getUpper();
                    if (upper == -1) {
                        this.addButton.setEnabled(true);
                    } else if (values.size() < upper) {
                        this.addButton.setEnabled(true);
                    } else {
                        this.addButton.setEnabled(false);
                    }
                }
            } else if (selectedElement instanceof Value) {
                this.addButton.setEnabled(false);
            }
            if (selectedElement instanceof StereotypeRepresentation) {
                int index = this.config.getStereotypesRepresentations().indexOf(selectedElement);
                if (this.config.getStereotypesRepresentations().size() == 1) {
                    this.downButton.setEnabled(false);
                    this.upButton.setEnabled(false);
                } else if (index == 0) {
                    this.downButton.setEnabled(true);
                    this.upButton.setEnabled(false);
                } else if (index == this.config.getStereotypesRepresentations().size() - 1) {
                    this.downButton.setEnabled(false);
                    this.upButton.setEnabled(true);
                } else {
                    this.downButton.setEnabled(true);
                    this.upButton.setEnabled(true);
                }
            } else if (selectedElement instanceof PropertyRepresentation) {
                this.downButton.setEnabled(false);
                this.upButton.setEnabled(false);
            } else if (selectedElement instanceof Value) {
                ArrayList<Value> valuesList = ((Value)selectedElement).getPropertyRepresentation().getValues();
                int index = valuesList.indexOf(selectedElement);
                if (valuesList.size() == 1) {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                } else if (index == 0) {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(true);
                } else if (index == valuesList.size() - 1) {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(false);
                } else {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(true);
                }
            }
        } else {
            List selectedElements = ((TreeSelection)selection).toList();
            if (selection.getFirstElement() instanceof StereotypeRepresentation) {
                this.removeButton.setEnabled(true);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                this.addButton.setEnabled(true);
            } else if (selection.getFirstElement() instanceof Value) {
                this.removeButton.setEnabled(true);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                this.addButton.setEnabled(false);
            }
        }
    }

    protected void moveElement(String shiftValue, TreeViewer viewer) {
        TreeSelection selection = (TreeSelection)viewer.getSelection();
        if (selection != null && selection.size() == 1) {
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof Value) {
                this.exchangeTwoValues(((Value)selectedElement).getPropertyRepresentation().getValues(), selectedElement, shiftValue);
                viewer.refresh((Object)((Value)selectedElement).getPropertyRepresentation());
            } else if (selectedElement instanceof StereotypeRepresentation) {
                this.exchangeTwoValues(this.config.getStereotypesRepresentations(), selectedElement, shiftValue);
                viewer.refresh();
            }
        }
    }

    protected void exchangeTwoValues(ArrayList arrayList, Object selectedElement, String shiftValue) {
        int index = this.getIndexOf(arrayList, selectedElement);
        if (arrayList == null || arrayList.size() < 2) {
            return;
        }
        if (shiftValue.equals(MOVE_UP) && index == 0 || shiftValue.equals(MOVE_DOWN) && arrayList.size() == index + 1) {
            return;
        }
        if (shiftValue.equals(MOVE_DOWN)) {
            arrayList.set(index, arrayList.get(index + 1));
            arrayList.set(index + 1, selectedElement);
        } else if (shiftValue.equals(MOVE_UP)) {
            arrayList.set(index, arrayList.get(index - 1));
            arrayList.set(index - 1, selectedElement);
        }
    }

    protected boolean sameLevelForFullSelection(ITreeSelection selection) {
        TreePath[] path;
        List selectedElements = ((TreeSelection)selection).toList();
        if (!selectedElements.isEmpty() && (path = selection.getPathsFor(selectedElements.get(0))) != null) {
            int level = path[0].getSegmentCount();
            for (Object object : selectedElements) {
                path = selection.getPathsFor(object);
                if (level == path[0].getSegmentCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<String> getStereotypesToApply() {
        return this.config.getStereotypesToApplyQN();
    }

    public void editMe(PropertyRepresentation propRepresentation, Value valueToEdit) {
        Type type = propRepresentation.getType();
        Property property = propRepresentation.getUMLProperty();
        String value = null;
        if (type instanceof PrimitiveType) {
            String typeName = type.getQualifiedName();
            if (UMLPrimitiveTypes_BOOLEAN.equals(typeName)) {
                value = PropertyEditors.BooleanEditor(property, valueToEdit);
            } else if (UMLPrimitiveTypes_STRING.equals(typeName)) {
                value = PropertyEditors.StringEditor(property, valueToEdit);
            } else if (UMLPrimitiveTypes_REAL.equals(typeName)) {
                value = PropertyEditors.RealEditor(property, valueToEdit);
            } else if (UMLPrimitiveTypes_INTEGER.equals(typeName)) {
                value = PropertyEditors.IntegerEditor(property, valueToEdit);
            } else if (UMLPrimitiveTypes_UNLIMITED_NATURAL.equals(typeName)) {
                value = PropertyEditors.UnlimitedNaturalEditor(property, valueToEdit);
            }
        } else if (Util.isMetaclass(type)) {
            value = PropertyEditors.MetaclassEditor(property, valueToEdit, this.config.getAppliedProfiles());
        } else if (type instanceof Enumeration) {
            value = PropertyEditors.EnumerationEditor(property, valueToEdit);
        } else if (type instanceof DataType) {
            value = PropertyEditors.DataTypeEditor(property, valueToEdit);
        } else if (type instanceof Stereotype) {
            value = PropertyEditors.StereotypeEditor(property, valueToEdit, this.config.getAppliedProfiles());
        } else if (type instanceof Class && !(type instanceof Stereotype) && property.isMultivalued()) {
            value = PropertyEditors.CompositeClassEditor(property, valueToEdit);
        } else {
            Activator.log.error("Impossible to find a correct editor for the property" + property, null);
            return;
        }
        if (value == null && valueToEdit == null) {
            return;
        }
        if (value == null && valueToEdit != null) {
            valueToEdit.getPropertyRepresentation().getValues().remove(valueToEdit);
        } else if (value != null && valueToEdit == null) {
            propRepresentation.addValue(new Value(value));
        } else if (value != null && valueToEdit != null) {
            valueToEdit.setValue(value);
        }
    }

    public int getIndexOf(ArrayList<?> list, Object obj) {
        int index = -1;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == obj) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    protected void saveExpandedNode() {
        this.expandedElements = this.stereotypesViewer.getExpandedElements();
    }

    protected void restoreExpandedNode() {
        if (this.expandedElements != null) {
            this.stereotypesViewer.setExpandedElements(this.expandedElements);
            this.expandedElements = null;
        }
    }

    protected void defineRuntimeProperties(Configuration config) {
        ArrayList<StereotypeRepresentation> steWithPropToEdit = new ArrayList<StereotypeRepresentation>();
        for (StereotypeRepresentation ste : config.getStereotypesRepresentations()) {
            if (!ste.hasRuntimeProperties()) continue;
            StereotypeRepresentation newSte = new StereotypeRepresentation(ste);
            for (PropertyRepresentation propRep : ste.getRuntimeProperties()) {
                PropertyRepresentation prop = new PropertyRepresentation(propRep);
                newSte.addProperty(prop);
            }
            steWithPropToEdit.add(newSte);
        }
        RuntimePropertiesDialog dialog = new RuntimePropertiesDialog(new Shell(), steWithPropToEdit);
        dialog.open();
    }

    public class AttributeEditingSupport
    extends EditingSupport {
        protected final String[] booleanProposals;
        protected TreeViewer treeViewer;

        public AttributeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.booleanProposals = new String[]{"", "true", "false"};
            this.treeViewer = null;
            this.treeViewer = (TreeViewer)viewer;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            Type type = null;
            CellEditor editor = null;
            if (element instanceof Value) {
                type = ((Value)element).getPropertyRepresentation().getType();
            }
            if (type != null && type instanceof PrimitiveType) {
                String typeName = type.getQualifiedName();
                if (StereotypePostAction.UMLPrimitiveTypes_BOOLEAN.equals(typeName)) {
                    editor = this.createBooleanEditor((Composite)this.treeViewer.getTree());
                } else if (StereotypePostAction.UMLPrimitiveTypes_STRING.equals(typeName)) {
                    editor = new TextCellEditor((Composite)this.treeViewer.getTree());
                } else if (StereotypePostAction.UMLPrimitiveTypes_INTEGER.equals(typeName)) {
                    editor = new TextCellEditor((Composite)this.treeViewer.getTree());
                } else if (StereotypePostAction.UMLPrimitiveTypes_UNLIMITED_NATURAL.equals(typeName)) {
                    editor = new TextCellEditor((Composite)this.treeViewer.getTree());
                }
            }
            return editor;
        }

        protected CellEditor createBooleanEditor(Composite parent) {
            return new ComboBoxCellEditor(parent, this.booleanProposals, 8);
        }

        protected Object getValue(Object element) {
            Property prop;
            if (element instanceof Value && (prop = ((Value)element).getPropertyRepresentation().getUMLProperty()).getType() != null && prop.getType().getQualifiedName().equals(StereotypePostAction.UMLPrimitiveTypes_BOOLEAN)) {
                int index = 0;
                while (index < this.booleanProposals.length) {
                    if (this.booleanProposals[index].equals(element.toString())) {
                        return index;
                    }
                    ++index;
                }
                return 0;
            }
            return element.toString();
        }

        protected void setValue(Object oldValue, Object newValue) {
            if (!"".equals(newValue) && oldValue instanceof Value) {
                Property property = ((Value)oldValue).getPropertyRepresentation().getUMLProperty();
                if (property.getType() != null) {
                    if (property.getType() instanceof PrimitiveType) {
                        String typeName = property.getType().getQualifiedName();
                        if (StereotypePostAction.UMLPrimitiveTypes_BOOLEAN.equals(typeName)) {
                            this.setBooleanValue(oldValue, newValue);
                        } else {
                            ((Value)oldValue).setValue((String)newValue);
                        }
                    } else {
                        ((Value)oldValue).setValue((String)newValue);
                    }
                }
                this.treeViewer.refresh(oldValue);
            }
        }

        protected void setBooleanValue(Object oldValue, Object newValue) {
            if (newValue == null || newValue.equals(0)) {
                ((Value)oldValue).getPropertyRepresentation().getValues().remove(oldValue);
            } else if (newValue.equals(1)) {
                ((Value)oldValue).setValue(this.booleanProposals[1]);
            } else if (newValue.equals(2)) {
                ((Value)oldValue).setValue(this.booleanProposals[2]);
            } else {
                Activator.log.error("Impossible to set boolean value " + newValue, null);
            }
        }
    }

    protected class EditorLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        protected EditorLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }

        public String getText(Object element) {
            if (element instanceof Profile) {
                return ((Profile)element).getLabel();
            }
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getLabel();
            }
            if (element instanceof StereotypeRepresentation) {
                return ((StereotypeRepresentation)element).getStereotypeQualifiedName();
            }
            if (element instanceof Value) {
                return ((Value)element).getValue();
            }
            if (element instanceof PropertyRepresentation) {
                return ((PropertyRepresentation)element).getLabel();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof StereotypeRepresentation) {
                return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_STEREOTYPE);
            }
            if (element instanceof PropertyRepresentation) {
                return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_PROPERTY);
            }
            if (element instanceof Value) {
                Property property = ((Value)element).getPropertyRepresentation().getUMLProperty();
                Type type = property.getType();
                if (type != null) {
                    if (type instanceof PrimitiveType) {
                        String typeName = type.getQualifiedName();
                        if (StereotypePostAction.UMLPrimitiveTypes_BOOLEAN.equals(typeName)) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_LITERALBOOLEAN);
                        }
                        if (StereotypePostAction.UMLPrimitiveTypes_STRING.equals(typeName)) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_LITERALSTRING);
                        }
                        if (StereotypePostAction.UMLPrimitiveTypes_INTEGER.equals(typeName)) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_LITERALINTEGER);
                        }
                        if (StereotypePostAction.UMLPrimitiveTypes_REAL.equals(typeName)) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_LITERALREAL);
                        }
                        if (StereotypePostAction.UMLPrimitiveTypes_UNLIMITED_NATURAL.equals(typeName)) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_LITERALUNLIMITEDNATURAL);
                        }
                    } else {
                        if (Util.isMetaclass(type)) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_METACLASS);
                        }
                        if (type instanceof Enumeration) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_ENUMERATION);
                        }
                        if (type instanceof DataType) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_DATATYPE);
                        }
                        if (type instanceof Stereotype) {
                            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_STEREOTYPE);
                        }
                        if (type instanceof Class && !(type instanceof Stereotype)) {
                            property.isMultivalued();
                        }
                    }
                }
            } else {
                if (element instanceof Profile) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_PROFILE);
                }
                if (element instanceof Stereotype) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_STEREOTYPE);
                }
            }
            return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_UNKNOWN);
        }
    }

    protected class ProfileContentProvider
    implements ITreeContentProvider {
        protected final EClass metaclass;

        public ProfileContentProvider(EClass metaclass) {
            this.metaclass = metaclass;
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Stereotype> children = new ArrayList<Stereotype>();
            if (parentElement instanceof Profile) {
                for (Stereotype stereotype : ((Profile)parentElement).getOwnedStereotypes()) {
                    boolean isValid = false;
                    EList metaclasses = stereotype.getAllExtendedMetaclasses();
                    for (Class stMetaclass : metaclasses) {
                        EClassifier metaClassifier;
                        java.lang.Class<?> metaclassClass = stMetaclass.getClass();
                        if (metaclassClass == null || !((EClass)(metaClassifier = UMLPackage.eINSTANCE.getEClassifier(stMetaclass.getName()))).isSuperTypeOf(this.metaclass)) continue;
                        isValid = true;
                    }
                    if (!isValid) continue;
                    children.add(stereotype);
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof Profile) {
                return ((Profile)element).getOwner();
            }
            if (element instanceof Stereotype) {
                return ((Stereotype)element).getProfile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Profile;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class RuntimeEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public RuntimeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor(null, 0);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof PropertyRepresentation;
        }

        protected Object getValue(Object element) {
            if (element instanceof PropertyRepresentation) {
                return ((PropertyRepresentation)element).isRuntime();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof PropertyRepresentation) {
                ((PropertyRepresentation)element).setRuntime((Boolean)value);
                StereotypePostAction.this.stereotypesViewer.update(element, null);
            }
        }
    }

    protected class RuntimeLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        protected RuntimeLabelProvider() {
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }

        public String getText(Object element) {
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof PropertyRepresentation) {
                if (((PropertyRepresentation)element).isRuntime()) {
                    return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_CHECKED);
                }
                return Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICON_UNCHECKED);
            }
            return null;
        }
    }

    protected class RuntimePropertiesDialog
    extends Dialog {
        private String title;
        private String message;
        private TreeViewer tree;
        private List<StereotypeRepresentation> stereotypesRep;

        public RuntimePropertiesDialog(Shell parent, List<StereotypeRepresentation> steWithPropToEdit) {
            super(parent);
            this.title = null;
            this.message = null;
            this.tree = null;
            this.title = Messages.StereotypePostAction_EditRuntimePropertiesTitle;
            this.message = Messages.StereotypePostAction_EditRuntimePropertiesMessage;
            this.stereotypesRep = steWithPropToEdit;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            if (this.title != null) {
                shell.setText(this.title);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout(5, false);
            composite.setLayout((Layout)layout);
            if (this.message != null) {
                Label titleLabel = new Label(composite, 64);
                titleLabel.setText(this.message);
                GridData data = new GridData(4, 0x1000000, true, false, 1, 1);
                titleLabel.setLayoutData((Object)data);
            }
            StereotypePostAction.this.downButton = new Button(composite, 0);
            StereotypePostAction.this.downButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICONS_DOWN));
            StereotypePostAction.this.downButton.setEnabled(false);
            StereotypePostAction.this.downButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    StereotypePostAction.this.moveElement(StereotypePostAction.MOVE_DOWN, RuntimePropertiesDialog.this.tree);
                    RuntimePropertiesDialog.this.runtimeSelectionHasChange();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            StereotypePostAction.this.upButton = new Button(composite, 0);
            StereotypePostAction.this.upButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICONS_UP));
            StereotypePostAction.this.upButton.setEnabled(false);
            StereotypePostAction.this.upButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    StereotypePostAction.this.moveElement(StereotypePostAction.MOVE_UP, RuntimePropertiesDialog.this.tree);
                    RuntimePropertiesDialog.this.runtimeSelectionHasChange();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            StereotypePostAction.this.addButton = new Button(composite, 0);
            StereotypePostAction.this.addButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICONS_ADD));
            StereotypePostAction.this.addButton.setEnabled(false);
            StereotypePostAction.this.addButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    StereotypePostAction.this.performAddButtonPressed(RuntimePropertiesDialog.this.tree);
                    RuntimePropertiesDialog.this.tree.refresh();
                    RuntimePropertiesDialog.this.runtimeSelectionHasChange();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            StereotypePostAction.this.removeButton = new Button(composite, 0);
            StereotypePostAction.this.removeButton.setImage(Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", StereotypePostAction.ICONS_REMOVE));
            StereotypePostAction.this.removeButton.setEnabled(false);
            StereotypePostAction.this.removeButton.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    StereotypePostAction.this.performRemoveAction(RuntimePropertiesDialog.this.tree);
                    RuntimePropertiesDialog.this.runtimeSelectionHasChange();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            this.tree = new TreeViewer(parent, 2050);
            this.tree.setContentProvider((IContentProvider)new StereotypeContentProvider());
            this.tree.getControl().setLayoutData((Object)new GridData(768));
            this.createColumn(this.tree);
            this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    RuntimePropertiesDialog.this.performSelectionChangeRuntime(event);
                }
            });
            this.tree.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    StereotypePostAction.this.performDoubleClickAction(RuntimePropertiesDialog.this.tree);
                    RuntimePropertiesDialog.this.runtimeSelectionHasChange();
                }
            });
            this.tree.getControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x100000B) {
                        StereotypePostAction.this.performF2Action(RuntimePropertiesDialog.this.tree);
                    } else if (e.character == '\u007f') {
                        StereotypePostAction.this.performRemoveAction(RuntimePropertiesDialog.this.tree);
                    } else if (e.stateMask == 262144 && e.keyCode == 110) {
                        StereotypePostAction.this.performCTRL_N_Action(e, RuntimePropertiesDialog.this.tree);
                    }
                    RuntimePropertiesDialog.this.runtimeSelectionHasChange();
                }
            });
            this.updateTreeViewer();
            this.tree.expandAll();
            return composite;
        }

        protected void createColumn(TreeViewer viewer) {
            TreeViewerColumn stereotypeColumn = new TreeViewerColumn(viewer, 4);
            stereotypeColumn.getColumn().setResizable(true);
            stereotypeColumn.getColumn().setWidth(400);
            stereotypeColumn.setLabelProvider((CellLabelProvider)StereotypePostAction.this.editorLabelProvider);
            stereotypeColumn.setEditingSupport((EditingSupport)new AttributeEditingSupport((ColumnViewer)viewer));
        }

        private void updateTreeViewer() {
            this.tree.setInput(this.stereotypesRep);
            this.runtimeSelectionHasChange();
        }

        private void runtimeSelectionHasChange() {
            this.performSelectionChangeRuntime(new SelectionChangedEvent((ISelectionProvider)this.tree, this.tree.getSelection()));
        }

        protected void performSelectionChangeRuntime(SelectionChangedEvent event) {
            ITreeSelection selection = (ITreeSelection)event.getSelection();
            int selectionSize = selection.size();
            if (selectionSize == 0 || !StereotypePostAction.this.sameLevelForFullSelection(selection)) {
                StereotypePostAction.this.addButton.setEnabled(true);
                StereotypePostAction.this.removeButton.setEnabled(false);
                StereotypePostAction.this.upButton.setEnabled(false);
                StereotypePostAction.this.downButton.setEnabled(false);
            } else if (selectionSize == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof StereotypeRepresentation) {
                    StereotypePostAction.this.removeButton.setEnabled(false);
                } else if (selectedElement instanceof PropertyRepresentation) {
                    if (((PropertyRepresentation)selectedElement).getUpperMultiplicity() == 1) {
                        StereotypePostAction.this.removeButton.setEnabled(true);
                    } else {
                        StereotypePostAction.this.removeButton.setEnabled(false);
                    }
                } else if (selectedElement instanceof Value) {
                    StereotypePostAction.this.removeButton.setEnabled(true);
                }
                if (selectedElement instanceof StereotypeRepresentation) {
                    StereotypePostAction.this.addButton.setEnabled(false);
                } else if (selectedElement instanceof PropertyRepresentation) {
                    ArrayList<Value> values = ((PropertyRepresentation)selectedElement).getValues();
                    Property prop = ((PropertyRepresentation)selectedElement).getUMLProperty();
                    if (!prop.isMultivalued()) {
                        if (values.size() == 0) {
                            StereotypePostAction.this.addButton.setEnabled(true);
                        } else {
                            StereotypePostAction.this.addButton.setEnabled(false);
                        }
                    } else {
                        int upper = prop.getUpper();
                        if (upper == -1) {
                            StereotypePostAction.this.addButton.setEnabled(true);
                        } else if (values.size() < upper) {
                            StereotypePostAction.this.addButton.setEnabled(true);
                        } else {
                            StereotypePostAction.this.addButton.setEnabled(false);
                        }
                    }
                } else if (selectedElement instanceof Value) {
                    StereotypePostAction.this.addButton.setEnabled(false);
                }
                if (selectedElement instanceof StereotypeRepresentation) {
                    int index = this.stereotypesRep.indexOf(selectedElement);
                    if (StereotypePostAction.this.config.getStereotypesRepresentations().size() == 1) {
                        StereotypePostAction.this.downButton.setEnabled(false);
                        StereotypePostAction.this.upButton.setEnabled(false);
                    } else if (index == 0) {
                        StereotypePostAction.this.downButton.setEnabled(true);
                        StereotypePostAction.this.upButton.setEnabled(false);
                    } else if (index == this.stereotypesRep.indexOf(selectedElement) - 1) {
                        StereotypePostAction.this.downButton.setEnabled(false);
                        StereotypePostAction.this.upButton.setEnabled(true);
                    } else {
                        StereotypePostAction.this.downButton.setEnabled(true);
                        StereotypePostAction.this.upButton.setEnabled(true);
                    }
                } else if (selectedElement instanceof PropertyRepresentation) {
                    StereotypePostAction.this.downButton.setEnabled(false);
                    StereotypePostAction.this.upButton.setEnabled(false);
                } else if (selectedElement instanceof Value) {
                    ArrayList<Value> valuesList = ((Value)selectedElement).getPropertyRepresentation().getValues();
                    int index = valuesList.indexOf(selectedElement);
                    if (valuesList.size() == 1) {
                        StereotypePostAction.this.upButton.setEnabled(false);
                        StereotypePostAction.this.downButton.setEnabled(false);
                    } else if (index == 0) {
                        StereotypePostAction.this.upButton.setEnabled(false);
                        StereotypePostAction.this.downButton.setEnabled(true);
                    } else if (index == valuesList.size() - 1) {
                        StereotypePostAction.this.upButton.setEnabled(true);
                        StereotypePostAction.this.downButton.setEnabled(false);
                    } else {
                        StereotypePostAction.this.upButton.setEnabled(true);
                        StereotypePostAction.this.downButton.setEnabled(true);
                    }
                }
            } else if (selection.getFirstElement() instanceof StereotypeRepresentation) {
                StereotypePostAction.this.removeButton.setEnabled(true);
                StereotypePostAction.this.upButton.setEnabled(false);
                StereotypePostAction.this.downButton.setEnabled(false);
                StereotypePostAction.this.addButton.setEnabled(true);
            } else if (selection.getFirstElement() instanceof Value) {
                StereotypePostAction.this.removeButton.setEnabled(true);
                StereotypePostAction.this.upButton.setEnabled(false);
                StereotypePostAction.this.downButton.setEnabled(false);
                StereotypePostAction.this.addButton.setEnabled(false);
            }
        }
    }

    protected class StereotypeContentProvider
    implements ITreeContentProvider {
        protected StereotypeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                return ((List)parentElement).toArray();
            }
            if (parentElement instanceof StereotypeRepresentation) {
                return ((StereotypeRepresentation)parentElement).getPropertyRepresentations().toArray();
            }
            if (parentElement instanceof PropertyRepresentation && ((PropertyRepresentation)parentElement).getUpperMultiplicity() != 1 && ((PropertyRepresentation)parentElement).getValues().size() != 0) {
                return ((PropertyRepresentation)parentElement).getValues().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Value) {
                return ((Value)element).getPropertyRepresentation();
            }
            if (element instanceof PropertyRepresentation) {
                return ((PropertyRepresentation)element).getStereotypeRepresentation();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null && this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

