/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.IStereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.StereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayCommandExecution;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeMigrationHelper;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeLabelMigrationCommand
implements Runnable {
    private static final String EANNOTATION_LIST_SEPARATOR = ",";
    private static final String QUALIFIED_NAME_DEPTH = "full";
    private View mainView;
    private static StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    private static StereotypeMigrationHelper migrationHelper = StereotypeMigrationHelper.getInstance();
    private static StereotypeDisplayCommandExecution commandHelper = StereotypeDisplayCommandExecution.getInstance();
    private IStereotypeViewProvider provider;

    public StereotypeLabelMigrationCommand(String label, View content) {
        this.mainView = content;
    }

    protected void migrateStereotypeLabel(View view) {
        this.setProvider(view);
        if (migrationHelper.hasStereotypeEAnnotation(view)) {
            String oldStereotype = this.getOldStereotypeToDisplay(view);
            this.updateNewStereotypeVisibility(view, oldStereotype);
            String oldQNStereotype = this.getOldQNStereotypeToDisplay(view);
            this.updateNewStereotypeDepth(view, oldQNStereotype);
        }
    }

    protected void updateNewStereotypeDepth(View view, String stereotypeList) {
        StringTokenizer tokenizer = new StringTokenizer(stereotypeList, EANNOTATION_LIST_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String stereotypeName = tokenizer.nextToken();
            DecorationNode label = helper.getStereotypeLabel(view, stereotypeName);
            if (label == null) continue;
            commandHelper.setDepth(migrationHelper.getDomain((EObject)view), migrationHelper.getStereotypeFromString(view, stereotypeName), view, QUALIFIED_NAME_DEPTH, false);
        }
    }

    protected void updateNewStereotypeVisibility(View view, String stereotypeList) {
        this.hideStereotypeLabelNotDisplayed(stereotypeList, view);
    }

    private void showStereotypeLabelToBeDisplayed(String stereotypeList, View view) {
        StringTokenizer tokenizer = new StringTokenizer(stereotypeList, EANNOTATION_LIST_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String stereotypeName = tokenizer.nextToken();
            this.showStereotypeLabel(view, stereotypeName);
        }
    }

    protected void showStereotypeLabel(View view, String stereotypeName) {
        View label = this.provider.getLabel(migrationHelper.getStereotypeFromString(view, stereotypeName));
        if (label != null) {
            migrationHelper.updateVisibilityAndPersistence(label, (EObject)view, true);
        }
    }

    private void hideStereotypeLabelNotDisplayed(String stereotypeList, View view) {
        EList<Stereotype> appliedStereotypes = migrationHelper.getAppliedStereotypesFromView(view);
        Iterator stereotypes = appliedStereotypes.iterator();
        while (stereotypes.hasNext()) {
            String stereotypeName = ((Stereotype)stereotypes.next()).getQualifiedName();
            if (stereotypeList.indexOf(stereotypeName) != -1) continue;
            this.hideStereotypeLabel(view, stereotypeName);
        }
    }

    private void hideStereotypeLabel(View view, String stereotypeName) {
        View label = this.provider.getLabel(migrationHelper.getStereotypeFromString(view, stereotypeName));
        migrationHelper.updateVisibilityAndPersistence(label, (EObject)this.mainView, false);
    }

    protected String getOldQNStereotypeToDisplay(View view) {
        return migrationHelper.getStereotypesQNToDisplay((EModelElement)view);
    }

    protected String getOldStereotypeToDisplay(View view) {
        return migrationHelper.getStereotypesToDisplay((EModelElement)view);
    }

    private void setProvider(View view) {
        this.provider = new StereotypeViewProvider(view);
    }

    @Override
    public void run() {
        this.migrateStereotypeLabel(this.mainView);
    }
}

