/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.CallBehaviorActionEditPart;
import org.eclipse.papyrus.uml.diagram.interactionoverview.Activator;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.commands.CreateSnapshotForInteractionFromRefreshCommand;
import org.eclipse.papyrus.uml.diagram.interactionoverview.figures.InteractionWithSnapshotFigure;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.CallBehaviorUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.CallBehaviorAction;

public class CallBehaviorActionAsInteractionEditPart
extends CallBehaviorActionEditPart {
    public static final int INTERACTION_VISUAL_ID = 5000;
    private boolean isRefreshingSnapshotFigure;

    public CallBehaviorActionAsInteractionEditPart(View view) {
        super(view);
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new InteractionWithSnapshotFigure();
        return this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void refreshChildren() {
        super.refreshChildren();
        if (this.resolveSemanticElement() instanceof CallBehaviorAction) {
            CallBehaviorAction action = (CallBehaviorAction)this.resolveSemanticElement();
            if (action.getBehavior() instanceof Activity) {
                this.getPrimaryShape().displayRake(true);
            } else {
                this.getPrimaryShape().displayRake(false);
            }
        }
    }

    public Command getCommand(Request _request) {
        if (_request instanceof ChangeBoundsRequest) {
            final ChangeBoundsRequest request = (ChangeBoundsRequest)_request;
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.add((Command)new RefreshCommandForUndo((org.eclipse.gef.GraphicalEditPart)this));
            compoundCommand.add(new Command(){

                public void execute() {
                    Rectangle newBound = request.getTransformedRectangle(CallBehaviorActionAsInteractionEditPart.this.primaryShape.getBounds());
                    ((InteractionWithSnapshotFigure)CallBehaviorActionAsInteractionEditPart.this.primaryShape).updateSnapshot(new Rectangle(newBound.x, newBound.y, newBound.width, newBound.height - 15));
                }
            });
            compoundCommand.add(super.getCommand((Request)request));
            return compoundCommand;
        }
        return super.getCommand(_request);
    }

    public void refresh() {
        super.refresh();
        if (((InteractionWithSnapshotFigure)this.primaryShape).getImageFigure() != null && this.isValidFromRefresh() && !this.isRefreshingSnapshotFigure) {
            this.isRefreshingSnapshotFigure = true;
            try {
                if (((InteractionWithSnapshotFigure)this.primaryShape).getImageFigure().getImage() == null) {
                    try {
                        CreateSnapshotForInteractionFromRefreshCommand command = CreateSnapshotForInteractionFromRefreshCommand.create((View)this.getModel(), (GraphicalEditPart)this.getParent());
                        try {
                            GMFUnsafe.write((TransactionalEditingDomain)this.getEditingDomain(), (ICommand)command);
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                if (!((InteractionWithSnapshotFigure)this.primaryShape).isImageSizeFitsImageFigure()) {
                    Rectangle bounds = new Rectangle(0, 0, this.primaryShape.getBounds().width, this.primaryShape.getBounds().height - 15);
                    ((InteractionWithSnapshotFigure)this.primaryShape).updateSnapshot(bounds);
                }
            }
            finally {
                this.isRefreshingSnapshotFigure = false;
            }
        }
    }

    private boolean isValidFromRefresh() {
        View callBehaviorActionView = (View)this.getModel();
        return CallBehaviorUtil.getDiagramLinked(callBehaviorActionView) != null && !CallBehaviorUtil.getDiagramLinked(callBehaviorActionView).equals("");
    }
}

