/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;

public class CustomStateMachineResizeCommand
extends AbstractTransactionalCommand {
    CreateViewRequest.ViewDescriptor viewDescriptor;
    IAdaptable adaptable;
    PreferencesHint prefHints;
    private ChangeBoundsRequest request = null;
    private Rectangle bounds = null;
    private boolean internalResize = false;

    public CustomStateMachineResizeCommand(IAdaptable adaptable, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, ChangeBoundsRequest request, Rectangle bounds, boolean internalResize) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.prefHints = prefHints;
        this.request = request;
        this.bounds = bounds;
        this.internalResize = internalResize;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View stateMachine = (View)this.adaptable.getAdapter(View.class);
        View stateMachineLabel = (View)stateMachine.getChildren().get(0);
        View stateMachineCompartment = (View)stateMachine.getChildren().get(1);
        int direction = this.request.getResizeDirection();
        int dx = this.request.getSizeDelta().width;
        int dy = this.request.getSizeDelta().height;
        int newX = this.bounds.x;
        int newY = this.bounds.y;
        if (this.internalResize) {
            Zone.setHeight(stateMachineLabel, Zone.getHeight(stateMachineLabel) + dy);
        }
        Zone.setX(stateMachine, newX);
        Zone.setY(stateMachine, newY);
        Zone.setWidth(stateMachine, Zone.getWidth(stateMachine) + dx);
        Zone.setHeight(stateMachine, Zone.getHeight(stateMachine) + dy);
        Zone.setWidth(stateMachineLabel, Zone.getWidth(stateMachine));
        Zone.setWidth(stateMachineCompartment, Zone.getWidth(stateMachine));
        Zone.setHeight(stateMachineCompartment, Zone.getHeight(stateMachine) - Zone.getHeight(stateMachineLabel));
        Zone.setY(stateMachineCompartment, Zone.getHeight(stateMachineLabel));
        if (this.internalResize && dx == 0) {
            return CommandResult.newOKCommandResult();
        }
        if (stateMachineCompartment.getChildren().size() == 1) {
            View defaultRegion = (View)stateMachineCompartment.getChildren().get(0);
            Zone.setWidth(defaultRegion, Zone.getWidth(stateMachineCompartment));
            Zone.setHeight(defaultRegion, Zone.getHeight(stateMachineCompartment));
            return CommandResult.newOKCommandResult();
        }
        block10: for (View view : stateMachineCompartment.getChildren()) {
            String zone = Zone.getZone(view);
            switch (direction) {
                case 8: {
                    int width;
                    if (!Zone.hasLeftNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        break;
                    }
                    int x2 = Zone.getX(view);
                    Zone.setX(view, x2 += dx);
                    break;
                }
                case 16: {
                    if (Zone.hasRightNeighbours(zone)) break;
                    int width = Zone.getWidth(view);
                    Zone.setWidth(view, width += dx);
                    break;
                }
                case 1: {
                    int height2;
                    if (!Zone.hasTopNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        break;
                    }
                    int y2 = Zone.getY(view);
                    Zone.setY(view, y2 += dy);
                    break;
                }
                case 4: {
                    if (Zone.hasBottomNeighbours(zone)) break;
                    int height2 = Zone.getHeight(view);
                    Zone.setHeight(view, height2 += dy);
                    break;
                }
                case 9: {
                    int x;
                    int y;
                    int height;
                    int height2;
                    int width;
                    if (!Zone.hasLeftNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasLeftNeighbours(zone) && Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        y = Zone.getY(view);
                        Zone.setY(view, y += dy);
                        break;
                    }
                    if (Zone.hasLeftNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        x = Zone.getX(view);
                        Zone.setX(view, x += dx);
                        break;
                    }
                    int x2 = Zone.getX(view);
                    Zone.setX(view, x2 += dx);
                    y = Zone.getY(view);
                    Zone.setY(view, y += dy);
                    break;
                }
                case 17: {
                    int y;
                    int height;
                    int height2;
                    int width;
                    if (!Zone.hasRightNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasRightNeighbours(zone) && Zone.hasTopNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        y = Zone.getY(view);
                        Zone.setY(view, y += dy);
                        break;
                    }
                    if (Zone.hasRightNeighbours(zone) && !Zone.hasTopNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        break;
                    }
                    int y2 = Zone.getY(view);
                    Zone.setY(view, y2 += dy);
                    break;
                }
                case 12: {
                    int x;
                    int height;
                    int height2;
                    int width;
                    if (!Zone.hasLeftNeighbours(zone) && !Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasLeftNeighbours(zone) && Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        break;
                    }
                    if (Zone.hasLeftNeighbours(zone) && !Zone.hasBottomNeighbours(zone)) {
                        height2 = Zone.getHeight(view);
                        Zone.setHeight(view, height2 += dy);
                        x = Zone.getX(view);
                        Zone.setX(view, x += dx);
                        break;
                    }
                    int x2 = Zone.getX(view);
                    Zone.setX(view, x2 += dx);
                    break;
                }
                case 20: {
                    int height;
                    int width;
                    if (!Zone.hasRightNeighbours(zone) && !Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        height = Zone.getHeight(view);
                        Zone.setHeight(view, height += dy);
                        break;
                    }
                    if (!Zone.hasRightNeighbours(zone) && Zone.hasBottomNeighbours(zone)) {
                        width = Zone.getWidth(view);
                        Zone.setWidth(view, width += dx);
                        break;
                    }
                    if (!Zone.hasRightNeighbours(zone) || Zone.hasBottomNeighbours(zone)) continue block10;
                    int height2 = Zone.getHeight(view);
                    Zone.setHeight(view, height2 += dy);
                }
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

