/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.codegen.base;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.codegen.base.IPFileSystemAccess;

public class ProjectBasedFileAccess
implements IPFileSystemAccess {
    IProject project;
    String subFolderName;
    boolean force = true;

    public ProjectBasedFileAccess(IProject project) {
        this.project = project;
        this.subFolderName = null;
    }

    public ProjectBasedFileAccess(IProject project, String subFolderName) {
        this.project = project;
        this.subFolderName = subFolderName;
    }

    @Override
    public void generateFile(String fileName, String content) {
        IFile file = this.getFile(fileName);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
        try {
            if (file.exists()) {
                if (this.force) {
                    file.setContents((InputStream)contentStream, true, false, null);
                }
            } else {
                file.create((InputStream)contentStream, true, null);
            }
            file.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new RuntimeException("Code generation: " + e.getMessage());
        }
    }

    @Override
    public void deleteFile(String fileName) {
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setProject(IProject project, String subFolderName) {
        this.project = project;
        this.subFolderName = subFolderName;
    }

    public IFile getFile(String filename) {
        String[] paths = filename.split("/");
        IContainer packageContainer = this.getFolder((IContainer)this.project, this.subFolderName);
        try {
            int i = 0;
            while (i < paths.length - 1) {
                String path = paths[i];
                if (!(packageContainer = this.getFolder(packageContainer, path)).exists()) {
                    ((IFolder)packageContainer).create(false, true, null);
                }
                ++i;
            }
            String last = paths[paths.length - 1];
            return this.getFile(packageContainer, last);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IContainer getFolder(IContainer container, String folderName) {
        if (folderName == null) {
            return container;
        }
        if (container instanceof IFolder) {
            return ((IFolder)container).getFolder(folderName);
        }
        if (container instanceof IProject) {
            return ((IProject)container).getFolder(folderName);
        }
        return null;
    }

    public IFile getFile(IContainer container, String fileName) {
        if (container instanceof IFolder) {
            return ((IFolder)container).getFile(fileName);
        }
        if (container instanceof IProject) {
            return ((IProject)container).getFile(fileName);
        }
        return null;
    }
}

