/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.codegen.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.codegen.extensionpoints.ILangSupport;
import org.eclipse.papyrus.codegen.extensionpoints.LanguageSupport;
import org.eclipse.papyrus.cpp.codegen.utils.LocateCppProject;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class CDTprojectHandler
extends CmdHandler {
    private static final String LANGUAGE_NAME = "C++";

    public boolean isEnabled() {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Package || this.selectedEObject instanceof Classifier) {
            URI uri = this.selectedEObject.eResource().getURI();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (uri.segmentCount() < 2) {
                return false;
            }
            IProject modelProject = root.getProject(uri.segment(1));
            return modelProject.exists();
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof PackageableElement) {
            PackageableElement pe = (PackageableElement)this.selectedEObject;
            IProject modelProject = LocateCppProject.getTargetProject((PackageableElement)pe, (boolean)true);
            if (modelProject == null) {
                return null;
            }
            ILangSupport langSupport = LanguageSupport.getLangSupport((String)LANGUAGE_NAME);
            if (langSupport != null) {
                langSupport.resetConfigurationData();
                langSupport.setSettings(null);
            } else {
                return null;
            }
        }
        return null;
    }
}

