/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cpp.codegen.utils;

import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.codegen.extensionpoints.ILangSupport;
import org.eclipse.papyrus.codegen.extensionpoints.LanguageSupport;
import org.eclipse.papyrus.cpp.codegen.Activator;
import org.eclipse.papyrus.cpp.codegen.utils.Messages;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class LocateCppProject {
    public static final String LANGUAGE_NAME = "C++";
    private static final boolean Headless = Boolean.getBoolean("papyrus.run-headless");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        IProject modelProject;
        block13: {
            IPreferenceStore store;
            String prefix;
            String projectName;
            Package rootPkg = PackageUtil.getRootPackage((Element)pe);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            modelProject = root.getProject(projectName = String.valueOf(prefix = (store = Activator.getDefault().getPreferenceStore()) != null ? store.getString("projectPrefix") : "bad preferences.") + rootPkg.getName());
            if (!modelProject.exists()) {
                if (Headless) {
                    try {
                        modelProject.create(null);
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                } else {
                    if (!createIfMissing) return null;
                    if (!LocateCppProject.openQuestion(Messages.LocateCppProject_CreateTargetProjectTitle, String.format(Messages.LocateCppProject_CreateTargetProjectDesc, projectName))) return null;
                    boolean bl = true;
                    boolean create = bl;
                    if (!create) return null;
                    ILangSupport langSupport = LanguageSupport.getLangSupport((String)LANGUAGE_NAME);
                    if (langSupport == null) return null;
                    langSupport.resetConfigurationData();
                    modelProject = langSupport.createProject(projectName, null);
                    if (modelProject == null) {
                        return null;
                    }
                }
            }
            if (!modelProject.isOpen()) {
                try {
                    modelProject.open(null);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            if (modelProject.hasNature("org.eclipse.cdt.core.ccnature")) return modelProject;
            if (!createIfMissing) return null;
            if (!Headless) {
                if (!LocateCppProject.openQuestion(Messages.LocateCppProject_ApplyCNatureTitle, Messages.LocateCppProject_ApplyCNatureDesc)) return null;
            }
            boolean bl = true;
            boolean apply = bl;
            if (apply) break block13;
            return null;
        }
        try {
            CProjectNature.addCNature((IProject)modelProject, null);
            CCProjectNature.addCCNature((IProject)modelProject, null);
            return modelProject;
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return modelProject;
    }

    private static boolean openQuestion(final String title, final String message) {
        final boolean[] ret = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ret[0] = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
        return ret[0];
    }
}

