/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class SynchJDTCommentable
implements JDTVisitor {
    protected abstract BodyDeclaration searchElementToInsert(CompilationUnit var1, IJavaElement var2);

    protected abstract List<String> getJavadocTags();

    private static CompilationUnit parse(ICompilationUnit unit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setKind(8);
        parser.setSource(unit);
        parser.setResolveBindings(true);
        return (CompilationUnit)parser.createAST(null);
    }

    protected <U extends IJavaElement> void createJavaDocFor(U ielement, ICompilationUnit icu, String comment, String author) throws JavaModelException, MalformedTreeException, BadLocationException {
        BodyDeclaration classType;
        CompilationUnit cu = SynchJDTCommentable.parse(icu);
        cu.recordModifications();
        Document document = new Document(icu.getBuffer().getContents());
        AST ast = cu.getAST();
        Javadoc jc = ast.newJavadoc();
        TagElement tag = ast.newTagElement();
        if (comment != null) {
            TextElement te = ast.newTextElement();
            tag.fragments().add(te);
            te.setText(comment);
        }
        jc.tags().add(tag);
        List<String> javadocTags = this.getJavadocTags();
        if (javadocTags != null) {
            for (String s : javadocTags) {
                tag = ast.newTagElement();
                tag.setTagName(s);
                jc.tags().add(tag);
            }
        }
        if ((classType = this.searchElementToInsert(cu, ielement)) != null) {
            classType.setJavadoc(jc);
        }
        TextEdit text = cu.rewrite((IDocument)document, icu.getJavaProject().getOptions(true));
        text.apply((IDocument)document);
        icu.getBuffer().setContents(document.get());
    }

    protected TypeDeclaration searchType(TypeDeclaration classType, String typeName) {
        if (classType.getName().toString().equals(typeName)) {
            return classType;
        }
        TypeDeclaration[] typeDeclarationArray = classType.getTypes();
        int n = typeDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration objct = typeDeclarationArray[n2];
            TypeDeclaration ct = objct;
            if (ct.getName().toString().equals(typeName)) {
                return ct;
            }
            this.searchType(ct, typeName);
            ++n2;
        }
        return null;
    }
}

