/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTCommentable;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTField;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMember;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTField
extends SynchJDTCommentable {
    private IType itype;
    private JDTField field;
    private GeneratorPreference preference;

    public SynchJDTField(IType itype, GeneratorPreference preference) {
        this.itype = itype;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        this.field = (JDTField)element;
        StringBuffer buffer = new StringBuffer();
        try {
            IField ifield = (IField)SynchTools.searchIJavaElement((IJavaElement[])this.itype.getFields(), (String)this.field.getElementName());
            if (ifield == null && this.field.getType() != null) {
                SynchTools.createImport(this.itype, this.field.getOwner(), this.field.getType());
                buffer.append("\n" + SynchTools.getVisibility((JDTMember)this.field).toString());
                if (this.field.isMultiValued()) {
                    buffer.append(SynchTools.getMultiValued(this.itype, this.field.getType().getElementName(), this.preference));
                } else {
                    buffer.append(this.field.getType().getElementName());
                }
                buffer.append(" " + this.field.getElementName());
                if (this.field.getValue() != null) {
                    buffer.append(" = ");
                    if (this.field.getType().getElementName().equals("char")) {
                        buffer.append("'" + this.field.getValue().toString() + "'");
                    } else if (this.field.getType().getElementName().equals("String")) {
                        buffer.append("\"" + this.field.getValue().toString() + "\"");
                    } else {
                        buffer.append(this.field.getValue().toString());
                    }
                }
                buffer.append(";");
                ifield = this.itype.createField(buffer.toString(), null, true, null);
                this.createJavaDocFor(ifield, ifield.getCompilationUnit(), this.field.getComment(), "");
            } else if (this.field.getType() == null) {
                System.err.println("No type specified for " + this.field.getOwner().getQualifiedName() + "." + this.field.getElementName());
            }
            this.generateExplicitImports(this.field, this.itype);
        }
        catch (JavaModelException e) {
            String msg = "Can't generate field (class='" + this.field.getOwner().getQualifiedName() + "', msg= " + e.getMessage() + ", buffer=" + buffer.toString() + ")";
            this.propagateException(msg, e);
        }
        catch (Exception e) {
            this.propagateException(e.getMessage(), e);
        }
    }

    private void propagateException(String msg, Throwable e) throws JDTVisitorException {
        if (this.preference.stopOnFirstError()) {
            throw new JDTVisitorException(msg, e.getCause());
        }
        System.err.println(msg);
        e.printStackTrace();
    }

    @Override
    protected BodyDeclaration searchElementToInsert(CompilationUnit cu, IJavaElement field) {
        if (field.getParent() instanceof IType) {
            IType itype = (IType)field.getParent();
            TypeDeclaration type = this.searchType((TypeDeclaration)cu.types().get(0), itype.getElementName());
            FieldDeclaration[] fieldDeclarationArray = type.getFields();
            int n = fieldDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration fs = fieldDeclarationArray[n2];
                if (fs.toString().contains(field.getElementName())) {
                    return fs;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    protected List<String> getJavadocTags() {
        return null;
    }

    private void generateExplicitImports(JDTField field2, IType destType) throws JDTVisitorException {
        for (Object anImport : field2.getExplicitRequiredImports()) {
            try {
                destType.getCompilationUnit().createImport(anImport.getQualifiedName(), null, null);
            }
            catch (Exception e) {
                this.propagateException(String.valueOf(destType.getFullyQualifiedName()) + "Can't add explicit import " + anImport.getQualifiedName(), e);
            }
        }
        for (Object anImport : field2.getExplicitPlainTextRequiredImports()) {
            try {
                destType.getCompilationUnit().createImport((String)anImport, null, null);
            }
            catch (JavaModelException e) {
                this.propagateException(String.valueOf(destType.getFullyQualifiedName()) + "Can't add explicit plain text import " + (String)anImport, e);
            }
        }
    }
}

