/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTPackageFragmentRoot;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaProject;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTPackageFragmentRoot;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.util.JdtmmPreference;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTJavaProject
implements JDTVisitor {
    private IJavaModel ijm;
    private IWorkspaceRoot iroot;
    private GeneratorPreference preference;

    public SynchJDTJavaProject(IJavaModel ijm, IWorkspaceRoot iroot, GeneratorPreference preference) {
        this.ijm = ijm;
        this.iroot = iroot;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        if (!(element instanceof JDTJavaProject)) {
            return;
        }
        JDTJavaProject project = (JDTJavaProject)element;
        JdtmmPreference.setClassMultiValue((String)this.preference.genericClassForMultiValue().substring(this.preference.genericClassForMultiValue().lastIndexOf(".") + 1));
        IJavaProject ijavaProjet = this.ijm.getJavaProject(project.getElementName());
        if (!ijavaProjet.exists()) {
            IProject proj;
            try {
                proj = this.iroot.getProject(project.getElementName());
                if (!proj.exists()) {
                    proj.create(null);
                    proj.open(null);
                } else if (!proj.isOpen()) {
                    proj.open(null);
                }
                IProjectDescription description = proj.getDescription();
                description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                proj.setDescription(description, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
                throw new JDTVisitorException(e.getMessage());
            }
            ijavaProjet = JavaCore.create((IProject)proj);
        }
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        boolean creerJRE = true;
        try {
            IClasspathEntry[] iClasspathEntryArray = ijavaProjet.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry elem = iClasspathEntryArray[n2];
                if (elem.getPath().toString().contains(JavaRuntime.JRE_CONTAINER)) {
                    creerJRE = false;
                }
                entries.add(elem);
                ++n2;
            }
            if (creerJRE) {
                entries.add(JavaCore.newContainerEntry((IPath)JavaRuntime.newJREContainerPath((IVMInstall)vmInstall)));
                ijavaProjet.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
        SynchJDTPackageFragmentRoot visitor = new SynchJDTPackageFragmentRoot(ijavaProjet, this.preference);
        for (JDTPackageFragmentRoot root : project.getPackageFragmentRoots()) {
            root.accept((JDTVisitor)visitor);
        }
    }
}

