/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchJDTPackageFragment;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.impl.SynchTools;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTJavaElement;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTPackageFragment;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTPackageFragmentRoot;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitor;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.visitor.JDTVisitorException;

public class SynchJDTPackageFragmentRoot
implements JDTVisitor {
    private IJavaProject iprojet;
    private GeneratorPreference preference;

    public SynchJDTPackageFragmentRoot(IJavaProject iprojet, GeneratorPreference preference) {
        this.iprojet = iprojet;
        this.preference = preference;
    }

    public void visit(JDTJavaElement element) throws JDTVisitorException {
        if (!element.isGenerated()) {
            return;
        }
        JDTPackageFragmentRoot root = (JDTPackageFragmentRoot)element;
        try {
            IPackageFragmentRoot iroot = (IPackageFragmentRoot)SynchTools.searchIJavaElement((IJavaElement[])this.iprojet.getAllPackageFragmentRoots(), (String)root.getElementName());
            if (iroot == null) {
                IFolder sourceFolder = this.iprojet.getProject().getFolder(root.getElementName());
                try {
                    sourceFolder.create(false, true, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                iroot = this.iprojet.getPackageFragmentRoot((IResource)sourceFolder);
                IClasspathEntry[] oldEntries = this.iprojet.getRawClasspath();
                ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                int i = 0;
                while (i < oldEntries.length) {
                    if (oldEntries[i] != null && !oldEntries[i].getPath().toString().equals("/" + this.iprojet.getElementName())) {
                        newEntries.add(oldEntries[i]);
                    }
                    ++i;
                }
                newEntries.add(JavaCore.newSourceEntry((IPath)iroot.getPath()));
                IClasspathEntry[] newEntriesArray = new IClasspathEntry[newEntries.size()];
                newEntries.toArray(newEntriesArray);
                this.iprojet.setRawClasspath(newEntriesArray, null);
            }
            SynchJDTPackageFragment visitPackageFragment = new SynchJDTPackageFragment(iroot, this.preference);
            for (JDTPackageFragment ipack : root.getPackageFragments()) {
                ipack.accept((JDTVisitor)visitPackageFragment);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new JDTVisitorException(e.getMessage(), e.getCause());
        }
    }
}

