/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.jdtsynchronizer.impl;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.java.generator.jdtsynchronizer.GeneratorPreference;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTMember;
import org.eclipse.papyrus.java.generator.metamodel.jdt.jdtmm.JDTType;

public class SynchTools {
    public static <U extends IJavaElement> U searchIJavaElement(U[] lstElement, String elementName) {
        U[] UArray = lstElement;
        int n = lstElement.length;
        int n2 = 0;
        while (n2 < n) {
            U e = UArray[n2];
            if (e.getElementName().equals(elementName)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static String getVisibility(JDTMember jdtMember) {
        StringBuffer buffer = new StringBuffer();
        if (Flags.isPublic((int)jdtMember.getFlags())) {
            buffer.append("public ");
        }
        if (Flags.isPrivate((int)jdtMember.getFlags())) {
            buffer.append("private ");
        }
        if (Flags.isProtected((int)jdtMember.getFlags())) {
            buffer.append("protected ");
        }
        if (Flags.isAbstract((int)jdtMember.getFlags())) {
            buffer.append("abstract ");
        }
        if (Flags.isStatic((int)jdtMember.getFlags())) {
            buffer.append("static ");
        }
        if (Flags.isFinal((int)jdtMember.getFlags())) {
            buffer.append("final ");
        }
        if (Flags.isSynchronized((int)jdtMember.getFlags())) {
            buffer.append("synchronized ");
        }
        return buffer.toString();
    }

    public static boolean isPrimiveType(String typename) {
        if (typename.equals("byte")) {
            return true;
        }
        if (typename.equals("char")) {
            return true;
        }
        if (typename.equals("double")) {
            return true;
        }
        if (typename.equals("float")) {
            return true;
        }
        if (typename.equals("int")) {
            return true;
        }
        if (typename.equals("long")) {
            return true;
        }
        if (typename.equals("short")) {
            return true;
        }
        if (typename.equals("boolean")) {
            return true;
        }
        return typename.equals("String");
    }

    public static boolean isPureJavaPrimiveType(String typename) {
        if (typename.equals("byte")) {
            return true;
        }
        if (typename.equals("char")) {
            return true;
        }
        if (typename.equals("double")) {
            return true;
        }
        if (typename.equals("float")) {
            return true;
        }
        if (typename.equals("int")) {
            return true;
        }
        if (typename.equals("long")) {
            return true;
        }
        if (typename.equals("short")) {
            return true;
        }
        if (typename.equals("boolean")) {
            return true;
        }
        return typename.equals("String");
    }

    public static String defaultReturn(String typename) {
        if (typename.equals("byte")) {
            return "0";
        }
        if (typename.equals("char")) {
            return "0";
        }
        if (typename.equals("double")) {
            return "0";
        }
        if (typename.equals("float")) {
            return "0";
        }
        if (typename.equals("int")) {
            return "0";
        }
        if (typename.equals("long")) {
            return "0";
        }
        if (typename.equals("short")) {
            return "0";
        }
        if (typename.equals("boolean")) {
            return "false";
        }
        return "null";
    }

    private static String getPrimiveTypeClass(String typename) {
        if (typename.equals("byte")) {
            return "Byte";
        }
        if (typename.equals("char")) {
            return "Character";
        }
        if (typename.equals("double")) {
            return "Double";
        }
        if (typename.equals("float")) {
            return "Float";
        }
        if (typename.equals("int")) {
            return "Integer";
        }
        if (typename.equals("long")) {
            return "Long";
        }
        if (typename.equals("short")) {
            return "Short";
        }
        if (typename.equals("boolean")) {
            return "Boolean";
        }
        return typename;
    }

    public static String getPackageFragment(JDTType type) {
        try {
            if (type.getCompilationUnit() != null) {
                return type.getCompilationUnit().getPackageFragment().getQualifiedName();
            }
            return SynchTools.getPackageFragment(type.getOwner());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void createImport(IType itype, JDTType currentType, JDTType importType) throws JavaModelException {
        String packageCurrentType = SynchTools.getPackageFragment(currentType);
        String packageImportType = SynchTools.getPackageFragment(importType);
        if (packageImportType == null) {
            return;
        }
        if (packageCurrentType != null && importType.getCompilationUnit() != null && packageCurrentType.equals(packageImportType)) {
            return;
        }
        if (SynchTools.isPureJavaPrimiveType(importType.getElementName())) {
            return;
        }
        String _import = importType.getQualifiedName();
        if (!SynchTools.isPrimiveType(_import) && _import.contains(".")) {
            itype.getCompilationUnit().createImport(_import, null, null);
        }
    }

    public static String getMultiValued(IType type, String typeName, GeneratorPreference preference) throws JavaModelException {
        String _classQualifiedName = preference.genericClassForMultiValue();
        String _class = _classQualifiedName.substring(_classQualifiedName.lastIndexOf(".") + 1);
        type.getCompilationUnit().createImport(_classQualifiedName, null, null);
        return String.valueOf(_class) + "<" + SynchTools.getPrimiveTypeClass(typeName) + ">";
    }

    public static String getMultiValued(IType type, JDTType valueType, GeneratorPreference preference) throws JavaModelException {
        String _classQualifiedName = preference.genericClassForMultiValue();
        String _class = _classQualifiedName.substring(_classQualifiedName.lastIndexOf(".") + 1);
        type.getCompilationUnit().createImport(_classQualifiedName, null, null);
        return String.valueOf(_class) + "<" + SynchTools.getPrimiveTypeClass(valueType.getElementName()) + ">";
    }
}

