/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.generator.ui.preference;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class GenericClassFieldEditor
extends StringButtonFieldEditor {
    public GenericClassFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected String changePressed() {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        FilteredTypesSelectionDialog d = new FilteredTypesSelectionDialog(this.getShell(), false, null, scope, 0);
        d.open();
        Object[] pack = d.getResult();
        BinaryType result = (BinaryType)pack[0];
        try {
            if (!result.getClassFile().getType().getFullyQualifiedParameterizedName().contains("<") || !result.getClassFile().getType().getFullyQualifiedParameterizedName().contains(">")) {
                String errorMessage = "Erreur : " + result.getElementName() + " is not a generic class";
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)errorMessage);
                return this.getStringValue();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            String errorMessage = "Erreur : " + e.getMessage();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)errorMessage);
        }
        return String.valueOf(result.getPackageFragment().getElementName()) + "." + result.getElementName();
    }
}

