/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;

public class DisplayReverse {
    private static final String MODEL_TYPE = "2005";
    private static final String PACKAGE_TYPE = "2007";
    private static final String CU_TYPE = "2008";
    private List<IJavaElement> items;
    private Map<String, NamedElement> umlModelNames;
    private Diagram diagram;
    private Model model;

    public DisplayReverse(List<IJavaElement> items, Diagram diagram, Resource umlModel, Model model) {
        this.items = items;
        this.diagram = diagram;
        this.model = model;
        this.umlModelNames = new HashMap<String, NamedElement>();
        TreeIterator tree = umlModel.getAllContents();
        while (tree.hasNext()) {
            for (EObject o : ((EObject)tree.next()).eContents()) {
                if (!(o instanceof NamedElement)) continue;
                NamedElement e = (NamedElement)o;
                this.umlModelNames.put(e.getName(), e);
            }
        }
    }

    public void execute() throws JavaModelException {
        if (this.model != null) {
            this.display(this.model.getName(), MODEL_TYPE);
        }
        for (IJavaElement item : this.items) {
            this.scanJavaElement(item);
        }
    }

    private void scanCU(ICompilationUnit item) {
        String itemName = item.getElementName().substring(0, item.getElementName().length() - 5);
        this.display(itemName, CU_TYPE);
    }

    private void scanPackage(IPackageFragment item) throws JavaModelException {
        String itemName = item.getElementName();
        this.display(itemName, PACKAGE_TYPE);
    }

    private void scanJavaElement(IJavaElement item) throws JavaModelException {
        try {
            switch (item.getElementType()) {
                case 4: {
                    this.scanPackage((IPackageFragment)item);
                    break;
                }
                case 5: {
                    this.scanCU((ICompilationUnit)item);
                }
            }
        }
        catch (NullPointerException e) {
            System.err.println(String.valueOf(item.getElementName()) + "is NOT in selected uml model");
        }
    }

    private void display(String itemName, String type) {
        EObject item = (EObject)this.umlModelNames.get(itemName);
        if (!this.diagram.getChildren().contains((Object)item)) {
            ViewService.createNode((View)this.diagram, (EObject)item, (String)type, (PreferencesHint)new PreferencesHint("org.eclipse.papyrus.uml.diagram.clazz"));
        }
    }
}

