/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui;

import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.java.reverse.ui.DisplayReverse;
import org.eclipse.papyrus.java.reverse.ui.ReverseCodeHandler;
import org.eclipse.papyrus.java.reverse.ui.TreeSelectionList;
import org.eclipse.papyrus.java.reverse.ui.dialog.DndReverseCodeDialog;
import org.eclipse.papyrus.java.reverse.ui.dialog.ReverseCodeDialog;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;

public class DndReverseCodeHandler
extends ReverseCodeHandler {
    private boolean displayCU;
    private boolean displayPackages;
    private boolean displayModel;

    @Override
    protected void doExecute(ReverseCodeDialog dialog) {
        List<IJavaElement> listSelection;
        DndReverseCodeDialog dndDialog = (DndReverseCodeDialog)dialog;
        this.displayModel = dndDialog.displayModel();
        this.displayPackages = dndDialog.displayPackages();
        this.displayCU = dndDialog.displayCU();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        TreeSelection treeSelection = (TreeSelection)selection;
        Diagram diagram = null;
        IEditorPart activeEditor = MDTUtil.getActiveEditor();
        if (activeEditor != null && activeEditor instanceof IMultiDiagramEditor) {
            diagram = (Diagram)((IMultiDiagramEditor)activeEditor).getAdapter(Diagram.class);
        }
        try {
            listSelection = this.selectionMinusAlreadyInDiagram(treeSelection, diagram);
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
            return;
        }
        super.doExecute(dialog);
        Model model = null;
        if (this.displayModel) {
            String modelName = dndDialog.getValue();
            model = this.getModelToDisplay(diagram, modelName);
        }
        DisplayReverse displayReverse = new DisplayReverse(listSelection, diagram, this.getUmlResource(), model);
        try {
            displayReverse.execute();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected ReverseCodeDialog getDialog(Shell shell, String modelUid) {
        return new DndReverseCodeDialog(shell, modelUid, null, null);
    }

    private List<IJavaElement> selectionMinusAlreadyInDiagram(TreeSelection selection, Diagram diagram) throws JavaModelException {
        TreeSet<String> alreadyExists = new TreeSet<String>();
        EList diagramList = diagram.getChildren();
        for (ShapeImpl item : diagramList) {
            NamedElement e = (NamedElement)item.getElement();
            alreadyExists.add(e.getName());
        }
        TreeSelectionList selectionList = new TreeSelectionList(selection, this.displayPackages, this.displayCU);
        ListIterator selectionIterator = selectionList.listIterator();
        while (selectionIterator.hasNext()) {
            String selectionItemName = this.getName((IJavaElement)selectionIterator.next());
            if (selectionItemName == null || !alreadyExists.contains(selectionItemName)) continue;
            selectionIterator.remove();
        }
        return selectionList;
    }

    private String getName(IJavaElement item) {
        String name = item.getElementName();
        if (item instanceof ICompilationUnit) {
            return name.substring(0, name.length() - 5);
        }
        return name;
    }

    public Model getModel(String modelName) {
        TreeIterator tree = this.getUmlResource().getAllContents();
        while (tree.hasNext()) {
            for (EObject o : ((EObject)tree.next()).eContents()) {
                Model model;
                if (!(o instanceof Model) || !(model = (Model)o).getName().equals(modelName)) continue;
                System.out.println("model = " + model);
                return model;
            }
        }
        System.out.println("model = null");
        return null;
    }

    private Model getModelToDisplay(Diagram diagram, String modelName) {
        Model model = this.getModel(modelName);
        if (model != null && !this.isInDiagram(diagram, model)) {
            System.out.println("display model " + model);
            return model;
        }
        System.out.println("don't display model");
        return null;
    }

    private boolean isInDiagram(Diagram diagram, Model model) {
        EList diagramList = diagram.getChildren();
        for (ShapeImpl item : diagramList) {
            if (item.getElement() != model) continue;
            return true;
        }
        return false;
    }
}

