/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javagen.umlparser.CompilationUnitAnalyser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;

public class JavaCodeReverse {
    CompilationUnitAnalyser javaAnalyser;

    public JavaCodeReverse(Resource model) {
        this.javaAnalyser = new CompilationUnitAnalyser(model);
    }

    public JavaCodeReverse(Package rootPackage, String generatedPackageName, List<String> searchPaths) {
        this.javaAnalyser = new CompilationUnitAnalyser(rootPackage, generatedPackageName, searchPaths);
    }

    public void reverseResource(IResource resource) throws ParseException, CoreException {
        System.out.println("reverseResource(" + resource.getName() + ")");
        if (resource instanceof IFile) {
            this.reverseFile((IFile)resource);
        } else if (resource instanceof IFolder) {
            this.reverseFolder((IFolder)resource);
        } else if (resource instanceof IProject) {
            this.reverseProject((IProject)resource);
        }
    }

    private void reverseFolder(IFolder folder) throws CoreException, ParseException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.reverseResource(resource);
            ++n2;
        }
    }

    private void reverseProject(IProject folder) throws CoreException, ParseException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.reverseResource(resource);
            ++n2;
        }
    }

    private void reverseFile(IFile file) throws ParseException, CoreException {
        System.out.println("try to reverseFile(" + file.getName() + ")");
        if (!"java".equals(file.getFileExtension())) {
            return;
        }
        System.out.println("reverseFile(" + file.getName() + ")");
        CompilationUnit cu = JavaParser.parse((InputStream)file.getContents());
        this.javaAnalyser.processCompilationUnit(cu);
    }

    public void reverseJavaElement(IJavaElement element) throws ParseException, CoreException {
        System.out.println("reverseJavaElement(" + element.getElementName() + ")");
        if (element instanceof ITypeRoot) {
            this.reverseCompilationUnit((ITypeRoot)element);
        } else if (element instanceof IPackageFragment) {
            this.reversePackageFragment((IPackageFragment)element);
        } else if (element instanceof IPackageFragmentRoot) {
            this.reversePackageFragmentRoot((IPackageFragmentRoot)element);
        } else {
            System.err.println("Can't reverse Java Element " + element);
        }
    }

    private void reversePackageFragmentRoot(IPackageFragmentRoot element) throws ParseException, CoreException {
        IJavaElement[] children;
        System.out.println("reversePackageFragmentRoot(" + element.getElementName() + ")");
        IJavaElement[] iJavaElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            this.reverseJavaElement(child);
            ++n2;
        }
    }

    private void reversePackageFragment(IPackageFragment element) throws ParseException, CoreException {
        IJavaElement[] children;
        System.out.println("reversePackageFragment(" + element.getElementName() + ")");
        IJavaElement[] iJavaElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            this.reverseJavaElement(child);
            ++n2;
        }
    }

    private void reverseCompilationUnit(ITypeRoot unit) throws ParseException, CoreException {
        System.out.println("try to reverseUnit(" + unit.getElementName() + ")");
        System.out.println("file type=(" + unit.getElementType() + ")");
        String source = unit.getSource();
        if (source == null) {
            System.err.println("No source attached to unit '" + unit.getElementName() + "'");
            return;
        }
        CompilationUnit cu = JavaParser.parse((Reader)new StringReader(source));
        this.javaAnalyser.processCompilationUnit(cu);
    }

    public void executeCodeReverse(Resource umlResource, String generationPackageName, List<String> searchPaths) {
        System.out.println("executeCodeReverse()");
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        TreeSelection treeSelection = (TreeSelection)selection;
        for (Object obj : treeSelection) {
            ICompilationUnit u;
            if (obj instanceof ICompilationUnit) {
                u = (ICompilationUnit)obj;
                try {
                    obj = u.getCorrespondingResource();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            if (obj instanceof IPackageFragment) {
                u = (IPackageFragment)obj;
                try {
                    IResource res = u.getCorrespondingResource();
                    if (res != null) {
                        obj = res;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            if (obj instanceof IJavaElement) {
                u = (IJavaElement)obj;
                try {
                    this.reverseJavaElement((IJavaElement)u);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(obj instanceof IResource)) continue;
            try {
                this.reverseResource((IResource)obj);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        System.out.println("reverse done");
    }
}

