/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.papyrus.java.reverse.ui.Activator;
import org.eclipse.papyrus.java.reverse.ui.dialog.ReverseCodeDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DndReverseCodeDialog
extends ReverseCodeDialog {
    private static final String DISPLAY_MODEL_UID = ":DISPLAY_MODEL";
    private static final String DISPLAY_PACKAGES_UID = ":DISPLAY_PACKAGES";
    private static final String DISPLAY_CU_UID = ":DISPLAY_CU";
    private Button displayModelCheckbox;
    private Button displayPackagesCheckbox;
    private Button displayCUCheckbox;
    private boolean displayModel;
    private boolean displayPackages;
    private boolean displayCU;

    public DndReverseCodeDialog(Shell parentShell, String modelUid, String initialValue, List<String> searchPathsInitialValues) {
        super(parentShell, modelUid, initialValue, searchPathsInitialValues);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.displayModelCheckbox = new Button(composite, 32);
        this.displayModelCheckbox.setText("Display reversed Model into diagram");
        this.displayModelCheckbox.setSelection(settings.getBoolean(String.valueOf(this.MODEL_UID) + DISPLAY_MODEL_UID));
        this.displayPackagesCheckbox = new Button(composite, 32);
        this.displayPackagesCheckbox.setText("Display reversed UML::packages into diagram");
        this.displayPackagesCheckbox.setSelection(settings.getBoolean(String.valueOf(this.MODEL_UID) + DISPLAY_PACKAGES_UID));
        this.displayCUCheckbox = new Button(composite, 32);
        this.displayCUCheckbox.setText("Display UML::classes, UML::interfaces, UML::enumerations into diagram");
        this.displayCUCheckbox.setSelection(settings.getBoolean(String.valueOf(this.MODEL_UID) + DISPLAY_CU_UID));
        return composite;
    }

    @Override
    protected void okPressed() {
        this.displayModel = this.displayModelCheckbox.getSelection();
        this.displayPackages = this.displayPackagesCheckbox.getSelection();
        this.displayCU = this.displayCUCheckbox.getSelection();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put(String.valueOf(this.MODEL_UID) + DISPLAY_MODEL_UID, this.displayModel);
        settings.put(String.valueOf(this.MODEL_UID) + DISPLAY_PACKAGES_UID, this.displayPackages);
        settings.put(String.valueOf(this.MODEL_UID) + DISPLAY_CU_UID, this.displayCU);
        super.okPressed();
    }

    public boolean displayModel() {
        return this.displayModel;
    }

    public boolean displayPackages() {
        return this.displayPackages;
    }

    public boolean displayCU() {
        return this.displayCU;
    }
}

