/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.java.reverse.ui.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javagen.umlparser.CreationPackageCatalog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.java.reverse.ui.Activator;
import org.eclipse.papyrus.java.reverse.ui.dialog.InputListDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ReverseCodeDialog
extends InputDialog {
    private InputListDialog listDialog;
    private InputListDialog creationPathsDialog;
    private String[] searchPath;
    private String[] creationPaths;
    private List<String> splittedCreationPaths;
    private String SEARCHPATHS_UID = ":searchpaths";
    private String CREATIONPATHS_UID = ":creationpaths";
    private static String DEFAULT_PACKAGE_NAME_UID = ":defaultpackagename";
    protected String MODEL_UID = "nomodeluid";
    private static String textMsg = "Default creation package.";
    private static String creationPackageTooltips = "The default creation package is used when no matching creation package are found.";
    private static String dialogTitle = "Reverse Code";
    private static String listMsg = "search paths  - list of model packages used to search for already existing classes (ex: p1/p2)";
    private static String listTooltips = "search paths  - list of model packages used to search for already existing classes (ex: p1/p2)";
    private static String creationPathMsg = "creation paths \npattern: includePath ; excludePath ; destination (use ';' as separator)\n";
    private static String creationPathTooltips = "creation paths  - list of path describing the models inside which reversed classes will be generated.\npattern: includeJavaPackage ; excludeJavaPackage ; destinationPath (use ';' as separator)\nincludeJavaPackage: the java package that should be mapped. Can contain a '*'.\nexcludeJavaPackage: the java package that should be excluded. Can contain a '*'.\ndestinationPath: the uml model inside which matching java packages will be created. Can contain a '*'.\nif destinationPath contains a '*', it will be replaced by the partname found at the place of '*'\nin the includeJavaPackage\n\nex: eclipse.org.* ; eclipse.org.papyrus ; *";

    public ReverseCodeDialog(Shell parentShell, String modelUid, String initialValue, List<String> searchPathsInitialValues) {
        super(parentShell, dialogTitle, textMsg, ReverseCodeDialog.getInitialValue(modelUid, initialValue), null);
        String[] savedSearchPath;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.MODEL_UID = modelUid;
        if (searchPathsInitialValues == null) {
            savedSearchPath = settings.getArray(String.valueOf(this.MODEL_UID) + this.SEARCHPATHS_UID);
            searchPathsInitialValues = savedSearchPath != null ? Arrays.asList(savedSearchPath) : CreationPackageCatalog.getDefaultSearchPath();
        }
        if (this.creationPaths == null) {
            savedSearchPath = settings.getArray(String.valueOf(this.MODEL_UID) + this.CREATIONPATHS_UID);
            this.creationPaths = savedSearchPath != null ? savedSearchPath : CreationPackageCatalog.getDefaultPackageCreationPatterns((String)" ; ");
        }
        this.listDialog = new InputListDialog(listMsg, searchPathsInitialValues);
        this.listDialog.setTooltips(listTooltips);
        this.creationPathsDialog = new InputListDialog(creationPathMsg, Arrays.asList(this.creationPaths));
        this.creationPathsDialog.setTooltips(creationPathTooltips);
    }

    private static String getInitialValue(String modelUid, String initialValue) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (initialValue == null) {
            String generationPackageName = settings.get(String.valueOf(modelUid) + DEFAULT_PACKAGE_NAME_UID);
            return generationPackageName;
        }
        return initialValue;
    }

    protected boolean isResizable() {
        return true;
    }

    public String[] getSearchPath() {
        return this.searchPath;
    }

    public List<String> getCreationPaths() {
        return this.splittedCreationPaths;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.listDialog.createDialogArea(composite);
        this.creationPathsDialog.createDialogArea(composite);
        return composite;
    }

    protected void okPressed() {
        this.searchPath = this.listDialog.getList();
        this.creationPaths = this.creationPathsDialog.getList();
        String defaultCreationPath = this.getValue();
        if (defaultCreationPath == null || defaultCreationPath.length() == 0) {
            defaultCreationPath = CreationPackageCatalog.getDefaultCreationPath();
        }
        try {
            this.splittedCreationPaths = this.computeCreationPaths(this.creationPaths);
            CreationPackageCatalog.validateCreationPath(this.splittedCreationPaths);
            this.searchPath = this.addDefaultSearchPaths(Arrays.asList(this.searchPath), this.splittedCreationPaths).toArray(new String[0]);
        }
        catch (Exception e) {
            this.showError(e.getMessage());
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put(String.valueOf(this.MODEL_UID) + this.SEARCHPATHS_UID, this.searchPath);
        settings.put(String.valueOf(this.MODEL_UID) + this.CREATIONPATHS_UID, this.creationPaths);
        settings.put(String.valueOf(this.MODEL_UID) + DEFAULT_PACKAGE_NAME_UID, this.getValue());
        super.okPressed();
    }

    private List<String> addDefaultSearchPaths(List<String> searchPath, List<String> splittedCreationPaths) {
        ArrayList<String> result = new ArrayList<String>(searchPath.size() + splittedCreationPaths.size());
        result.addAll(searchPath);
        List additionalPaths = CreationPackageCatalog.extractCreationPaths((String[])splittedCreationPaths.toArray(new String[0]));
        for (String toAdd : additionalPaths) {
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    private void showError(String message) {
        System.err.println("Error: " + message);
    }

    private List<String> computeCreationPaths(String[] creationPaths) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = creationPaths;
        int n = creationPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] eles = line.split(";");
            if (eles.length != 3) {
                throw new Exception("A line must contains 3 pattern separated by ';' :" + line);
            }
            String[] stringArray2 = eles;
            int n3 = eles.length;
            int n4 = 0;
            while (n4 < n3) {
                String ele = stringArray2[n4];
                if ((ele = ele.trim()).length() == 0) {
                    ele = null;
                }
                result.add(ele);
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

