/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.visitor;

import japa.parser.ast.BlockComment;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.LineComment;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EmptyMemberDeclaration;
import japa.parser.ast.body.EmptyTypeDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.InitializerDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.ModifierSet;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.CharLiteralExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.EnclosedExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.IntegerLiteralMinValueExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.LongLiteralMinValueExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.SuperExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.AssertStmt;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.BreakStmt;
import japa.parser.ast.stmt.CatchClause;
import japa.parser.ast.stmt.ContinueStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.EmptyStmt;
import japa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.LabeledStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.SynchronizedStmt;
import japa.parser.ast.stmt.ThrowStmt;
import japa.parser.ast.stmt.TryStmt;
import japa.parser.ast.stmt.TypeDeclarationStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.Iterator;
import java.util.List;

public final class DumpVisitor
implements VoidVisitor<Object> {
    private final SourcePrinter printer = new SourcePrinter();

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("protected ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("synchronized ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("volatile ");
        }
    }

    private void printMembers(List<BodyDeclaration> members, Object arg) {
        for (BodyDeclaration member : members) {
            this.printer.printLn();
            member.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.print(" ");
            }
        }
    }

    private void printTypeArgs(List<Type> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<Type> i = args.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(List<TypeParameter> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(List<Expression> args, Object arg) {
        this.printer.print("(");
        if (args != null) {
            Iterator<Expression> i = args.iterator();
            while (i.hasNext()) {
                Expression e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadoc, Object arg) {
        if (javadoc != null) {
            javadoc.accept(this, arg);
        }
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        if (n.getPakage() != null) {
            n.getPakage().accept(this, arg);
        }
        if (n.getImports() != null) {
            for (ImportDeclaration importDeclaration : n.getImports()) {
                importDeclaration.accept(this, arg);
            }
            this.printer.printLn();
        }
        if (n.getTypes() != null) {
            Iterator<TypeDeclaration> iterator = n.getTypes().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this, arg);
                this.printer.printLn();
                if (!iterator.hasNext()) continue;
                this.printer.printLn();
            }
        }
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.printLn(";");
        this.printer.printLn();
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.printer.print(n.getName());
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
    }

    @Override
    public void visit(ImportDeclaration n, Object arg) {
        this.printer.print("import ");
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getName().accept(this, arg);
        if (n.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.printLn(";");
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        ClassOrInterfaceType c;
        Iterator<ClassOrInterfaceType> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(n.getName());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            i = n.getExtends().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print(n.getName());
        this.printTypeArgs(n.getTypeArgs(), arg);
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.printer.print(n.getName());
        if (n.getTypeBound() != null) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i = n.getTypeBound().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ReferenceType n, Object arg) {
        n.getType().accept(this, arg);
        int i = 0;
        while (i < n.getArrayCount()) {
            this.printer.print("[]");
            ++i;
        }
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.printer.print("?");
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            n.getExtends().accept(this, arg);
        }
        if (n.getSuper() != null) {
            this.printer.print(" super ");
            n.getSuper().accept(this, arg);
        }
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            var.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        n.getId().accept(this, arg);
        if (n.getInit() != null) {
            this.printer.print(" = ");
            n.getInit().accept(this, arg);
        }
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.printer.print(n.getName());
        int i = 0;
        while (i < n.getArrayCount()) {
            this.printer.print("[]");
            ++i;
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        this.printer.print("{");
        if (n.getValues() != null) {
            this.printer.print(" ");
            Iterator<Expression> i = n.getValues().iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        this.printer.print("new ");
        n.getType().accept(this, arg);
        if (n.getDimensions() != null) {
            for (Expression dim : n.getDimensions()) {
                this.printer.print("[");
                dim.accept(this, arg);
                this.printer.print("]");
            }
            int i = 0;
            while (i < n.getArrayCount()) {
                this.printer.print("[]");
                ++i;
            }
        } else {
            int i = 0;
            while (i < n.getArrayCount()) {
                this.printer.print("[]");
                ++i;
            }
            this.printer.print(" ");
            n.getInitializer().accept(this, arg);
        }
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        this.printer.print("(");
        n.getType().accept(this, arg);
        this.printer.print(") ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        n.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        n.getCondition().accept(this, arg);
        this.printer.print(" ? ");
        n.getThenExpr().accept(this, arg);
        this.printer.print(" : ");
        n.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.printer.print("(");
        n.getInner().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        n.getExpr().accept(this, arg);
        this.printer.print(" instanceof ");
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        this.printer.print(String.valueOf(n.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("new ");
        this.printTypeArgs(n.getTypeArgs(), arg);
        n.getType().accept(this, arg);
        this.printArguments(n.getArgs(), arg);
        if (n.getAnonymousClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getAnonymousClassBody(), arg);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
            }
        }
        n.getExpr().accept(this, arg);
        switch (n.getOperator()) {
            case posIncrement: {
                this.printer.print("++");
                break;
            }
            case posDecrement: {
                this.printer.print("--");
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = (NameExpr)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        int i = 0;
        while (i < n.getArrayCount()) {
            this.printer.print("[]");
            ++i;
        }
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            Iterator<NameExpr> i2 = n.getThrows().iterator();
            while (i2.hasNext()) {
                NameExpr name = i2.next();
                name.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getBody() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        if (n.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        if (n.isThis()) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("this");
        } else {
            if (n.getExpr() != null) {
                n.getExpr().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVars().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            v.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        n.getTypeDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        if (n.getMessage() != null) {
            this.printer.print(" : ");
            n.getMessage().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        this.printer.printLn("{");
        if (n.getStmts() != null) {
            this.printer.indent();
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        n.getExpression().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        this.printer.print("switch(");
        n.getSelector().accept(this, arg);
        this.printer.printLn(") {");
        if (n.getEntries() != null) {
            this.printer.indent();
            for (SwitchEntryStmt e : n.getEntries()) {
                e.accept(this, arg);
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        if (n.getLabel() != null) {
            this.printer.print("case ");
            n.getLabel().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.printer.print("break");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.printer.print("return");
        if (n.getExpr() != null) {
            this.printer.print(" ");
            n.getExpr().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("enum ");
        this.printer.print(n.getName());
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getEntries() != null) {
            this.printer.printLn();
            i = n.getEntries().iterator();
            while (i.hasNext()) {
                EnumConstantDeclaration e = (EnumConstantDeclaration)i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getMembers() != null) {
            this.printer.printLn(";");
            this.printMembers(n.getMembers(), arg);
        } else if (n.getEntries() != null) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print(n.getName());
        if (n.getArgs() != null) {
            this.printArguments(n.getArgs(), arg);
        }
        if (n.getClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getClassBody(), arg);
            this.printer.unindent();
            this.printer.printLn("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.printer.print("if (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getThenStmt().accept(this, arg);
        if (n.getElseStmt() != null) {
            this.printer.print(" else ");
            n.getElseStmt().accept(this, arg);
        }
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.printer.print("while (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.printer.print("continue");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.printer.print("do ");
        n.getBody().accept(this, arg);
        this.printer.print(" while (");
        n.getCondition().accept(this, arg);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.printer.print("for (");
        n.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n.getIterable().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        Iterator<Expression> i;
        this.printer.print("for (");
        if (n.getInit() != null) {
            i = n.getInit().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (n.getCompare() != null) {
            n.getCompare().accept(this, arg);
        }
        this.printer.print("; ");
        if (n.getUpdate() != null) {
            i = n.getUpdate().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.printer.print("throw ");
        n.getExpr().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.printer.print("synchronized (");
        n.getExpr().accept(this, arg);
        this.printer.print(") ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.printer.print("try ");
        n.getTryBlock().accept(this, arg);
        if (n.getCatchs() != null) {
            for (CatchClause c : n.getCatchs()) {
                c.accept(this, arg);
            }
        }
        if (n.getFinallyBlock() != null) {
            this.printer.print(" finally ");
            n.getFinallyBlock().accept(this, arg);
        }
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.printer.print(" catch (");
        n.getExcept().accept(this, arg);
        this.printer.print(") ");
        n.getCatchBlock().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(n.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        if (n.getDefaultValue() != null) {
            this.printer.print(" default ");
            n.getDefaultValue().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.printer.print("@");
        n.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        if (n.getPairs() != null) {
            Iterator<MemberValuePair> i = n.getPairs().iterator();
            while (i.hasNext()) {
                MemberValuePair m = i.next();
                m.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
        this.printer.print("//");
        this.printer.printLn(n.getContent());
    }

    @Override
    public void visit(BlockComment n, Object arg) {
        this.printer.print("/*");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(Node n, Object arg) {
        throw new IllegalStateException(n.getClass().getName());
    }

    private class SourcePrinter {
        private int level = 0;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        private SourcePrinter() {
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            int i = 0;
            while (i < this.level) {
                this.buf.append("    ");
                ++i;
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(arg);
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.buf.append("\n");
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

