/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.configmodel.layersconfig.impl;

import org.eclipse.papyrus.layers.configmodel.layersconfig.ClassnameKind;
import org.eclipse.papyrus.layers.configmodel.layersconfig.LayersconfigFactory;
import org.eclipse.papyrus.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.layers.stackmodel.InstanciationException;
import org.eclipse.papyrus.layers.stackmodel.layers.CustomPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.DefaultPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.operators.BooleanAndOperator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OperatorConfigImplTest {
    protected String BUNDLE_ID = "org.eclipse.papyrus.layers.stackmodel";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testOperatorConfigImpl() {
        OperatorConfig opConfig = LayersconfigFactory.eINSTANCE.createOperatorConfig();
        Assert.assertNotNull((String)"instance created", (Object)opConfig);
    }

    @Test
    public void testCreatePojoInstance() throws InstanciationException {
        OperatorConfig opConfig = LayersconfigFactory.eINSTANCE.createOperatorConfig();
        opConfig.setClassname(BooleanAndOperator.class.getName());
        opConfig.setBundleID(this.BUNDLE_ID);
        PropertyOperator operator = opConfig.createOperatorDescriptor();
        Assert.assertNotNull((String)"operator created", (Object)operator);
        Assert.assertTrue((String)"operator type", (boolean)(operator instanceof CustomPropertyOperator));
        Assert.assertNotNull((String)"operator nested instance created", (Object)((CustomPropertyOperator)operator).getOperatorInstance());
        Assert.assertSame((String)"classnameKind is changed", (Object)((Object)ClassnameKind.POJO_CLASSNAME), (Object)((Object)opConfig.getClassnameKind()));
        operator = opConfig.createOperatorDescriptor();
        Assert.assertNotNull((String)"operator created", (Object)operator);
        Assert.assertTrue((String)"operator type", (boolean)(operator instanceof CustomPropertyOperator));
        Assert.assertNotNull((String)"operator nested instance created", (Object)((CustomPropertyOperator)operator).getOperatorInstance());
    }

    @Test
    public void testCreateEmfInstance() throws InstanciationException {
        OperatorConfig opConfig = LayersconfigFactory.eINSTANCE.createOperatorConfig();
        opConfig.setClassname(LayersPackage.eINSTANCE.getDefaultPropertyOperator().getName());
        PropertyOperator operator = opConfig.createOperatorDescriptor();
        Assert.assertNotNull((String)"operator created", (Object)operator);
        Assert.assertTrue((String)"operator type", (boolean)(operator instanceof DefaultPropertyOperator));
        Assert.assertSame((String)"classnameKind is changed", (Object)((Object)ClassnameKind.EMF_CLASSNAME), (Object)((Object)opConfig.getClassnameKind()));
        operator = opConfig.createOperatorDescriptor();
        Assert.assertNotNull((String)"operator created", (Object)operator);
        Assert.assertTrue((String)"operator type", (boolean)(operator instanceof DefaultPropertyOperator));
    }
}

