/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.papyrus.layers.stackmodel.NotFoundException;
import org.eclipse.papyrus.layers.stackmodel.layers.AbstractLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.DefaultPropertyOperator;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersPackage;
import org.eclipse.papyrus.layers.stackmodel.layers.Property;
import org.eclipse.papyrus.layers.stackmodel.layers.PropertyOperator;

public class LayerOperatorDescriptorImpl
extends MinimalEObjectImpl.Container
implements LayerOperatorDescriptor {
    protected EList<PropertyOperator> propertyOperators;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;

    protected LayerOperatorDescriptorImpl() {
    }

    protected EClass eStaticClass() {
        return LayersPackage.Literals.LAYER_OPERATOR_DESCRIPTOR;
    }

    @Override
    public EList<PropertyOperator> getPropertyOperators() {
        if (this.propertyOperators == null) {
            this.propertyOperators = new EObjectResolvingEList<PropertyOperator>(PropertyOperator.class, (InternalEObject)this, 0){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.propertyOperators;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public PropertyOperator getPropertyOperator(Property property) throws NotFoundException {
        try {
            return (PropertyOperator)this.getPropertyOperators().get(property.getIndex());
        }
        catch (IndexOutOfBoundsException e) {
            throw new NotFoundException("Can't find operator for property '" + property.getName() + "' at index " + property.getIndex());
        }
    }

    @Override
    public void setPropertyOperator(Property property, PropertyOperator operator) {
        this.getPropertyOperators().set(property.getIndex(), (Object)operator);
    }

    @Override
    public AbstractLayerOperator createLayerOperator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPropertyCollectionSize(int size, DefaultPropertyOperator defaultPropertyOperator) {
        EList<PropertyOperator> operators = this.getPropertyOperators();
        int actualSize = operators.size();
        if (actualSize >= size) {
            return;
        }
        int i = actualSize;
        while (i < size) {
            operators.add(defaultPropertyOperator);
            ++i;
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPropertyOperators();
            }
            case 1: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getPropertyOperators().clear();
                this.getPropertyOperators().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getPropertyOperators().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.propertyOperators != null && !this.propertyOperators.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                try {
                    return this.getPropertyOperator((Property)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 1: {
                this.setPropertyOperator((Property)arguments.get(0), (PropertyOperator)arguments.get(1));
                return null;
            }
            case 2: {
                return this.createLayerOperator();
            }
            case 3: {
                this.setPropertyCollectionSize((Integer)arguments.get(0), (DefaultPropertyOperator)arguments.get(1));
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

