/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layers.stackmodel.notifier;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.layers.stackmodel.layers.Layer;
import org.eclipse.papyrus.layers.stackmodel.layers.LayerExpression;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersFactory;
import org.eclipse.papyrus.layers.stackmodel.layers.LayersStack;
import org.eclipse.papyrus.layers.stackmodel.layers.StackedLayerOperator;
import org.eclipse.papyrus.layers.stackmodel.notifier.LayersTreeEventNotifier;
import org.eclipse.papyrus.layers.stackmodel.notifier.LayersTreeEventNotifierFactory;
import org.eclipse.papyrus.layers.stackmodel.notifier.TraceLayersModelEventListener;
import org.eclipse.papyrus.layers.stackmodel.util.TriggeredEventTraces;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LayersTreeEventNotifierTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLayersTreeEventNotifier() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        Assert.assertNotNull((String)"notifier created", (Object)((Object)notifier));
    }

    @Test
    @Ignore
    public void testActivate() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    @Ignore
    public void testDeactivate() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testDispose() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers(layerOp1);
        Assert.assertFalse((String)"notifier disposed", (boolean)notifier.isDisposed());
        notifier.dispose();
        Assert.assertTrue((String)"notifier disposed", (boolean)notifier.isDisposed());
    }

    @Test
    public void testAddLayersModelEventListener() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        Assert.assertNotNull((String)"notifier created", (Object)((Object)notifier));
        Assert.assertTrue((String)"listener added to internal list", (boolean)notifier.listeners.contains(listener));
    }

    @Test
    public void testRemoveLayersModelEventListener() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        Assert.assertTrue((String)"listener added to internal list", (boolean)notifier.listeners.contains(listener));
        notifier.removeLayersModelEventListener(listener);
        Assert.assertFalse((String)"listener removed from internal list", (boolean)notifier.listeners.contains(listener));
    }

    @Test
    public void testFireLayerAdded() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        System.err.println("setLayers(layerOp1)");
        layersStack.setLayers(layerOp1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        System.err.println("layerOp1.getLayers().add(layer1)");
        layerOp1.getLayers().add((Object)layer1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerAdded"));
        Assert.assertEquals((String)"one event recorded", (long)2L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerAdded", (Object)traces.traces.get((int)1).name);
    }

    @Test
    public void testFireLayerRemoved() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers(layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        layerOp1.getLayers().remove((Object)layer1);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerRemoved"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerRemoved", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireLayerSetForRootLayer() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers(layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        layersStack.setLayers(null);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireEventWhenRootLayerIsReplaced() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers(layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layersStack.setLayers(layer2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireEventWhenLayerIsReplaced() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers(layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        traces.clear();
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().set(0, (Object)layer2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerSet"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerSet", (Object)traces.traces.get((int)0).name);
    }

    @Test
    public void testFireLayerMoved() {
        LayersStack layersStack = LayersFactory.eINSTANCE.createLayersStack();
        LayersTreeEventNotifier notifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)layersStack);
        TraceLayersModelEventListener listener = new TraceLayersModelEventListener();
        notifier.addLayersModelEventListener(listener);
        TriggeredEventTraces<Notification> traces = listener.traces;
        StackedLayerOperator layerOp1 = LayersFactory.eINSTANCE.createStackedLayerOperator();
        layersStack.setLayers(layerOp1);
        Layer layer1 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer1);
        Layer layer2 = LayersFactory.eINSTANCE.createLayer();
        layerOp1.getLayers().add((Object)layer2);
        traces.clear();
        EList<LayerExpression> list = layerOp1.getLayers();
        list.move(0, (Object)layer2);
        Assert.assertTrue((String)"event recorded", (boolean)traces.contains("layerMoved"));
        Assert.assertEquals((String)"one event recorded", (long)1L, (long)traces.traces.size());
        Assert.assertEquals((String)"one event recorded", (Object)"layerMoved", (Object)traces.traces.get((int)0).name);
    }
}

