/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.robotml.deployment.Log;
import org.eclipse.papyrus.robotml.deployment.RunnableWithResult;

public class CommandSupport {
    public static void exec(String label, Runnable command) {
        ServiceUtilsForActionHandlers serviceUtils = ServiceUtilsForActionHandlers.getInstance();
        try {
            CommandSupport.exec(serviceUtils.getTransactionalEditingDomain(), label, command);
        }
        catch (ServiceException e) {
            Log.log(1, 256, "Can not get editing domain");
        }
    }

    public static void exec(String label, final RunnableWithResult command) {
        ServiceUtilsForActionHandlers serviceUtils = ServiceUtilsForActionHandlers.getInstance();
        IOperationHistory history = OperationHistoryFactory.getOperationHistory();
        try {
            history.execute((IUndoableOperation)new AbstractTransactionalCommand(serviceUtils.getTransactionalEditingDomain(), label, Collections.EMPTY_LIST){

                public CommandResult doExecuteWithResult(IProgressMonitor dummy, IAdaptable info) {
                    return command.run();
                }
            }, null, null);
        }
        catch (ExecutionException e) {
            Log.log(1, 256, "error during command execution");
        }
        catch (ServiceException e) {
            Log.log(1, 256, "Can not get editing domain");
        }
    }

    public static void exec(TransactionalEditingDomain domain, String label, final Runnable command) {
        if (domain == null) {
            command.run();
        } else {
            IOperationHistory history = OperationHistoryFactory.getOperationHistory();
            try {
                history.execute((IUndoableOperation)new AbstractTransactionalCommand(domain, label, Collections.EMPTY_LIST){

                    public CommandResult doExecuteWithResult(IProgressMonitor dummy, IAdaptable info) {
                        command.run();
                        return CommandResult.newOKCommandResult();
                    }
                }, null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

