/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment.dialog;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.robotml.deployment.DepCreation;
import org.eclipse.papyrus.robotml.deployment.DepPlanSync;
import org.eclipse.papyrus.robotml.deployment.DepPlanUtils;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.DialogUtils;
import org.eclipse.papyrus.robotml.deployment.Utils;
import org.eclipse.papyrus.robotml.deployment.dialog.AttributeLabelProvider;
import org.eclipse.papyrus.robotml.deployment.dialog.Description;
import org.eclipse.papyrus.robotml.deployment.dialog.InstanceLabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConfigureInstanceDialog
extends SelectionStatusDialog {
    protected Class m_component;
    protected Label fDescriptionLabel;
    protected Text fDescription;
    protected TreeViewer fInstanceList;
    protected TableViewer fPropertyList;
    protected Property m_currentAttribute;
    protected final String valueLabelPrefix = "Value:";
    protected Label fValueLabel;
    protected Text fValue;
    protected Package m_model;
    protected Feature m_feature;
    protected EList<Package> visitedPackages;
    protected boolean m_rulePropertiesOnly;
    protected InstanceSpecification m_instance;
    EList<InstanceSpecification> m_instanceList;

    public ConfigureInstanceDialog(Shell parent) {
        super(parent);
    }

    public boolean init(Class component) {
        DepPlanSync.syncAllDepPlans((Element)component);
        this.m_component = component;
        this.m_instance = null;
        this.m_feature = null;
        this.m_model = Utils.getUserModel();
        return this.checkAndGetInstances();
    }

    public boolean init(InstanceSpecification instance) {
        DepPlanSync.syncDepPlan(instance.getNearestPackage());
        this.m_component = DepUtils.getImplementation(instance);
        this.m_instance = instance;
        this.m_feature = null;
        this.m_model = Utils.getUserModel();
        return this.checkAndGetInstances();
    }

    public boolean init(Feature feature) {
        Type type;
        this.m_feature = feature;
        this.m_model = Utils.getUserModel();
        this.m_instance = null;
        if (feature instanceof Property && (type = ((Property)feature).getType()) instanceof Class) {
            this.m_component = (Class)type;
            return this.checkAndGetInstances();
        }
        return false;
    }

    public boolean checkAndGetInstances() {
        this.visitedPackages = new BasicEList();
        this.m_instanceList = new BasicEList();
        this.getInstances(this.m_instanceList);
        if (this.m_instanceList.size() == 0) {
            Shell shell = new Shell();
            if (DepPlanUtils.getAllDepPlans((Element)this.m_model).size() == 0) {
                MessageDialog.openInformation((Shell)shell, (String)"Instance configuration", (String)"No deployment plans are defined. Create a deployment plan before configuring instances");
                return false;
            }
            if (MessageDialog.openConfirm((Shell)shell, (String)"Instance configuration", (String)"The list of available instances is empty. Synchronize deployment plans?")) {
                DepPlanSync.syncAllDepPlans((Element)this.m_model);
                this.visitedPackages = new BasicEList();
                this.getInstances(this.m_instanceList);
                if (this.m_instanceList.size() == 0) {
                    MessageDialog.openInformation((Shell)shell, (String)"Instance configuration", (String)"There are still no instances available\nCheck whether you created already a deployment plan for your system.Check as well, if the parts in your a composite use \"composite\" as aggregation kind\n.(Results of deployment plan synchronizations will be unrolled)");
                    return false;
                }
            }
        }
        return true;
    }

    protected void computeResult() {
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createInstanceSelectionGroup(contents);
        this.createInstanceConfigurationGroup(contents);
        return contents;
    }

    protected void createInstanceSelectionGroup(Composite parent) {
        int index;
        Composite instanceSelection = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, true);
        GridData groupGridData = new GridData();
        groupGridData.grabExcessVerticalSpace = true;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalAlignment = 4;
        groupGridData.verticalAlignment = 4;
        instanceSelection.setLayout((Layout)grid);
        instanceSelection.setLayoutData((Object)groupGridData);
        Group instanceSelGroup = new Group(instanceSelection, 2048);
        instanceSelGroup.setText(" associated instance specifications ");
        instanceSelGroup.setLayout((Layout)new GridLayout(1, false));
        instanceSelGroup.setLayoutData((Object)groupGridData);
        this.fInstanceList = new TreeViewer((Composite)instanceSelGroup, 2048);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 350;
        this.fInstanceList.getTree().setLayoutData((Object)data);
        this.fInstanceList.setLabelProvider((IBaseLabelProvider)new InstanceLabelProvider());
        this.fInstanceList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof InstanceSpecification) {
                    return DepUtils.getContainedInstances((InstanceSpecification)parentElement).toArray();
                }
                return new Object[0];
            }
        });
        this.fInstanceList.setInput((Object)this.m_instanceList.toArray());
        this.fInstanceList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = ConfigureInstanceDialog.this.fInstanceList.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof InstanceSpecification) {
                    ConfigureInstanceDialog.this.m_instance = (InstanceSpecification)selected[0];
                    Classifier cl = DepUtils.getClassifier(ConfigureInstanceDialog.this.m_instance);
                    ConfigureInstanceDialog.this.fPropertyList.setInput((Object)ConfigureInstanceDialog.this.getConfigAttributes(cl).toArray());
                    ConfigureInstanceDialog.this.selectProperty(ConfigureInstanceDialog.this.m_currentAttribute);
                }
            }
        });
        if (this.m_instance != null && (index = this.m_instanceList.indexOf((Object)this.m_instance)) != -1) {
            TreeItem treeItem = this.fInstanceList.getTree().getItem(index);
            this.fInstanceList.getTree().setSelection(treeItem);
        }
    }

    protected void createInstanceConfigurationGroup(Composite parent) {
        GridData groupGridData = DialogUtils.createFillGridData();
        Group instanceConfigurationGroup = new Group(parent, 2048);
        instanceConfigurationGroup.setText(" Configuration ");
        instanceConfigurationGroup.setLayout((Layout)new RowLayout(512));
        instanceConfigurationGroup.setLayout((Layout)new GridLayout(1, false));
        instanceConfigurationGroup.setLayoutData((Object)groupGridData);
        Label configL = new Label((Composite)instanceConfigurationGroup, 0);
        configL.setText("Available properties:");
        this.fPropertyList = new TableViewer((Composite)instanceConfigurationGroup, 2048);
        this.fPropertyList.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.fPropertyList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fPropertyList.setInput((Object)this.getConfigAttributes((Classifier)this.m_component).toArray());
        this.fPropertyList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = ConfigureInstanceDialog.this.fPropertyList.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof Property) {
                    ConfigureInstanceDialog.this.selectProperty((Property)selected[0]);
                }
            }
        });
        this.fValueLabel = new Label((Composite)instanceConfigurationGroup, 0);
        GridData span2 = new GridData();
        span2.horizontalAlignment = 4;
        span2.grabExcessHorizontalSpace = true;
        span2.heightHint = 70;
        this.fPropertyList.getTable().setLayoutData((Object)span2);
        this.fValue = new Text((Composite)instanceConfigurationGroup, 64);
        span2 = new GridData();
        span2.horizontalAlignment = 4;
        span2.grabExcessHorizontalSpace = true;
        this.fValue.setLayoutData((Object)span2);
        this.fValue.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String valueStr = ConfigureInstanceDialog.this.fValue.getText();
                Slot valueSlot = null;
                if (ConfigureInstanceDialog.this.m_instance == null) {
                    return;
                }
                for (Slot slot : ConfigureInstanceDialog.this.m_instance.getSlots()) {
                    if (slot.getDefiningFeature() != ConfigureInstanceDialog.this.m_currentAttribute) continue;
                    valueSlot = slot;
                }
                if (valueSlot == null) {
                    valueSlot = DepCreation.createSlotForConfigProp(ConfigureInstanceDialog.this.m_instance, ConfigureInstanceDialog.this.m_currentAttribute);
                }
                for (ValueSpecification value : valueSlot.getValues()) {
                    if (value instanceof LiteralString) {
                        ((LiteralString)value).setValue(valueStr);
                        continue;
                    }
                    if (value instanceof LiteralInteger) {
                        ((LiteralInteger)value).setValue(Integer.parseInt(valueStr));
                        continue;
                    }
                    if (!(value instanceof LiteralBoolean)) continue;
                    ((LiteralBoolean)value).setValue(Boolean.parseBoolean(valueStr));
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.fDescriptionLabel = new Label((Composite)instanceConfigurationGroup, 0);
        this.fDescriptionLabel.setText("Description:");
        this.fDescriptionLabel.setLayoutData((Object)span2);
        span2 = new GridData();
        span2.horizontalAlignment = 4;
        span2.grabExcessHorizontalSpace = true;
        span2.grabExcessVerticalSpace = true;
        span2.verticalAlignment = 4;
        span2.heightHint = 80;
        this.fDescription = new Text((Composite)instanceConfigurationGroup, 584);
        this.fDescription.setLayoutData((Object)span2);
        instanceConfigurationGroup.pack();
        this.setEnabled(false);
    }

    protected void selectProperty(Property attribute) {
        this.m_currentAttribute = attribute;
        if (attribute == null || this.fValue == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        this.fDescription.setText(Description.getDescription((Element)attribute, "not available"));
        this.fValueLabel.setText(this.getValueLabel(attribute));
        for (Slot slot : this.m_instance.getSlots()) {
            if (slot.getDefiningFeature() != this.m_currentAttribute) continue;
            for (ValueSpecification value : slot.getValues()) {
                if (value instanceof LiteralInteger) {
                    Integer intVal = ((LiteralInteger)value).getValue();
                    this.fValue.setText(intVal.toString());
                    return;
                }
                if (value instanceof LiteralBoolean) {
                    Boolean boolVal = ((LiteralBoolean)value).booleanValue();
                    this.fValue.setText(boolVal.toString());
                    return;
                }
                if (!(value instanceof LiteralString)) continue;
                this.fValue.setText(((LiteralString)value).getValue());
                return;
            }
        }
        this.fValue.setText("");
    }

    private void setEnabled(boolean enabled) {
        this.fDescriptionLabel.setEnabled(enabled);
        this.fDescription.setEnabled(enabled);
        this.fValueLabel.setEnabled(enabled);
        this.fValue.setEnabled(enabled);
        if (!enabled) {
            this.fValue.setText("");
            this.fDescription.setText("");
            this.fValueLabel.setText("Value:");
        }
    }

    private String getValueLabel(Property attribute) {
        String label = "Value:";
        if (attribute.getDefault() != null) {
            return String.valueOf(label) + " (Default = " + attribute.getDefault() + ")";
        }
        return label;
    }

    void getInstances(EList<InstanceSpecification> instanceList) {
        Package deploymentPlans = Utils.getRoot((Element)this.m_model, "DeploymentPlans");
        String featureCandidateName = null;
        for (PackageableElement deploymentPlan : deploymentPlans.getPackagedElements()) {
            if (!(deploymentPlan instanceof Package)) continue;
            for (PackageableElement instance : ((Package)deploymentPlan).getPackagedElements()) {
                if (!(instance instanceof InstanceSpecification)) continue;
                InstanceSpecification candidate = (InstanceSpecification)instance;
                if (this.m_feature instanceof Property) {
                    for (Slot slot : candidate.getSlots()) {
                        if (slot.getDefiningFeature() != this.m_feature) continue;
                        instanceList.add((Object)DepUtils.getInstance(slot));
                    }
                    continue;
                }
                if (this.m_feature instanceof Connector) {
                    Element owner = this.m_feature.getOwner();
                    if (DepUtils.getImplementation(candidate) == owner) {
                        featureCandidateName = String.valueOf(candidate.getName()) + "." + this.m_feature.getName();
                        continue;
                    }
                    if (featureCandidateName == null || !featureCandidateName.equals(candidate.getName())) continue;
                    instanceList.add((Object)candidate);
                    continue;
                }
                if (DepUtils.getImplementation(candidate) != this.m_component) continue;
                instanceList.add((Object)candidate);
            }
        }
    }

    private EList<Property> getConfigAttributes(Classifier component) {
        BasicEList list = new BasicEList();
        return list;
    }
}

