/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.robotml.deployment.CommandSupport;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.RunnableWithResult;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.papyrus.robotml.deployment.dialog.AllocationDialog;
import org.eclipse.papyrus.robotml.deployment.handlers.CmdHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class AllocateHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        EObject selectedObj = this.getSelectedEObject();
        if (selectedObj instanceof Package) {
            return StUtils.isApplied((Element)((Package)selectedObj), DeploymentPlan.class);
        }
        return false;
    }

    @Override
    public Object execute(ExecutionEvent event) {
        if (!(this.getSelectedEObject() instanceof Package)) {
            return null;
        }
        final Package cdp = (Package)this.getSelectedEObject();
        final Shell shell = new Shell();
        if (DepUtils.getMainInstance(cdp) == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)"Deployment plan has no main instance (check stereotype attribute mainInstance)");
            return null;
        }
        CommandSupport.exec("Instance allocation", new RunnableWithResult(){

            @Override
            public CommandResult run() {
                AllocationDialog allocDialog = new AllocationDialog(shell, cdp);
                allocDialog.setTitle("Allocate instances");
                allocDialog.open();
                if (allocDialog.getReturnCode() == 0) {
                    return CommandResult.newOKCommandResult();
                }
                return CommandResult.newCancelledCommandResult();
            }
        });
        return null;
    }
}

