/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.validation.constraints;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.robotml.validation.constraints.ConstraintsUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class VerifyAlphanumericNamedElement
extends AbstractModelConstraint {
    public static Pattern ALPHANUMERIC = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");

    public boolean checkAlphaNumeric(String s) {
        if (s == null) {
            return false;
        }
        Matcher m = ALPHANUMERIC.matcher(s);
        return m.matches();
    }

    public IStatus validate(IValidationContext ctx) {
        NamedElement element = (NamedElement)ctx.getTarget();
        if (ConstraintsUtil.verifyRobotMLApplied((Element)element).booleanValue() && (element instanceof Classifier || element instanceof Property || element instanceof DataType) && !this.checkAlphaNumeric(element.getName())) {
            return ctx.createFailureStatus(new Object[]{"Element should have an alphanumeric name beginning by a letter" + element.getQualifiedName()});
        }
        return ctx.createSuccessStatus();
    }
}

