/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.export.util.InstalledProfileURI;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.PluginExportOperation;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.build.RuntimeInstallJob;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PluginExportUtil {
    protected static final int MAX_RETRY = 3;
    private static final String SrcFolderName = "src";

    public IProject createPlugin(IProgressMonitor progressMonitor, final String pluginName, String executionEnvironment, String pluginVersion, String provider) {
        PluginFieldData fPluginData = new PluginFieldData();
        fPluginData.setProvider(provider);
        fPluginData.setId(pluginName);
        fPluginData.setName(pluginName);
        fPluginData.setSourceFolderName(SrcFolderName);
        fPluginData.setVersion(pluginVersion);
        fPluginData.setWorkingSets(null);
        fPluginData.setClassname(String.valueOf(pluginName) + ".Activator");
        fPluginData.setDoGenerateClass(true);
        fPluginData.setExecutionEnvironment(executionEnvironment);
        fPluginData.setOSGiFramework(null);
        fPluginData.setHasBundleStructure(true);
        fPluginData.setUIPlugin(true);
        fPluginData.setLegacy(false);
        fPluginData.setLibraryName(null);
        fPluginData.setOutputFolderName("bin");
        fPluginData.setRCPApplicationPlugin(false);
        fPluginData.setEnableAPITooling(false);
        fPluginData.setSimple(false);
        fPluginData.setTargetVersion("3.7");
        IWorkingSet[] workingSets = new IWorkingSet[]{};
        fPluginData.setWorkingSets(workingSets);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject project = root.getProject(pluginName);
        IProjectProvider fProjectProvider = new IProjectProvider(){

            public String getProjectName() {
                return pluginName;
            }

            public IProject getProject() {
                return project;
            }

            public IPath getLocationPath() {
                return ResourcesPlugin.getWorkspace().getRoot().getLocation();
            }
        };
        NewProjectCreationOperation op = new NewProjectCreationOperation((IFieldData)fPluginData, fProjectProvider, null);
        try {
            op.run(progressMonitor);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return project;
    }

    public boolean exportProfilePlugin(Shell shell, Object object, String installationDirectory, List<InstalledProfileURI> installedProfilesUri) {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return false;
        }
        if (!this.performPreliminaryChecks(shell, object)) {
            return false;
        }
        this.scheduleExportJob(object, installationDirectory, installedProfilesUri);
        return true;
    }

    protected void scheduleExportJob(Object object, String installationDirectory, final List<InstalledProfileURI> installedProfilesUri) {
        Object[] obj = new Object[]{object};
        final FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = true;
        info.useJarFormat = true;
        info.exportSource = true;
        info.exportSourceBundle = false;
        info.allowBinaryCycles = true;
        info.useWorkspaceCompiledClasses = false;
        info.destinationDirectory = installationDirectory;
        info.zipFileName = null;
        info.items = obj;
        info.signingInfo = null;
        info.qualifier = null;
        boolean installAfterExport = true;
        RuntimeInstallJob.modifyInfoForInstall((FeatureExportInfo)info);
        final PluginExportOperation job = new PluginExportOperation(info, PDEUIMessages.PluginExportJob_name);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PLUGIN_OBJ);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (job.hasAntErrors()) {
                    final File logLocation = new File(info.destinationDirectory, "logs.zip");
                    if (logLocation.exists()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ExportErrorDialog dialog = new ExportErrorDialog(logLocation);
                                dialog.open();
                            }
                        });
                    }
                } else if (event.getResult().isOK()) {
                    RuntimeInstallJob installJob = new RuntimeInstallJob(PDEUIMessages.PluginExportWizard_InstallJobName, info);
                    installJob.setUser(true);
                    installJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_FEATURE_OBJ);
                    PluginExportUtil.this.editPreferences(installedProfilesUri);
                    installJob.schedule();
                }
            }
        });
        job.schedule();
    }

    private void editPreferences(List<InstalledProfileURI> installedProfilesUri) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.uml.export");
        Preferences node = preferences.node("installedProfilesUriCorrespondance");
        for (InstalledProfileURI p : installedProfilesUri) {
            node.put(p.getUri_local(), p.getUri_installed());
            try {
                preferences.flush();
            }
            catch (BackingStoreException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected boolean performPreliminaryChecks(Shell shell, Object object) {
        if (!"always".equals(PDEPlugin.getDefault().getPreferenceStore().getString("Preferences.MainPage.overwriteBuildFilesOnExport"))) {
            File file;
            ArrayList<Object> problemModels = new ArrayList<Object>();
            String installLocation = null;
            IResource underlyingResource = null;
            if (object instanceof WorkspacePluginModelBase) {
                installLocation = ((WorkspacePluginModelBase)object).getInstallLocation();
                underlyingResource = ((WorkspacePluginModelBase)object).getUnderlyingResource();
            } else if (object instanceof WorkspaceFeatureModel) {
                installLocation = ((WorkspaceFeatureModel)object).getInstallLocation();
                underlyingResource = ((WorkspaceFeatureModel)object).getUnderlyingResource();
            }
            if (installLocation != null && underlyingResource != null && (file = new File(installLocation, "build.xml")).exists()) {
                try {
                    IBuildEntry entry;
                    IFile buildFile = PDEProject.getBuildProperties((IProject)underlyingResource.getProject());
                    WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
                    buildModel.load();
                    if (!(buildModel == null || (entry = buildModel.getBuild().getEntry("custom")) != null && entry.contains("true"))) {
                        problemModels.add(object);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.log((Throwable)e);
                }
            }
            if (problemModels.size() > 0) {
                StringBuffer buf = new StringBuffer();
                PDELabelProvider labelProvider = new PDELabelProvider();
                int maxCount = 10;
                Iterator iterator = problemModels.iterator();
                while (iterator.hasNext()) {
                    buf.append(labelProvider.getText(iterator.next()));
                    buf.append('\n');
                    if (--maxCount > 0) continue;
                    buf.append("...");
                    break;
                }
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)PDEUIMessages.AntGeneratingExportWizard_0, (String)MessageFormat.format((String)PDEUIMessages.AntGeneratingExportWizard_1, (Object[])new Object[]{buf.toString()}), (String)PDEUIMessages.AntGeneratingExportWizard_2, (boolean)false, (IPreferenceStore)PDEPlugin.getDefault().getPreferenceStore(), (String)"Preferences.MainPage.overwriteBuildFilesOnExport");
                if (dialog.getReturnCode() == 1) {
                    return false;
                }
            }
        }
        return true;
    }

    public void delete(final IProject project) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < 3) {
                    try {
                        IProject tmpProject;
                        IProject iProject = tmpProject = project.getProject();
                        synchronized (iProject) {
                            if (tmpProject.exists()) {
                                tmpProject.delete(true, true, null);
                            }
                        }
                        i = 3;
                    }
                    catch (CoreException e) {
                        if (i == 2) {
                            throw e;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    public static IPluginModel getPluginModelForProject(IProject project) {
        PluginModelManager pmm = PDECore.getDefault().getModelManager();
        IPluginModelBase[] wsPlugins = pmm.getWorkspaceModels();
        if (wsPlugins.length == 0) {
            return null;
        }
        int i = 0;
        while (i < wsPlugins.length) {
            String resourceLocation;
            String projName;
            String id;
            IPluginModelBase wsPlugin = wsPlugins[i];
            IPluginBase pmBase = wsPlugin.getPluginBase();
            if (pmBase != null && (id = pmBase.getId()) != null && (projName = project.getName()) != null && (resourceLocation = pmBase.getModel().getUnderlyingResource().getLocation().toString()).endsWith(String.valueOf(projName) + "/META-INF/MANIFEST.MF")) {
                return (IPluginModel)wsPlugin;
            }
            ++i;
        }
        return null;
    }

    protected class ExportErrorDialog
    extends MessageDialog {
        private File fLogLocation;

        public ExportErrorDialog(File logLocation) {
            super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, null, null, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.fLogLocation = logLocation;
        }

        protected Control createMessageArea(Composite composite) {
            Link link = new Link(composite, 64);
            try {
                link.setText(NLS.bind((String)PDEUIMessages.PluginExportWizard_Ant_errors_during_export_logs_generated, (Object)("<a>" + this.fLogLocation.getCanonicalPath() + "</a>")));
            }
            catch (IOException e) {
                PDEPlugin.log((Throwable)e);
            }
            GridData data = new GridData();
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            link.setLayoutData((Object)data);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Program.launch((String)ExportErrorDialog.this.fLogLocation.getCanonicalPath());
                    }
                    catch (IOException ex) {
                        PDEPlugin.log((Throwable)ex);
                    }
                }
            });
            return link;
        }
    }
}

