/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.papyrus.commands.CheckedOperationHistory;
import org.eclipse.papyrus.commands.util.NonDirtyingUtils;

public class CheckedDiagramCommandStack
extends DiagramCommandStack {
    protected IOperationHistory operationHistory = CheckedOperationHistory.getInstance();

    public CheckedDiagramCommandStack(IDiagramEditDomain editDomain) {
        super(editDomain);
    }

    protected IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    public void execute(Command command, IProgressMonitor progressMonitor) {
        if (command != null && command.canExecute()) {
            this.execute(this.wrap(command), progressMonitor);
        }
    }

    private ICommand wrap(Command command) {
        if (command instanceof CompoundCommand) {
            CompositeCommand composite = new CompositeCommand(command.getLabel());
            Object[] subCommands = ((CompoundCommand)command).getChildren();
            int i = 0;
            while (i < subCommands.length) {
                composite.compose((IUndoableOperation)this.wrap((Command)subCommands[i]));
                ++i;
            }
            return composite.reduce();
        }
        if (command instanceof ICommandProxy) {
            return CheckedDiagramCommandStack.getICommand((ICommand)((ICommandProxy)command).getICommand());
        }
        if (command != null) {
            return NonDirtyingUtils.wrap(command);
        }
        return null;
    }

    public void dispose() {
        IUndoContext context = this.getUndoContext();
        if (context != null && this.operationHistory != null) {
            this.operationHistory.dispose(context, true, true, true);
        }
        super.dispose();
    }
}

