/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.OperationToGEFCommandWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandTreeIterator<C>
implements Iterator<C> {
    private final Class<C> type;
    private Iterator<?> current;
    private List<Iterator<?>> iterators = new ArrayList();
    private C preparedNext;
    private boolean done;

    private CommandTreeIterator(Object root, Class<C> type) {
        this.type = type;
        root = this.unwrap(root);
        if (this.isCompound(root)) {
            this.pushIterator(root);
        } else {
            this.done = !this.prepareNext(root);
        }
    }

    public static CommandTreeIterator<Command> iterateEMF(Object command) {
        return CommandTreeIterator.iterate(command, Command.class);
    }

    public static CommandTreeIterator<org.eclipse.gef.commands.Command> iterateGEF(Object command) {
        return CommandTreeIterator.iterate(command, org.eclipse.gef.commands.Command.class);
    }

    public static CommandTreeIterator<ICommand> iterateGMF(Object command) {
        return CommandTreeIterator.iterate(command, ICommand.class);
    }

    public static CommandTreeIterator<?> iterate(Object command) {
        return CommandTreeIterator.iterate(command, Object.class);
    }

    public static <C> CommandTreeIterator<C> iterate(Object command, Class<C> leafCommandType) {
        return new CommandTreeIterator<C>(command, leafCommandType);
    }

    private boolean prepareNext(Object command) {
        if (this.type.isInstance(command)) {
            this.preparedNext = this.type.cast(command);
        }
        return this.preparedNext != null;
    }

    private Iterator<?> pushIterator(Object compoundCommand) {
        if (this.current != null) {
            this.iterators.add(this.current);
        }
        this.current = this.iterator(compoundCommand);
        return this.current;
    }

    private Iterator<?> popIterator() {
        if (this.iterators.isEmpty()) {
            this.current = null;
            this.done = true;
        } else {
            this.current = this.iterators.remove(this.iterators.size() - 1);
        }
        return this.current;
    }

    private Object internalNext() {
        Object result = null;
        while (result == null && this.current != null) {
            if (this.current.hasNext()) {
                Object next = this.unwrap(this.current.next());
                if (this.isCompound(next)) {
                    this.pushIterator(next);
                    continue;
                }
                result = next;
                continue;
            }
            this.popIterator();
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        while (!this.done && this.preparedNext == null) {
            Object next = this.internalNext();
            if (!this.type.isInstance(next)) continue;
            this.preparedNext = this.type.cast(next);
        }
        return this.preparedNext != null;
    }

    @Override
    public C next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        C result = this.preparedNext;
        this.preparedNext = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private Object unwrap(Object command) {
        Object result = command;
        if (command instanceof ICommandProxy) {
            result = ((ICommandProxy)command).getICommand();
        } else if (command instanceof CommandProxy) {
            result = ((CommandProxy)command).getCommand();
        } else if (result instanceof EMFtoGEFCommandWrapper) {
            result = ((EMFtoGEFCommandWrapper)((Object)result)).getEMFCommand();
        } else if (result instanceof EMFtoGMFCommandWrapper) {
            result = ((EMFtoGMFCommandWrapper)((Object)command)).getEMFCommand();
        } else if (result instanceof GEFtoEMFCommandWrapper) {
            result = ((GEFtoEMFCommandWrapper)((Object)command)).getGEFCommand();
        } else if (result instanceof GMFtoEMFCommandWrapper) {
            result = ((GMFtoEMFCommandWrapper)((Object)command)).getGMFCommand();
        } else if (result instanceof GMFtoGEFCommandWrapper) {
            result = ((GMFtoGEFCommandWrapper)((Object)command)).getGMFCommand();
        } else if (result instanceof OperationToGEFCommandWrapper) {
            result = ((OperationToGEFCommandWrapper)((Object)command)).getOperation();
        }
        if (result != command) {
            result = this.unwrap(result);
        }
        return result;
    }

    private boolean isCompound(Object command) {
        return command instanceof CompoundCommand || command instanceof org.eclipse.gef.commands.CompoundCommand || command instanceof ICompositeCommand;
    }

    private Iterator<?> iterator(Object compoundCommand) {
        if (compoundCommand instanceof CompoundCommand) {
            return ((CompoundCommand)compoundCommand).getCommandList().iterator();
        }
        if (compoundCommand instanceof org.eclipse.gef.commands.CompoundCommand) {
            return ((org.eclipse.gef.commands.CompoundCommand)compoundCommand).getCommands().iterator();
        }
        if (compoundCommand instanceof ICompositeCommand) {
            return ((ICompositeCommand)compoundCommand).iterator();
        }
        return Collections.emptyList().iterator();
    }
}

