/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.AbstractStyleDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.GMFToCSSConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.helper.DiagramTypeHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.BaseCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.CustomStyle;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.AttributeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CSSFactory;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ClassSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ElementSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.charset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_property;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractStyleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        String selectorName;
        Map<AttributeSelector, Boolean> conditions;
        ISelection selection;
        try {
            selection = ServiceUtilsForHandlers.getInstance().getNestedActiveIEditorPart((Object)event).getSite().getSelectionProvider().getSelection();
            if (selection.isEmpty()) {
                return null;
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        Object element = sSelection.getFirstElement();
        View view = NotationHelper.findView((Object)element);
        if (view == null) {
            Activator.log.warn("Cannot create a Style from the selected element ; the element is not a View");
            return null;
        }
        Shell parentShell = ((Event)event.getTrigger()).widget.getDisplay().getActiveShell();
        if (view.getElement() == null || view instanceof Diagram) {
            MessageDialog.open((int)4, (Shell)parentShell, (String)"Style error", (String)"The selected element's style cannot be exported", (int)0);
            return null;
        }
        Map<css_declaration, Boolean> declarations = this.handleStyles(view);
        AbstractStyleDialog dialog = this.createStyleDialog(parentShell, declarations, conditions = this.handleSemantic(view), selectorName = view.getElement().eClass().getName(), view);
        if (dialog.open() != 0) {
            return null;
        }
        ruleset ruleset2 = this.getRuleset(dialog);
        selector baseSelector = CSSFactory.eINSTANCE.createselector();
        simple_selector simple_selector2 = this.createSimpleElementSelector(selectorName, dialog.useSelectorName());
        baseSelector.getSimpleselectors().add((Object)simple_selector2);
        if (dialog.getDiagramRestriction()) {
            String string = DiagramTypeHelper.getDiagramType(view.getDiagram());
            selector compositeSelector = CSSFactory.eINSTANCE.createselector();
            compositeSelector.setSelector(baseSelector);
            simple_selector diagramSelector = this.createSimpleElementSelector(string, false);
            compositeSelector.getSimpleselectors().add((Object)diagramSelector);
            ruleset2.getSelectors().add((Object)compositeSelector);
        } else {
            ruleset2.getSelectors().add((Object)baseSelector);
        }
        if (dialog.getCSSClass() != null) {
            String string = dialog.getCSSClass();
            ClassSelector classCondition = CSSFactory.eINSTANCE.createClassSelector();
            classCondition.setName(string);
            simple_selector2.getSubSelectors().add((Object)classCondition);
        }
        for (CssSelector cssSelector : conditions.keySet()) {
            if (!conditions.get(cssSelector).booleanValue()) continue;
            simple_selector2.getSubSelectors().add((Object)cssSelector);
        }
        for (css_declaration css_declaration2 : declarations.keySet()) {
            if (!declarations.get(css_declaration2).booleanValue()) continue;
            ruleset2.getDeclarations().add((Object)css_declaration2);
        }
        stylesheet stylesheet2 = this.getStyleSheet(dialog, view);
        if (stylesheet2 == null) {
            return null;
        }
        Resource resource = stylesheet2.eResource();
        if (!stylesheet2.getRuleset().contains((Object)ruleset2)) {
            stylesheet2.getRuleset().add((Object)ruleset2);
        }
        try {
            resource.save(new HashMap());
            BaseCSSEngine.INSTANCE.reset();
            DiagramHelper.forceRefresh();
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
            MessageDialog.open((int)1, (Shell)parentShell, (String)"Style error", (String)"An unexpected error occured while trying to save the Stylesheet", (int)0);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            MessageDialog.open((int)1, (Shell)parentShell, (String)"Style error", (String)"An unexpected error occured while trying to save the Stylesheet", (int)0);
        }
        return null;
    }

    protected simple_selector createSimpleElementSelector(String elementName, boolean universal) {
        simple_selector simple_selector2 = CSSFactory.eINSTANCE.createsimple_selector();
        if (universal) {
            simple_selector2.setUniversal(CSSFactory.eINSTANCE.createUniversalSelector());
        } else {
            ElementSelector elementSelector = CSSFactory.eINSTANCE.createElementSelector();
            elementSelector.setName(elementName);
            simple_selector2.setElement(elementSelector);
        }
        return simple_selector2;
    }

    protected abstract AbstractStyleDialog createStyleDialog(Shell var1, Map<css_declaration, Boolean> var2, Map<AttributeSelector, Boolean> var3, String var4, View var5);

    protected abstract ruleset getRuleset(AbstractStyleDialog var1);

    protected abstract stylesheet getStyleSheet(AbstractStyleDialog var1, View var2);

    protected Map<css_declaration, Boolean> handleStyles(View view) {
        LinkedHashMap<css_declaration, Boolean> declarations = new LinkedHashMap<css_declaration, Boolean>();
        for (Object styleObject : view.getStyles()) {
            Style style = (Style)styleObject;
            declarations.putAll(this.handleStyle(style));
        }
        if (view instanceof Style) {
            declarations.putAll(this.handleStyle((Style)view));
        }
        if (view instanceof CustomStyle) {
            declarations.putAll(this.handleCustomStyle((CustomStyle)view, view));
        }
        return declarations;
    }

    protected Map<AttributeSelector, Boolean> handleSemantic(View view) {
        LinkedHashMap<AttributeSelector, Boolean> result = new LinkedHashMap<AttributeSelector, Boolean>();
        EObject semanticElement = view.getElement();
        for (EStructuralFeature feature : semanticElement.eClass().getEAllStructuralFeatures()) {
            if (!this.isBoolean(feature) && !this.isInteger(feature) && !(feature.getEType() instanceof EEnum)) continue;
            AttributeSelector attributeCondition = CSSFactory.eINSTANCE.createAttributeSelector();
            attributeCondition.setName(feature.getName());
            attributeCondition.setOp("=");
            attributeCondition.setValue(semanticElement.eGet(feature).toString());
            boolean check = semanticElement.eGet(feature) != feature.getDefaultValue();
            result.put(attributeCondition, check);
        }
        return result;
    }

    protected boolean isBoolean(EStructuralFeature feature) {
        if (feature.getEType() == EcorePackage.eINSTANCE.getEBoolean() || feature.getEType() == EcorePackage.eINSTANCE.getEBooleanObject()) {
            return true;
        }
        if (feature.getEType() instanceof EDataType) {
            EDataType datatype = (EDataType)feature.getEType();
            return datatype.getName().equals("Boolean");
        }
        return false;
    }

    protected boolean isString(EStructuralFeature feature) {
        return feature.getEType() == EcorePackage.eINSTANCE.getEString();
    }

    protected boolean isInteger(EStructuralFeature feature) {
        if (feature.getEType() == EcorePackage.eINSTANCE.getEInt() || feature.getEType() == EcorePackage.eINSTANCE.getEIntegerObject()) {
            return true;
        }
        if (feature.getEType() instanceof EDataType) {
            EDataType datatype = (EDataType)feature.getEType();
            return datatype.getName().equals("Integer");
        }
        return false;
    }

    protected Map<css_declaration, Boolean> handleStyle(Style style) {
        if (style instanceof NamedStyle) {
            return Collections.emptyMap();
        }
        LinkedHashMap<css_declaration, Boolean> declarations = new LinkedHashMap<css_declaration, Boolean>();
        for (EStructuralFeature feature : style.eClass().getEAllStructuralFeatures()) {
            if (!NotationPackage.eINSTANCE.getStyle().isSuperTypeOf(feature.getEContainingClass())) continue;
            Object currentValue = style.eGet(feature);
            Object defaultValue = feature.getDefaultValue();
            boolean check = currentValue == null ? currentValue != defaultValue : !currentValue.equals(defaultValue);
            css_declaration declaration = this.handleStyleFeature(style, feature);
            if (declaration.getValueTokens().isEmpty()) continue;
            declarations.put(declaration, check);
        }
        return declarations;
    }

    protected Map<css_declaration, Boolean> handleCustomStyle(CustomStyle customStyle, View view) {
        LinkedHashMap<css_declaration, Boolean> declarations = new LinkedHashMap<css_declaration, Boolean>();
        GMFToCSSConverter converter = GMFToCSSConverter.instance;
        this.handleCustomStyle(view, "elementIcon", "displayNameLabelIcon", declarations, converter.convert(customStyle.showElementIcon()));
        this.handleCustomStyle(view, "shadow", "ShadowFigure", declarations, converter.convert(customStyle.showShadow()));
        this.handleCustomStyle(view, "qualifiedNameDepth", "QualifiedName", declarations, converter.convert(customStyle.getQualifiedNameDepth()));
        return declarations;
    }

    protected void handleCustomStyle(View view, String cssProperty, String eAnnotationName, Map<css_declaration, Boolean> result, List<CssTok> expression) {
        css_declaration cssDeclaration = CSSFactory.eINSTANCE.createcss_declaration();
        this.setProperty(cssDeclaration, cssProperty);
        this.setValueTokens(cssDeclaration, expression);
        boolean check = view.getEAnnotation(eAnnotationName) != null;
        result.put(cssDeclaration, check);
    }

    protected css_declaration handleStyleFeature(Style style, EStructuralFeature feature) {
        css_declaration declaration = CSSFactory.eINSTANCE.createcss_declaration();
        this.setProperty(declaration, feature.getName());
        GMFToCSSConverter converter = GMFToCSSConverter.instance;
        if (this.isString(feature)) {
            this.setValueTokens(declaration, converter.convert((String)style.eGet(feature)));
        }
        if (this.isInteger(feature)) {
            if (feature.getName().endsWith("Color")) {
                Color color = FigureUtilities.integerToColor((Integer)((Integer)style.eGet(feature)));
                this.setValueTokens(declaration, converter.convert(color));
                color.dispose();
            } else {
                this.setValueTokens(declaration, converter.convert((Integer)style.eGet(feature)));
            }
        }
        if (feature.getEType() == NotationPackage.eINSTANCE.getGradientData()) {
            this.setValueTokens(declaration, converter.convert((GradientData)style.eGet(feature)));
        }
        if (feature.getEType() instanceof EEnum) {
            this.setValueTokens(declaration, converter.convert((Enumerator)style.eGet(feature)));
        }
        if (this.isBoolean(feature)) {
            this.setValueTokens(declaration, converter.convert((Boolean)style.eGet(feature)));
        }
        return declaration;
    }

    protected final void setProperty(css_declaration declaration, String property) {
        css_property cssProperty = CSSFactory.eINSTANCE.createcss_property();
        cssProperty.setName(property);
        declaration.setProperty(cssProperty);
    }

    protected final void setValueTokens(css_declaration declaration, List<CssTok> tokens) {
        declaration.getValueTokens().clear();
        declaration.getValueTokens().addAll(tokens);
    }

    protected final void setCharset(stylesheet stylesheet2, String charset2) {
        charset cssCharset = CSSFactory.eINSTANCE.createcharset();
        cssCharset.setCharset(charset2);
    }
}

