/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.command;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSStyles;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;

public class ResetStyleCommand
extends RecordingCommand {
    private static Set<String> papyrusStyleAnnotations = new HashSet<String>();
    private Iterator<?> iterator;
    private TransactionalEditingDomain domain;

    static {
        papyrusStyleAnnotations.add("displayNameLabelIcon");
        papyrusStyleAnnotations.add("ShadowFigure");
        papyrusStyleAnnotations.add("QualifiedName");
        papyrusStyleAnnotations.add("CustomAppearance_Annotation");
        papyrusStyleAnnotations.add("depth");
    }

    public ResetStyleCommand(TransactionalEditingDomain domain, Iterator<?> iterator) {
        super(domain);
        this.domain = domain;
        this.iterator = iterator;
    }

    public void doExecute() {
        while (this.iterator.hasNext()) {
            Object selectedItem = this.iterator.next();
            View view = NotationHelper.findView(selectedItem);
            if (view == null) continue;
            if (view instanceof Diagram) {
                this.resetDiagram((Diagram)view);
                break;
            }
            this.resetStyle(view, true);
        }
    }

    private void resetDiagram(Diagram diagram) {
        for (Object viewObject : diagram.getChildren()) {
            if (!(viewObject instanceof View)) continue;
            this.resetStyle((View)viewObject, true);
        }
        for (Object lineObject : diagram.getEdges()) {
            if (!(lineObject instanceof View)) continue;
            this.resetStyle((View)lineObject, true);
        }
    }

    private void resetStyle(View view, boolean recursive) {
        this.resetStyle(view);
        if (recursive) {
            for (Object childObject : view.getChildren()) {
                if (!(childObject instanceof View)) continue;
                this.resetStyle((View)childObject, recursive);
            }
        }
    }

    private void resetStyle(View view) {
        if (view.eContainingFeature().isTransient()) {
            return;
        }
        Iterator styleIterator = view.getStyles().iterator();
        while (styleIterator.hasNext()) {
            Object styleObject = styleIterator.next();
            if (styleObject instanceof NamedStyle) {
                NamedStyle customStyle = (NamedStyle)styleObject;
                if (CSSStyles.RESERVED_KEYWORDS.contains(customStyle.getName())) continue;
                switch (customStyle.eClass().getClassifierID()) {
                    case 42: 
                    case 44: 
                    case 45: 
                    case 47: 
                    case 48: {
                        styleIterator.remove();
                    }
                }
                continue;
            }
            if (!(styleObject instanceof Style)) continue;
            this.resetStyle((Style)styleObject);
        }
        if (view instanceof Style) {
            this.resetStyle((Style)view);
        }
        this.resetAnnotations(view);
        this.resetStyleAnnotations(view);
        this.resetStereotypeView(view);
        view.eUnset((EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible());
    }

    private void resetStereotypeView(View view) {
        StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
        if (helper.isStereotypeView((Object)view)) {
            helper.unsetPersistency(this.domain, view);
        }
    }

    private void resetStyle(Style style) {
        if (style instanceof NamedStyle) {
            return;
        }
        for (EStructuralFeature feature : style.eClass().getEAllStructuralFeatures()) {
            if (!NotationPackage.eINSTANCE.getStyle().isSuperTypeOf(feature.getEContainingClass())) continue;
            style.eUnset(feature);
        }
    }

    private void resetAnnotations(View view) {
        Iterator iterator = view.getEAnnotations().iterator();
        while (iterator.hasNext()) {
            if (!"PapyrusCSSForceValue".equals(((EAnnotation)iterator.next()).getSource())) continue;
            iterator.remove();
        }
    }

    private void resetStyleAnnotations(View view) {
        Iterator iterator = view.getEAnnotations().iterator();
        while (iterator.hasNext()) {
            if (!papyrusStyleAnnotations.contains(((EAnnotation)iterator.next()).getSource())) continue;
            iterator.remove();
        }
    }
}

