/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.BaseCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.theme.ThemeManager;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.w3c.dom.Element;

public class WorkspaceCSSEngine
extends ExtendedCSSEngineImpl {
    public static ExtendedCSSEngine instance = new WorkspaceCSSEngine();

    private WorkspaceCSSEngine() {
        super(BaseCSSEngine.INSTANCE);
    }

    @Override
    protected void reloadStyleSheets() {
        this.styleSheetURLs.clear();
        this.styleSheets.clear();
        for (StyleSheet styleSheet : ThemeManager.instance.getWorkspaceStyleSheets()) {
            if (styleSheet instanceof StyleSheetReference) {
                IFile iFile = FileUtil.getIFile((String)((StyleSheetReference)styleSheet).getPath());
                if (iFile != null) {
                    this.styleSheets.add(styleSheet);
                    continue;
                }
                try {
                    URL styleSheetURL = new URL(((StyleSheetReference)styleSheet).getPath());
                    this.styleSheetURLs.add(styleSheetURL);
                }
                catch (MalformedURLException e) {
                    Activator.log.error((Throwable)e);
                }
                continue;
            }
            this.styleSheets.add(styleSheet);
        }
    }

    @Override
    public Element getElement(Object node) {
        throw new UnsupportedOperationException();
    }

    public IElementProvider getElementProvider() {
        throw new UnsupportedOperationException();
    }

    public void setElementProvider(IElementProvider elementProvider) {
        throw new UnsupportedOperationException();
    }

    public CSSElementContext getCSSElementContext(Object node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtendedCSSEngine.CascadeScope getCascadeScope() {
        return ExtendedCSSEngine.CascadeScope.USER;
    }
}

