/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.canonical;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ISemanticChildrenStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DefaultUMLSemanticChildrenStrategy
implements ISemanticChildrenStrategy {
    public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
        ArrayList result = null;
        if (semanticFromEditPart instanceof Element) {
            Element element = (Element)semanticFromEditPart;
            Object owned = element.getOwnedElements();
            owned = Iterables.filter((Iterable)owned, (Predicate)Predicates.not((Predicate)UMLUtil.isRelationship()));
            owned = Iterables.filter((Iterable)owned, (Predicate)Predicates.not((Predicate)Predicates.and((Predicate)UMLUtil.isAssociationEnd(), this.isPropertyTypeVisualized(viewFromEditPart))));
            result = Lists.newArrayList((Iterable)owned);
        }
        return result;
    }

    protected Predicate<Object> isPropertyTypeVisualized(View viewContext) {
        final Diagram diagram = viewContext.getDiagram();
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                Type type;
                boolean result = false;
                if (input instanceof Property && (type = ((Property)input).getType()) != null) {
                    for (Object view : DiagramEditPartsUtil.getEObjectViews((EObject)type)) {
                        if (((View)view).getDiagram() != diagram) continue;
                        result = true;
                        break;
                    }
                }
                return result;
            }
        };
    }

    public List<? extends EObject> getCanonicalSemanticConnections(EObject semanticFromEditPart, View viewFromEditPart) {
        Object result = null;
        if (semanticFromEditPart instanceof Element) {
            Element element = (Element)semanticFromEditPart;
            result = Lists.newArrayList((Iterable)element.getRelationships());
            result = new ConnectionsSwitch(viewFromEditPart, (List<Element>)result).doSwitch((EObject)element);
        }
        return result;
    }

    public Collection<? extends EObject> getCanonicalDependents(EObject semanticFromEditPart, View viewFromEditPart) {
        Package package_;
        List<Package> result = null;
        if (semanticFromEditPart instanceof NamedElement && (package_ = ((NamedElement)semanticFromEditPart).getNearestPackage()) != null) {
            result = Collections.singletonList(package_);
        }
        return result;
    }

    protected Property getExpectedPartWithPort(View possiblePortView) {
        View parentView;
        Property result = null;
        if (possiblePortView.getElement() instanceof Port && (parentView = (View)TypeUtils.as((Object)possiblePortView.eContainer(), View.class)) != null) {
            result = (Property)TypeUtils.as((Object)parentView.getElement(), Property.class);
        }
        return result;
    }

    private class ConnectionsSwitch
    extends UMLSwitch<List<Element>> {
        private final View visualContext;
        private final List<Element> result;

        ConnectionsSwitch(View visualContext, List<Element> result) {
            this.visualContext = visualContext;
            this.result = result;
        }

        public List<Element> doSwitch(EObject eObject) {
            super.doSwitch(eObject);
            return this.result;
        }

        public List<Element> caseConnectableElement(ConnectableElement object) {
            Property expectedPartWithPort = DefaultUMLSemanticChildrenStrategy.this.getExpectedPartWithPort(this.visualContext);
            for (ConnectorEnd next : object.getEnds()) {
                if (next.getPartWithPort() != expectedPartWithPort) continue;
                this.result.add(next.getOwner());
            }
            return (List)super.caseConnectableElement(object);
        }

        public List<Element> caseActivityNode(ActivityNode object) {
            this.result.addAll((Collection<Element>)object.getOutgoings());
            this.result.addAll((Collection<Element>)object.getIncomings());
            return (List)super.caseActivityNode(object);
        }

        public List<Element> caseVertex(Vertex object) {
            this.result.addAll((Collection<Element>)object.getOutgoings());
            this.result.addAll((Collection<Element>)object.getIncomings());
            return (List)super.caseVertex(object);
        }

        public List<Element> caseMessageEnd(MessageEnd object) {
            this.result.add((Element)object.getMessage());
            return (List)super.caseMessageEnd(object);
        }
    }
}

