/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RoundedRectangleBorder;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SVGNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SlidableRoundedRectangleAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.SubCompartmentLayoutManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.RGBColor;

public class RoundedCompartmentFigure
extends NodeNamedElementFigure
implements IRoundedRectangleFigure {
    private Map<String, RectangleFigure> containerFigures;
    protected Dimension cornerDimension = new Dimension();
    protected boolean isOval = false;
    protected boolean isLabelConstrained = false;
    protected Dimension floatingNameOffset = new Dimension();
    protected int borderStyle = 1;
    private boolean hasHeader = false;
    private Border cachedBorder;
    private int cachedTransparency;
    private int shadowWidth = 4;
    String shadowColor = null;
    private boolean isPackage = false;

    public String getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(String shadowColor) {
        this.shadowColor = shadowColor;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
        if (this.shadowborder != null) {
            this.shadowborder.setStyle(borderStyle);
        }
    }

    public RoundedCompartmentFigure() {
        this(null, null);
    }

    public RoundedCompartmentFigure(String taggedLabel) {
        super(taggedLabel);
    }

    public RoundedCompartmentFigure(List<String> compartmentFigure) {
        this(compartmentFigure, null);
    }

    public RoundedCompartmentFigure(List<String> compartmentFigure, String taggedLabelValue) {
        super(taggedLabelValue);
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new AutomaticCompartmentLayoutManager());
        if (compartmentFigure != null) {
            this.createContentPane(compartmentFigure);
        }
    }

    public void setShadowWidth(int shadowWidth) {
        this.shadowWidth = shadowWidth;
    }

    public void setIsPackage(boolean isPackage) {
        this.isPackage = isPackage;
    }

    protected void createContentPane(List<String> compartmentFigure) {
        this.containerFigures = new HashMap<String, RectangleFigure>();
        for (String id : compartmentFigure) {
            RectangleFigure newFigure = new RectangleFigure();
            newFigure.setLayoutManager((LayoutManager)new SubCompartmentLayoutManager());
            newFigure.setFill(false);
            newFigure.setBorder(null);
            newFigure.setOutline(false);
            newFigure.setOpaque(false);
            this.add((IFigure)newFigure);
            this.containerFigures.put(id, newFigure);
        }
    }

    public RectangleFigure getCompartment(String id) {
        return this.containerFigures.get(id);
    }

    public Dimension getCornerDimensions() {
        return this.cornerDimension;
    }

    public Rectangle getRoundedRectangleBounds() {
        return this.getBounds();
    }

    @Override
    public void paintFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle rectangle = this.getBounds().getCopy();
        Rectangle clipRectangle = this.getBounds().getCopy();
        this.refreshCornerSizeWhenOval();
        this.applyTransparency(graphics);
        if (this.isPackage) {
            SVGNodePlateFigure mainFigure = (SVGNodePlateFigure)FigureUtils.findParentFigureInstance((IFigure)this, SVGNodePlateFigure.class);
            ConnectionAnchor connectionAnchor = mainFigure.getConnectionAnchor("");
            if (connectionAnchor instanceof SlidableRoundedRectangleAnchor) {
                PointList polygonPoints = ((SlidableRoundedRectangleAnchor)connectionAnchor).getPolygonPoints();
                this.translateToRelative((Translatable)polygonPoints);
                graphics.getClip(clipRectangle);
                graphics.setClip(clipRectangle.expand(1, 1));
                if (this.isShadow()) {
                    this.setShadowTransparency(graphics, true);
                    polygonPoints.translate(this.shadowWidth, this.shadowWidth);
                    clipRectangle.width += this.shadowWidth;
                    clipRectangle.height += this.shadowWidth;
                    graphics.setClip(clipRectangle);
                    this.setShadowBackgroundColor(graphics);
                    graphics.fillPolygon(polygonPoints);
                    polygonPoints.translate(-this.shadowWidth, -this.shadowWidth);
                    clipRectangle.width -= this.shadowWidth;
                    clipRectangle.height -= this.shadowWidth;
                    graphics.setClip(clipRectangle);
                    this.setShadowTransparency(graphics, false);
                }
                if (this.isUsingGradient()) {
                    this.fillPolygonWithGradient(graphics, polygonPoints);
                } else {
                    graphics.fillPolygon(polygonPoints);
                }
                graphics.setLineWidth(this.getLineWidth());
                graphics.setLineStyle(this.borderStyle);
                if (this.cachedBorder == null) {
                    this.cachedBorder = this.getBorder();
                }
                if (this.getBorder() != null) {
                    this.setBorder(null);
                }
                graphics.drawPolyline(polygonPoints);
            }
        } else {
            if (this.cachedBorder != null) {
                this.setBorder(this.cachedBorder);
                this.cachedBorder = null;
            }
            if (this.isShadow()) {
                this.setShadowTransparency(graphics, true);
                rectangle.translate(this.shadowWidth, this.shadowWidth);
                graphics.getClip(clipRectangle);
                clipRectangle.width += this.shadowWidth;
                clipRectangle.height += this.shadowWidth;
                graphics.setClip(clipRectangle);
                this.setShadowBackgroundColor(graphics);
                graphics.fillRoundRectangle(rectangle, this.cornerDimension.width, this.cornerDimension.height);
                rectangle.translate(-this.shadowWidth, -this.shadowWidth);
                clipRectangle.width -= this.shadowWidth;
                clipRectangle.height -= this.shadowWidth;
                graphics.setClip(clipRectangle);
                this.setShadowTransparency(graphics, false);
            }
            if (this.isUsingGradient()) {
                this.fillRoundedRectangleWithGradient(graphics, rectangle, this.cornerDimension.width, this.cornerDimension.height);
            } else {
                graphics.pushState();
                graphics.setBackgroundColor(this.getBackgroundColor());
                graphics.setForegroundColor(this.getForegroundColor());
                graphics.fillRoundRectangle(rectangle, this.cornerDimension.width, this.cornerDimension.height);
                graphics.popState();
            }
            if (this.hasHeader) {
                graphics.drawPolyline(this.getHeader());
            }
        }
        graphics.popState();
    }

    protected void fillPolygonWithGradient(Graphics graphics, PointList polygonPoints) {
        graphics.pushState();
        Path path = new Path(null);
        path.moveTo((float)polygonPoints.getPoint((int)0).x, (float)polygonPoints.getPoint((int)0).y);
        int i = 1;
        while (i < polygonPoints.size()) {
            path.lineTo((float)polygonPoints.getPoint((int)i).x, (float)polygonPoints.getPoint((int)i).y);
            ++i;
        }
        path.close();
        graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
        graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
        graphics.clipPath(path);
        graphics.fillGradient(this.getBounds(), this.getGradientStyle() == 0);
        path.dispose();
        graphics.popState();
    }

    protected void fillRoundedRectangleWithGradient(Graphics graphics, Rectangle rectangle, int arcWidths, int arcHeights) {
        graphics.pushState();
        Rectangle rect = rectangle.getCopy();
        Dimension arc = new Dimension(arcWidths, arcHeights);
        rect.setWidth(rect.width - 1);
        rect.setHeight(rect.height - 1);
        Path path = new Path(null);
        if (this.isOval) {
            arc.width = rect.width;
            arc.height = rect.height;
        } else {
            if (rect.width < arc.width) {
                arc.width = rect.width;
            }
            if (rect.height < arc.height) {
                arc.height = rect.height;
            }
        }
        path.moveTo((float)(rect.x + arc.width / 2), (float)rect.y);
        path.lineTo((float)(rect.x + rect.width - arc.width / 2), (float)rect.y);
        path.addArc((float)(rect.x + rect.width - arc.width), (float)rect.y, (float)arc.width, (float)arc.height, 90.0f, -90.0f);
        path.lineTo((float)(rect.x + rect.width), (float)(rect.y + rect.height - arc.height / 2));
        path.addArc((float)(rect.x + rect.width - arc.width), (float)(rect.y + rect.height - arc.height), (float)arc.width, (float)arc.height, 0.0f, -90.0f);
        path.lineTo((float)(rect.x + arc.width / 2), (float)(rect.y + rect.height));
        path.addArc((float)rect.x, (float)(rect.y + rect.height - arc.height), (float)arc.width, (float)arc.height, -90.0f, -90.0f);
        path.lineTo((float)rect.x, (float)(rect.y + arc.height / 2));
        path.addArc((float)rect.x, (float)rect.y, (float)arc.width, (float)arc.height, 180.0f, -90.0f);
        graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
        graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
        graphics.clipPath(path);
        graphics.fillGradient(this.getBounds(), this.getGradientStyle() == 0);
        path.dispose();
        graphics.popState();
    }

    private void setShadowBackgroundColor(Graphics graphics) {
        Color color = null;
        if (this.shadowColor != null && !"-1".equals(this.shadowColor)) {
            RGBColor rgbColor = CSS2ColorHelper.getRGBColor((String)this.shadowColor);
            if (rgbColor != null) {
                int red = Integer.parseInt(rgbColor.getRed().toString());
                int green = Integer.parseInt(rgbColor.getGreen().toString());
                int blue = Integer.parseInt(rgbColor.getBlue().toString());
                color = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
            }
            if (color == null) {
                try {
                    color = ColorRegistry.getInstance().getColor(Integer.valueOf(this.shadowColor));
                }
                catch (NumberFormatException e) {
                    Activator.log.error("Shadow Color not well set", (Throwable)e);
                }
            }
        }
        if (color != null) {
            graphics.setBackgroundColor(color);
        } else {
            graphics.setBackgroundColor(this.getForegroundColor());
        }
    }

    private void setShadowTransparency(Graphics graphics, boolean toApplied) {
        if (toApplied) {
            this.cachedTransparency = this.getTransparency();
            int transparency = this.cachedTransparency + (100 - this.cachedTransparency) / 2;
            if (transparency > 100) {
                transparency = 100;
            }
            graphics.setAlpha(255 - transparency * 255 / 100);
        } else {
            graphics.setAlpha(255 - this.cachedTransparency * 255 / 100);
        }
    }

    @Override
    public void setShadow(boolean shadow) {
        super.setShadow(shadow);
        this.refreshCornerSizeWhenOval();
        RoundedRectangleBorder border = new RoundedRectangleBorder(this.cornerDimension.width, this.cornerDimension.height){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                int transparency = 255 - ((NodeFigure)figure).getTransparency() * 255 / 100;
                graphics.setAlpha(transparency);
                super.paint(figure, graphics, insets);
            }
        };
        border.setWidth(this.getLineWidth());
        border.setStyle(this.borderStyle);
        this.setBorder((Border)border);
        this.setLineStyle(this.borderStyle);
    }

    private void refreshCornerSizeWhenOval() {
        if (this.isOval && (this.cornerDimension.width != this.getBounds().width || this.cornerDimension.height != this.getBounds().height)) {
            this.cornerDimension.width = this.getBounds().width;
            this.cornerDimension.height = this.getBounds().height;
            this.setShadow(this.isShadow());
        }
    }

    public void setCornerDimensions(Dimension cornerDimension) {
        this.cornerDimension = cornerDimension.width == 0 || cornerDimension.height == 0 ? new Dimension() : cornerDimension;
    }

    public void setOval(boolean booleanValue) {
        this.isOval = booleanValue;
        if (booleanValue) {
            this.refreshCornerSizeWhenOval();
        }
    }

    public boolean isOval() {
        return this.isOval;
    }

    public void setFloatingNameConstrained(boolean booleanValue) {
        this.isLabelConstrained = booleanValue;
    }

    public boolean isFloatingNameConstrained() {
        return this.isLabelConstrained;
    }

    public void setFloatingNameOffset(Dimension offset) {
        this.floatingNameOffset = offset;
    }

    public Dimension getFloatingNameOffset() {
        return this.floatingNameOffset;
    }

    protected PointList getHeader() {
        Rectangle labelBounds = this.nameLabel.getBounds().getCopy();
        PointList points = new PointList();
        int labelWidth = -1;
        if ((labelWidth = Math.max(labelWidth, this.nameLabel.getPreferredSize().width)) <= 0) {
            labelWidth = this.getBounds().width / 4;
        }
        Point verticalStart = new Point();
        Point verticalEnd = new Point();
        Point diagonalStart = new Point();
        Point diagonalEnd = new Point();
        Point horizontalStart = new Point();
        Point horizontalEnd = new Point();
        verticalStart.x = labelBounds.x + labelWidth + 4;
        verticalStart.y = this.getBounds().y;
        points.addPoint(verticalStart);
        verticalEnd.x = verticalStart.x;
        verticalEnd.y = verticalStart.y + labelBounds.height / 2 + 3;
        points.addPoint(verticalEnd);
        diagonalStart.x = verticalEnd.x;
        diagonalStart.y = verticalEnd.y;
        points.addPoint(diagonalStart);
        diagonalEnd.x = diagonalStart.x - labelBounds.height / 2 + 3;
        diagonalEnd.y = labelBounds.y + labelBounds.height - 1;
        points.addPoint(diagonalEnd);
        horizontalStart.x = diagonalEnd.x;
        horizontalStart.y = diagonalEnd.y;
        points.addPoint(horizontalStart);
        horizontalEnd.x = labelBounds.x;
        horizontalEnd.y = horizontalStart.y;
        points.addPoint(horizontalEnd);
        return points;
    }

    public Rectangle getPackageHeader() {
        Rectangle headerBound = new Rectangle();
        if (this.isPackage) {
            ResizableCompartmentFigure firstCompartment = (ResizableCompartmentFigure)FigureUtils.findChildFigureInstance((IFigure)this, ResizableCompartmentFigure.class);
            if (firstCompartment != null) {
                int labelWidth = 60;
                labelWidth = Math.max(labelWidth, this.nameLabel.getPreferredSize().width);
                if (this.stereotypesLabel != null) {
                    labelWidth = Math.max(labelWidth, this.stereotypesLabel.getPreferredSize().width);
                }
                labelWidth = Math.min(labelWidth, this.getBounds().width);
                headerBound.x = this.getBounds().x;
                headerBound.y = this.getBounds().y;
                headerBound.height = firstCompartment.getBounds().y - this.getBounds().y;
                headerBound.width = labelWidth;
            } else {
                headerBound = this.nameLabel.getBounds().getCopy();
            }
        }
        return headerBound;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }
}

