/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.PropertyLabelParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;

public class AssociationEndLabelParser
extends PropertyLabelParser {
    protected static final String ALT_MODIFIER_FORMAT = "{%s}%s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Property) {
            Property property = (Property)eObject;
            if (maskValues.contains("visibility")) {
                String visibility;
                switch (property.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format("%s %s", visibility, result);
            }
            if (maskValues.contains("derived") && property.isDerived()) {
                result = String.format("%s/", result);
            }
            if (maskValues.contains("name") && property.isSetName()) {
                String name = property.getName();
                if (maskValues.contains("nonNavigableRole") || property.getOwningAssociation() == null || !property.getOwningAssociation().getOwnedEnds().contains((Object)property)) {
                    result = String.format("%s%s", result, name);
                }
            }
            if (maskValues.contains("type")) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = property.getType().getName();
                }
                if (maskValues.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format("%s: %s", result, type);
                }
            }
            if (maskValues.contains("multiplicity")) {
                String upper;
                String lower = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getLowerValue()) : "1";
                String string = upper = property.getLowerValue() != null ? ValueSpecificationUtil.getSpecificationValue((ValueSpecification)property.getUpperValue()) : "1";
                if (maskValues.contains("defaultMultiplicity") || !"1".equals(lower) || !"1".equals(upper)) {
                    result = lower.equals(upper) ? String.format("%s [%s]", result, lower, upper) : String.format("%s [%s..%s]", result, lower, upper);
                }
            }
            if (maskValues.contains("defaultValue") && property.getDefaultValue() != null) {
                ValueSpecification valueSpecification = property.getDefaultValue();
                result = String.format("%s= %s", result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification));
            }
            if (maskValues.contains("modifiers")) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append(sb.length() == 0 ? p.getName() : ", redefines " + p.getName());
                    }
                }
                if (sb.length() != 0) {
                    result = String.format(ALT_MODIFIER_FORMAT, sb.toString(), result);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getMasks() {
        return super.getMasks();
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        View view = (View)element.getAdapter(View.class);
        if (view == null) {
            return super.getDefaultValue(element);
        }
        if (view.getType() != null && view.getType().contains("multiplicity")) {
            return Arrays.asList("multiplicity", "defaultMultiplicity");
        }
        if (view.getType() != null && view.getType().contains("role")) {
            return Arrays.asList("name", "visibility", "derived");
        }
        return super.getDefaultValue(element);
    }
}

