/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.swt.graphics.Image;

public class DiagramDecorationAdapter {
    protected IDecoratorTarget decoratorTarget;
    protected List<IDecoration> decorations;

    public DiagramDecorationAdapter(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public IDecoratorTarget getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public void removeDecorations() {
        if (this.decoratorTarget == null || this.decorations == null) {
            return;
        }
        for (IDecoration decoration : this.decorations) {
            this.removeDecoration(decoration);
        }
    }

    public void setDecoratorTarget(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public final Label getToolTip(String message) {
        return new Label(message);
    }

    public final List<IDecoration> setDecorationsNode(List<IPapyrusDecoration> pDecorations, int margin, boolean isVolatile) {
        this.decorations = new BasicEList();
        for (IPapyrusDecoration pDecoration : pDecorations) {
            Image image = this.addDecorationNode(pDecoration, margin, isVolatile);
            if (image == null) continue;
            margin += image.getBounds().width;
        }
        return this.decorations;
    }

    public final List<IDecoration> setDecorationsEdge(List<IPapyrusDecoration> pDecorations, int percentageFromSource, boolean isVolatile) {
        int distBetweenIconsPercent = 20;
        int percentageMin = 10;
        int percentageMax = 90;
        this.decorations = new BasicEList();
        if (pDecorations.size() > 1) {
            percentageFromSource -= 10 * (pDecorations.size() - 1);
        }
        if (percentageFromSource < 10) {
            percentageFromSource = 10;
        }
        for (IPapyrusDecoration pDecoration : pDecorations) {
            this.addDecoration(pDecoration, percentageFromSource, 0, isVolatile);
            if ((percentageFromSource += 20) <= 90) continue;
            percentageFromSource = 90;
        }
        return this.decorations;
    }

    public final Image addDecorationNode(IPapyrusDecoration pDecoration, int margin, boolean isVolatile) {
        if (margin == -1) {
            margin = 0;
            for (IDecoration decoration : this.decorations) {
                if (!(decoration instanceof Decoration)) continue;
                margin += ((Decoration)decoration).getBounds().width;
            }
        }
        return this.addDecoration(pDecoration, 0, margin, true);
    }

    public final Image addDecoration(IPapyrusDecoration pDecoration, int percentageFromSource, int margin, boolean isVolatile) {
        Image image = Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", pDecoration.getDecorationImageForGE());
        IDecoration decoration = this.createDecorationImage(this.decoratorTarget, image, percentageFromSource, margin, isVolatile);
        if (decoration != null) {
            this.decorations.add(decoration);
            String message = pDecoration.getMessage();
            Label toolTip = this.getToolTip(message);
            if (decoration instanceof Decoration) {
                ((Decoration)decoration).setToolTip((IFigure)toolTip);
            }
            return image;
        }
        return null;
    }

    public final void removeDecoration(IDecoration decoration) {
        GraphicalEditPart ownerEditPart;
        IFigure parent;
        if (decoration == null || this.decoratorTarget == null) {
            return;
        }
        if (decoration instanceof IFigure && (parent = ((IFigure)decoration).getParent()) != null) {
            parent.remove((IFigure)decoration);
        }
        if ((ownerEditPart = (GraphicalEditPart)this.decoratorTarget.getAdapter(GraphicalEditPart.class)).getViewer() != null) {
            ownerEditPart.getViewer().getVisualPartMap().remove(decoration);
        }
    }

    public final IDecoration createDecorationImage(IDecoratorTarget decoratorTarget, Image image, int percentageFromSource, int margin, boolean isVolatile) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        IDecoration decoration = null;
        if (view == null || view.eResource() == null || image == null) {
            return decoration;
        }
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return decoration;
        }
        if (view instanceof Edge) {
            decoration = decoratorTarget.addConnectionDecoration(image, percentageFromSource, isVolatile);
        } else {
            IPrimaryEditPart primaryEditPart = this.getPrimaryEditPart(editPart);
            if (primaryEditPart != null && primaryEditPart instanceof GraphicalEditPart) {
                IFigure parentFig = ((GraphicalEditPart)primaryEditPart).getFigure();
                MultiIconTopRightLocator locator = new MultiIconTopRightLocator(parentFig, margin);
                decoration = decoratorTarget.addShapeDecoration(image, IDecoratorTarget.Direction.NORTH_EAST, margin, isVolatile);
                if (decoration instanceof Decoration) {
                    ((Decoration)decoration).setLocator((Locator)locator);
                }
            }
        }
        return decoration;
    }

    protected IPrimaryEditPart getPrimaryEditPart(EditPart editPart) {
        IPrimaryEditPart ret = null;
        if (editPart instanceof IPrimaryEditPart) {
            return (IPrimaryEditPart)editPart;
        }
        if (editPart.getParent() != null) {
            ret = this.getPrimaryEditPart(editPart.getParent());
        }
        return ret;
    }

    public final IDecoration createDecorationFigure(IDecoratorTarget decoratorTarget, IFigure figure, int percentageFromSource, int margin, boolean isVolatile) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        IDecoration decoration = null;
        if (view == null || view.eResource() == null || figure == null) {
            return decoration;
        }
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return decoration;
        }
        if (editPart instanceof GraphicalEditPart) {
            if (view instanceof Edge) {
                decoration = decoratorTarget.addConnectionDecoration(figure, percentageFromSource, isVolatile);
            } else {
                IFigure parentFig = ((GraphicalEditPart)editPart).getFigure();
                margin = MapModeUtil.getMapMode((IFigure)parentFig).DPtoLP(margin);
                decoration = decoratorTarget.addShapeDecoration(figure, IDecoratorTarget.Direction.NORTH_EAST, margin, isVolatile);
            }
        }
        return decoration;
    }

    @Deprecated
    private IDecoratorTarget.Direction getDirection(Decoration.PreferedPosition position) {
        switch (position) {
            case NORTH_WEST: {
                return IDecoratorTarget.Direction.NORTH_WEST;
            }
            case NORTH: {
                return IDecoratorTarget.Direction.NORTH;
            }
            case NORTH_EAST: {
                return IDecoratorTarget.Direction.NORTH_EAST;
            }
            case EAST: {
                return IDecoratorTarget.Direction.EAST;
            }
            case SOUTH_EAST: {
                return IDecoratorTarget.Direction.SOUTH_EAST;
            }
            case SOUTH: {
                return IDecoratorTarget.Direction.SOUTH;
            }
            case SOUTH_WEST: {
                return IDecoratorTarget.Direction.SOUTH_WEST;
            }
            case WEST: {
                return IDecoratorTarget.Direction.WEST;
            }
            case CENTER: {
                return IDecoratorTarget.Direction.CENTER;
            }
        }
        return IDecoratorTarget.Direction.NORTH_EAST;
    }

    public class MultiIconTopRightLocator
    implements Locator {
        protected IFigure reference;
        protected int rightMargin;

        public MultiIconTopRightLocator(IFigure parentFig, int rightMargin) {
            this.reference = parentFig;
            if (rightMargin < 0) {
                rightMargin = 0;
            }
            this.rightMargin = rightMargin;
        }

        public void relocate(IFigure target) {
            PrecisionRectangle bounds;
            if (this.reference instanceof HandleBounds) {
                bounds = new PrecisionRectangle(((HandleBounds)this.reference).getHandleBounds());
            } else {
                bounds = new PrecisionRectangle(this.reference.getBounds());
                ++bounds.x;
                ++bounds.y;
                bounds.width -= 2;
                bounds.height -= 2;
            }
            this.reference.translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            Point pTR = bounds.getTopRight();
            Point pTL = bounds.getTopLeft();
            Point pDecoration = new Point(pTR);
            int decorationX = pTR.x - target.getSize().width - this.rightMargin;
            if (decorationX > pTL.x) {
                pDecoration.setX(decorationX);
            } else {
                pDecoration.setX(pTL.x);
            }
            target.setLocation(pDecoration);
        }
    }
}

