/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class UMLModelTester
extends PropertyTester {
    public static final String IS_UML_MODEL = "isUMLModel";
    public static final String IS_UML_PROFILE = "isUMLProfile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Boolean currentValue = null;
        if (IS_UML_MODEL.equals(property)) {
            currentValue = this.testUMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        if (IS_UML_PROFILE.equals(property)) {
            currentValue = this.testUMLProfileNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testUMLModelNature(Object receiver) {
        EObject root = this.getRoot(receiver);
        return root instanceof Package && !(root instanceof Profile);
    }

    protected boolean testUMLProfileNature(Object receiver) {
        return this.getRoot(receiver) instanceof Profile;
    }

    private EObject getRoot(Object receiver) {
        ModelSet modelSet = this.getModelSet(receiver);
        if (modelSet == null) {
            return null;
        }
        return this.getRoot(modelSet);
    }

    private ModelSet getModelSet(Object receiver) {
        if (receiver instanceof IWorkbenchPart) {
            try {
                IWorkbenchPart currentPart = (IWorkbenchPart)receiver;
                ServicesRegistry servicesRegistry = (ServicesRegistry)currentPart.getAdapter(ServicesRegistry.class);
                if (servicesRegistry != null) {
                    return ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
                }
                IEditorPart activeEditor = EditorHelper.getCurrentEditor();
                if (activeEditor != null && (servicesRegistry = (ServicesRegistry)activeEditor.getAdapter(ServicesRegistry.class)) != null) {
                    return ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private EObject getRoot(ModelSet modelSet) {
        UmlModel openedModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (openedModel != null) {
            EObject root;
            try {
                root = openedModel.lookupRoot();
            }
            catch (NotFoundException e) {
                return null;
            }
            return root;
        }
        return null;
    }
}

