/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;

public class CustomStateMachineSetBoundsCommand
extends AbstractTransactionalCommand {
    CreateViewRequest.ViewDescriptor viewDescriptor;
    Rectangle rect;
    Point location;
    Dimension size;

    public CustomStateMachineSetBoundsCommand(TransactionalEditingDomain domain, String label, CreateViewRequest.ViewDescriptor viewDescriptor, Rectangle rect) {
        super(domain, label, null);
        this.viewDescriptor = viewDescriptor;
        this.rect = rect;
        this.location = rect.getLocation();
        this.size = rect.getSize();
        this.setResult(CommandResult.newOKCommandResult((Object)viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View stateMachineView = (View)this.viewDescriptor.getAdapter(View.class);
        if (this.location != null) {
            Zone.setX(stateMachineView, this.location.x);
            Zone.setY(stateMachineView, this.location.y);
        }
        if (this.size != null && !this.size.equals(-1, -1)) {
            Zone.setWidth(stateMachineView, this.size.width);
            Zone.setHeight(stateMachineView, this.size.height);
        } else {
            Zone.setWidth(stateMachineView, 200);
            Zone.setHeight(stateMachineView, 100);
        }
        for (Object next : stateMachineView.getChildren()) {
            if (!(next instanceof Node)) continue;
            Node currentNode = (Node)next;
            if (currentNode.getLayoutConstraint() == null) {
                currentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
            }
            if (UMLVisualIDRegistry.getVisualID(currentNode.getType()) == 2001) {
                if (this.size != null && !this.size.equals(-1, -1)) {
                    Zone.setWidth((View)currentNode, this.size.width);
                    Zone.setHeight((View)currentNode, 13);
                    continue;
                }
                Zone.setWidth((View)currentNode, 200);
                Zone.setHeight((View)currentNode, 13);
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID(currentNode.getType()) != 2002) continue;
            Zone.setY((View)currentNode, 13);
            if (this.size != null && !this.size.equals(-1, -1)) {
                Zone.setWidth((View)currentNode, this.size.width);
                Zone.setHeight((View)currentNode, this.size.height - 13);
            } else {
                Zone.setWidth((View)currentNode, 200);
                Zone.setHeight((View)currentNode, 87);
            }
            int nRegions = currentNode.getChildren().size();
            String prefix = "";
            String zone = "";
            int i = 0;
            int width = 0;
            for (Object subnext : currentNode.getChildren()) {
                if (!(subnext instanceof Node)) continue;
                Node subCurrentNode = (Node)subnext;
                if (subCurrentNode.getLayoutConstraint() == null) {
                    subCurrentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
                }
                if (UMLVisualIDRegistry.getVisualID(subCurrentNode.getType()) != 3000) continue;
                if (this.size != null && !this.size.equals(-1, -1)) {
                    Zone.setWidth((View)subCurrentNode, i == nRegions - 1 ? this.size.width - width : this.size.width / nRegions);
                    Zone.setHeight((View)subCurrentNode, this.size.height - 13);
                    Zone.setX((View)subCurrentNode, width);
                    width += this.size.width / nRegions;
                } else {
                    Zone.setWidth((View)subCurrentNode, i == nRegions - 1 ? 200 - width : 200 / nRegions);
                    Zone.setHeight((View)subCurrentNode, 87);
                    Zone.setX((View)subCurrentNode, width);
                    width += 200 / nRegions;
                }
                zone = i == nRegions - 1 ? prefix : String.valueOf(prefix) + "L";
                Zone.setZone((View)subCurrentNode, zone);
                prefix = String.valueOf(prefix) + "R";
                ++i;
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

