/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.StereotypeRepairService;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.ZombieStereotypesDescriptor;
import org.eclipse.papyrus.uml.modelrepair.ui.IZombieStereotypePresenter;
import org.eclipse.papyrus.uml.modelrepair.ui.ZombieStereotypeDialogPresenter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeApplicationRepairSnippet
implements IModelSetSnippet {
    private final UMLResourceLoadAdapter adapter = new UMLResourceLoadAdapter();
    private final Function<? super ModelSet, ? extends IZombieStereotypePresenter> presenterFunction;
    private final Function<? super EPackage, Profile> dynamicProfileSupplier;
    private IZombieStereotypePresenter presenter;
    private LabelProviderService labelProviderService;
    private boolean localLabelProvider;

    public StereotypeApplicationRepairSnippet() {
        this(null, null);
    }

    public StereotypeApplicationRepairSnippet(Function<? super ModelSet, ? extends IZombieStereotypePresenter> presenterFunction) {
        this(presenterFunction, null);
    }

    protected StereotypeApplicationRepairSnippet(Function<? super ModelSet, ? extends IZombieStereotypePresenter> presenterFunction, Function<? super EPackage, Profile> dynamicProfileSupplier) {
        if (presenterFunction == null) {
            presenterFunction = new DefaultPresenterFunction();
        }
        this.presenterFunction = presenterFunction;
        this.dynamicProfileSupplier = dynamicProfileSupplier;
    }

    public static StereotypeApplicationRepairSnippet getInstance(ModelSet modelSet) {
        UMLResourceLoadAdapter adapter = (UMLResourceLoadAdapter)EcoreUtil.getExistingAdapter((Notifier)modelSet, StereotypeApplicationRepairSnippet.class);
        return adapter == null ? null : adapter.getSnippet();
    }

    public IStatus repair(ModelSet modelSet) {
        IStatus result = Status.OK_STATUS;
        if (this.presenter != null) {
            for (Resource next : ImmutableList.copyOf((Collection)modelSet.getResources())) {
                if (!next.isLoaded()) continue;
                this.handleResourceLoaded(next);
            }
            try {
                this.presenter.awaitPending(false);
                for (Resource next : ImmutableList.copyOf((Collection)modelSet.getResources())) {
                    if (!next.isLoaded() || this.getZombieStereotypes(next) == null) continue;
                    result = new Status(2, "org.eclipse.papyrus.uml.modelrepair", "Stereotype repair did not successfully repair all stereotype application problems.");
                    break;
                }
            }
            catch (InterruptedException e) {
                result = new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Stereotype repair was interrupted while waiting for user input.", (Throwable)e);
            }
        }
        return result;
    }

    public void repairAsync(final ModelSet modelSet, final FutureCallback<IStatus> onRepairCompleted) {
        if (this.presenter != null) {
            for (Resource next : ImmutableList.copyOf((Collection)modelSet.getResources())) {
                if (!next.isLoaded()) continue;
                this.handleResourceLoaded(next);
            }
            if (onRepairCompleted != null) {
                this.presenter.onPendingDone(new Runnable(){

                    public void run() {
                        IStatus result = Status.OK_STATUS;
                        try {
                            for (Resource next : ImmutableList.copyOf((Collection)modelSet.getResources())) {
                                if (!next.isLoaded() || StereotypeApplicationRepairSnippet.this.getZombieStereotypes(next) == null) continue;
                                result = new Status(2, "org.eclipse.papyrus.uml.modelrepair", "Stereotype repair did not successfully repair all stereotype application problems.");
                                break;
                            }
                            onRepairCompleted.onSuccess((Object)result);
                        }
                        catch (Exception e) {
                            onRepairCompleted.onFailure((Throwable)e);
                        }
                    }
                });
            }
        }
    }

    protected void handleResourceLoaded(Resource resource) {
        ModelSet modelSet = (ModelSet)resource.getResourceSet();
        if (this.presenter != null) {
            this.asyncComputeZombies(modelSet, resource);
        } else {
            this.computeZombies(modelSet, resource);
        }
    }

    private void computeZombies(final ModelSet modelSet, final Resource resource) {
        StereotypeRepairService.startedRepairing(modelSet, resource);
        boolean presented = false;
        try {
            ZombieStereotypesDescriptor zombies = this.getZombieStereotypes(resource);
            if (zombies != null && this.presenter != null) {
                this.presenter.addZombies(zombies);
                this.presenter.onPendingDone(new Runnable(){

                    public void run() {
                        StereotypeRepairService.finishedRepairing(modelSet, resource);
                    }
                });
                presented = true;
            }
        }
        finally {
            if (!presented) {
                StereotypeRepairService.finishedRepairing(modelSet, resource);
            }
        }
    }

    private void asyncComputeZombies(final ModelSet modelSet, final Resource resource) {
        Runnable block = new Runnable(){

            public void run() {
                StereotypeApplicationRepairSnippet.this.computeZombies(modelSet, resource);
            }
        };
        this.presenter.asyncAddZombies(block);
    }

    protected ZombieStereotypesDescriptor getZombieStereotypes(Resource resource) {
        Element rootElement;
        ModelSet modelSet;
        ZombieStereotypesDescriptor result = null;
        Element root = this.getRootUMLElement(resource);
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)root);
        if (domain == null && (modelSet = (ModelSet)this.adapter.getResourceSet()) != null) {
            domain = ((ModelSet)this.adapter.getResourceSet()).getTransactionalEditingDomain();
        }
        if (root instanceof Element && (domain == null || !EMFHelper.isReadOnly((Resource)resource, (EditingDomain)domain)) && (rootElement = root).getNearestPackage() != null) {
            result = this.getZombieStereotypes(resource, rootElement);
        }
        return result;
    }

    protected Element getRootUMLElement(Resource resource) {
        return (Element)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
    }

    protected ZombieStereotypesDescriptor getZombieStereotypes(Resource resource, Element root) {
        Package containingPackage;
        ZombieStereotypesDescriptor result = null;
        ArrayList profileApplications = Lists.newArrayList();
        TreeIterator iter = EcoreUtil.getAllProperContents(Collections.singleton(root), (boolean)false);
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (next instanceof ProfileApplication) {
                profileApplications.add((ProfileApplication)next);
                iter.prune();
                continue;
            }
            if (next instanceof Package || next instanceof Component) continue;
            iter.prune();
        }
        if (root.eContainer() instanceof Element && (containingPackage = ((Element)root.eContainer()).getNearestPackage()) != null) {
            profileApplications.addAll(containingPackage.getAllProfileApplications());
        }
        Set<EPackage> appliedDefinitions = this.getAppliedDefinitions(profileApplications);
        Function<? super EPackage, Profile> profileSupplier = this.dynamicProfileSupplier;
        if (profileSupplier == null) {
            profileSupplier = this.presenter.getDynamicProfileSupplier();
        }
        ZombieStereotypesDescriptor zombies = new ZombieStereotypesDescriptor(resource, root.getNearestPackage(), appliedDefinitions, profileSupplier, this.getLabelProvider());
        for (EObject next : resource.getContents()) {
            if (next instanceof Element) continue;
            zombies.analyze(next);
        }
        if (zombies.hasZombies()) {
            result = zombies;
        }
        return result;
    }

    protected Set<EPackage> getAppliedDefinitions(Iterable<? extends ProfileApplication> profileApplications) {
        HashSet result = Sets.newHashSet();
        for (ProfileApplication profileApplication : profileApplications) {
            EPackage registered;
            EPackage.Registry registry;
            EPackage definition = profileApplication.getAppliedDefinition();
            if (definition == null || definition.eIsProxy() || !result.add(definition) || (registry = this.getPackageRegistry()) == null || (registered = registry.getEPackage(definition.getNsURI())) == null || registered == definition) continue;
            result.add(registered);
        }
        return result;
    }

    private EPackage.Registry getPackageRegistry() {
        ResourceSet resourceSet = this.adapter.getResourceSet();
        return resourceSet == null ? EPackage.Registry.INSTANCE : resourceSet.getPackageRegistry();
    }

    private LabelProviderService getLabelProvider() {
        if (this.labelProviderService == null) {
            try {
                this.labelProviderService = (LabelProviderService)ServiceUtilsForResourceSet.getInstance().getService(LabelProviderService.class, (Object)this.adapter.getResourceSet());
            }
            catch (Exception e) {
                this.labelProviderService = new LabelProviderServiceImpl();
                this.localLabelProvider = true;
            }
        }
        return this.labelProviderService;
    }

    public void start(ModelSet modelsManager) {
        this.presenter = (IZombieStereotypePresenter)this.presenterFunction.apply((Object)modelsManager);
        if (this.presenter != null) {
            this.adapter.adapt((Notifier)modelsManager);
        }
    }

    public void dispose(ModelSet modelsManager) {
        block7: {
            if (this.presenter != null) {
                this.presenter.dispose();
                this.presenter = null;
            }
            if (this.localLabelProvider) {
                try {
                    try {
                        this.labelProviderService.disposeService();
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        this.labelProviderService = null;
                        this.localLabelProvider = false;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.labelProviderService = null;
                    this.localLabelProvider = false;
                    throw throwable;
                }
                this.labelProviderService = null;
                this.localLabelProvider = false;
            }
        }
        this.adapter.unadapt((Notifier)modelsManager);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultPresenterFunction
    implements Function<ResourceSet, IZombieStereotypePresenter> {
        private DefaultPresenterFunction() {
        }

        public IZombieStereotypePresenter apply(ResourceSet input) {
            ZombieStereotypeDialogPresenter result = null;
            try {
                IEditorPart editor = (IEditorPart)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)input);
                if (editor != null) {
                    result = new ZombieStereotypeDialogPresenter(editor.getSite().getShell(), input);
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            return result;
        }
    }

    private class UMLResourceLoadAdapter
    extends AdapterImpl {
        private UMLResourceLoadAdapter() {
        }

        public StereotypeApplicationRepairSnippet getSnippet() {
            return StereotypeApplicationRepairSnippet.this;
        }

        public boolean isAdapterForType(Object type) {
            return type == StereotypeApplicationRepairSnippet.class;
        }

        public void notifyChanged(Notification msg) {
            Object notifier = msg.getNotifier();
            if (notifier instanceof ResourceSet) {
                this.handleNotification((ResourceSet)notifier, msg);
            } else if (notifier instanceof Resource) {
                this.handleNotification((Resource)notifier, msg);
            }
        }

        ResourceSet getResourceSet() {
            return (ResourceSet)this.getTarget();
        }

        public void setTarget(Notifier newTarget) {
            Resource resource;
            if (newTarget == null || newTarget instanceof ResourceSet) {
                super.setTarget(newTarget);
            }
            if (newTarget instanceof ResourceSet) {
                for (Resource next : ImmutableList.copyOf((Collection)((ResourceSet)newTarget).getResources())) {
                    this.adapt((Notifier)next);
                }
            } else if (newTarget instanceof Resource && (resource = (Resource)newTarget).isLoaded()) {
                StereotypeApplicationRepairSnippet.this.handleResourceLoaded(resource);
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget == this.getResourceSet()) {
                for (Resource next : this.getResourceSet().getResources()) {
                    this.unadapt((Notifier)next);
                }
            }
            super.unsetTarget(oldTarget);
        }

        protected void adapt(Notifier notifier) {
            if (!notifier.eAdapters().contains((Object)this)) {
                notifier.eAdapters().add((Object)this);
            }
        }

        protected void unadapt(Notifier notifier) {
            notifier.eAdapters().remove((Object)this);
        }

        protected void handleNotification(ResourceSet rset, Notification msg) {
            block0 : switch (msg.getFeatureID(ResourceSet.class)) {
                case 0: {
                    switch (msg.getEventType()) {
                        case 3: {
                            this.adapt((Notifier)((Resource)msg.getNewValue()));
                            break block0;
                        }
                        case 5: {
                            for (Object next : (Collection)msg.getNewValue()) {
                                this.adapt((Notifier)((Resource)next));
                            }
                        }
                    }
                }
            }
        }

        protected void handleNotification(Resource resource, Notification msg) {
            switch (msg.getFeatureID(Resource.class)) {
                case 4: {
                    if (!msg.getNewBooleanValue()) break;
                    StereotypeApplicationRepairSnippet.this.handleResourceLoaded(resource);
                }
            }
        }
    }
}

